/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import com.mixpanel.android.mpmetrics.SystemInformation;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.OfflineMode;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

public class MPConfig {
    public static final String VERSION = "5.9.3";
    public static boolean DEBUG;
    public static final int UI_FEATURES_MIN_API = 16;
    static final String REFERRER_PREFS_NAME = "com.mixpanel.android.mpmetrics.ReferralInfo";
    static final int MAX_NOTIFICATION_CACHE_COUNT = 2;
    static final int MAX_EVENT_TRIGGERED_NOTIFICATION_CACHE_COUNT = 2;
    private final int mBulkUploadLimit;
    private final int mFlushInterval;
    private final boolean mFlushOnBackground;
    private final long mDataExpiration;
    private final int mMinimumDatabaseLimit;
    private final boolean mTestMode;
    private final boolean mDisableGestureBindingUI;
    private final boolean mDisableEmulatorBindingUI;
    private final boolean mDisableAppOpenEvent;
    private final boolean mDisableViewCrawler;
    private final boolean mDisableExceptionHandler;
    private final String[] mDisableViewCrawlerForProjects;
    private String mEventsEndpoint;
    private String mPeopleEndpoint;
    private String mGroupsEndpoint;
    private String mDecideEndpoint;
    private final boolean mAutoShowMixpanelUpdates;
    private final String mEditorUrl;
    private final String mResourcePackageName;
    private final boolean mDisableDecideChecker;
    private final int mImageCacheMaxMemoryFactor;
    private final boolean mIgnoreInvisibleViewsEditor;
    private final int mNotificationDefaults;
    private final int mMinSessionDuration;
    private final int mSessionTimeoutDuration;
    private boolean mUseIpAddressForGeolocation;
    private final int mNotificationChannelImportance;
    private final String mNotificationChannelId;
    private final String mNotificationChannelName;
    private SSLSocketFactory mSSLSocketFactory;
    private OfflineMode mOfflineMode;
    private static MPConfig sInstance;
    private static final Object sInstanceLock;
    private static final String LOGTAG = "MixpanelAPI.Conf";
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static MPConfig getInstance(Context context) {
        boolean[] blArray = MPConfig.$jacocoInit();
        Object object = sInstanceLock;
        synchronized (object) {
            try {
                blArray[0] = true;
                if (null != sInstance) {
                    blArray[1] = true;
                } else {
                    void appContext;
                    Context context2;
                    blArray[2] = true;
                    Context context3 = context2.getApplicationContext();
                    blArray[3] = true;
                    sInstance = MPConfig.readConfig((Context)appContext);
                    blArray[4] = true;
                }
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl17 : MonitorExitStatement: MONITOREXIT : var2_2
                blArray[5] = true;
                throw throwable;
            }
        }
        blArray[6] = true;
        return sInstance;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        void factory;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.mSSLSocketFactory = factory;
        blArray[7] = true;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setOfflineMode(OfflineMode offlineMode) {
        void offlineMode2;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.mOfflineMode = offlineMode2;
        blArray[8] = true;
    }

    /*
     * WARNING - void declaration
     */
    MPConfig(Bundle bundle, Context context) {
        void context2;
        void metaData;
        SSLSocketFactory foundSSLFactory;
        boolean[] blArray = MPConfig.$jacocoInit();
        try {
            void sslContext;
            blArray[9] = true;
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            blArray[10] = true;
            sslContext.init(null, null, null);
            blArray[11] = true;
            foundSSLFactory = sslContext.getSocketFactory();
            blArray[12] = true;
        }
        catch (GeneralSecurityException sslContext) {
            void e;
            blArray[13] = true;
            MPLog.i(LOGTAG, "System has no SSL support. Built-in events editor will not be available", (Throwable)e);
            foundSSLFactory = null;
            blArray[14] = true;
        }
        this.mSSLSocketFactory = foundSSLFactory;
        blArray[15] = true;
        DEBUG = metaData.getBoolean("com.mixpanel.android.MPConfig.EnableDebugLogging", false);
        if (!DEBUG) {
            blArray[16] = true;
        } else {
            blArray[17] = true;
            MPLog.setLevel(2);
            blArray[18] = true;
        }
        if (!metaData.containsKey("com.mixpanel.android.MPConfig.DebugFlushInterval")) {
            blArray[19] = true;
        } else {
            blArray[20] = true;
            MPLog.w(LOGTAG, "We do not support com.mixpanel.android.MPConfig.DebugFlushInterval anymore. There will only be one flush interval. Please, update your AndroidManifest.xml.");
            blArray[21] = true;
        }
        this.mBulkUploadLimit = metaData.getInt("com.mixpanel.android.MPConfig.BulkUploadLimit", 40);
        blArray[22] = true;
        this.mFlushInterval = metaData.getInt("com.mixpanel.android.MPConfig.FlushInterval", 60000);
        blArray[23] = true;
        this.mFlushOnBackground = metaData.getBoolean("com.mixpanel.android.MPConfig.FlushOnBackground", true);
        blArray[24] = true;
        this.mMinimumDatabaseLimit = metaData.getInt("com.mixpanel.android.MPConfig.MinimumDatabaseLimit", 0x1400000);
        blArray[25] = true;
        this.mResourcePackageName = metaData.getString("com.mixpanel.android.MPConfig.ResourcePackageName");
        blArray[26] = true;
        this.mDisableGestureBindingUI = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableGestureBindingUI", false);
        blArray[27] = true;
        this.mDisableEmulatorBindingUI = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableEmulatorBindingUI", false);
        blArray[28] = true;
        this.mDisableAppOpenEvent = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableAppOpenEvent", true);
        blArray[29] = true;
        this.mDisableViewCrawler = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableViewCrawler", false);
        blArray[30] = true;
        this.mDisableDecideChecker = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableDecideChecker", false);
        blArray[31] = true;
        this.mDisableExceptionHandler = metaData.getBoolean("com.mixpanel.android.MPConfig.DisableExceptionHandler", false);
        blArray[32] = true;
        this.mImageCacheMaxMemoryFactor = metaData.getInt("com.mixpanel.android.MPConfig.ImageCacheMaxMemoryFactor", 10);
        blArray[33] = true;
        this.mIgnoreInvisibleViewsEditor = metaData.getBoolean("com.mixpanel.android.MPConfig.IgnoreInvisibleViewsVisualEditor", false);
        blArray[34] = true;
        this.mAutoShowMixpanelUpdates = metaData.getBoolean("com.mixpanel.android.MPConfig.AutoShowMixpanelUpdates", true);
        blArray[35] = true;
        this.mNotificationDefaults = metaData.getInt("com.mixpanel.android.MPConfig.NotificationDefaults", 0);
        blArray[36] = true;
        this.mMinSessionDuration = metaData.getInt("com.mixpanel.android.MPConfig.MinimumSessionDuration", 10000);
        blArray[37] = true;
        this.mSessionTimeoutDuration = metaData.getInt("com.mixpanel.android.MPConfig.SessionTimeoutDuration", Integer.MAX_VALUE);
        blArray[38] = true;
        this.mUseIpAddressForGeolocation = metaData.getBoolean("com.mixpanel.android.MPConfig.UseIpAddressForGeolocation", true);
        blArray[39] = true;
        this.mTestMode = metaData.getBoolean("com.mixpanel.android.MPConfig.TestMode", false);
        blArray[40] = true;
        this.mNotificationChannelImportance = metaData.getInt("com.mixpanel.android.MPConfig.NotificationChannelImportance", 3);
        blArray[41] = true;
        Object dataExpirationMetaData = metaData.get("com.mixpanel.android.MPConfig.DataExpiration");
        long dataExpirationLong = 432000000L;
        if (dataExpirationMetaData == null) {
            blArray[42] = true;
        } else {
            try {
                blArray[43] = true;
                if (dataExpirationMetaData instanceof Integer) {
                    blArray[44] = true;
                    dataExpirationLong = ((Integer)dataExpirationMetaData).intValue();
                    blArray[45] = true;
                } else if (dataExpirationMetaData instanceof Float) {
                    blArray[46] = true;
                    dataExpirationLong = (long)((Float)dataExpirationMetaData).floatValue();
                    blArray[47] = true;
                } else {
                    blArray[48] = true;
                    throw new NumberFormatException(dataExpirationMetaData.toString() + " is not a number.");
                }
                blArray[49] = true;
            }
            catch (Exception exception) {
                void e;
                blArray[50] = true;
                MPLog.e(LOGTAG, "Error parsing com.mixpanel.android.MPConfig.DataExpiration meta-data value", (Throwable)e);
                blArray[51] = true;
            }
        }
        this.mDataExpiration = dataExpirationLong;
        blArray[52] = true;
        String notificationChannelId = metaData.getString("com.mixpanel.android.MPConfig.NotificationChannelId");
        if (notificationChannelId != null) {
            blArray[53] = true;
        } else {
            notificationChannelId = "mp";
            blArray[54] = true;
        }
        this.mNotificationChannelId = notificationChannelId;
        blArray[55] = true;
        String notificationChannelName = metaData.getString("com.mixpanel.android.MPConfig.NotificationChannelName");
        if (notificationChannelName != null) {
            blArray[56] = true;
        } else {
            blArray[57] = true;
            notificationChannelName = SystemInformation.getInstance((Context)context2).getAppName();
            blArray[58] = true;
        }
        this.mNotificationChannelName = notificationChannelName;
        blArray[59] = true;
        String eventsEndpoint = metaData.getString("com.mixpanel.android.MPConfig.EventsEndpoint");
        if (eventsEndpoint != null) {
            blArray[60] = true;
            this.setEventsEndpoint(eventsEndpoint);
            blArray[61] = true;
        } else {
            this.setEventsEndpointWithBaseURL("https://api.mixpanel.com");
            blArray[62] = true;
        }
        String peopleEndpoint = metaData.getString("com.mixpanel.android.MPConfig.PeopleEndpoint");
        if (peopleEndpoint != null) {
            blArray[63] = true;
            this.setPeopleEndpoint(peopleEndpoint);
            blArray[64] = true;
        } else {
            this.setPeopleEndpointWithBaseURL("https://api.mixpanel.com");
            blArray[65] = true;
        }
        String groupsEndpoint = metaData.getString("com.mixpanel.android.MPConfig.GroupsEndpoint");
        if (groupsEndpoint != null) {
            blArray[66] = true;
            this.setGroupsEndpoint(groupsEndpoint);
            blArray[67] = true;
        } else {
            this.setGroupsEndpointWithBaseURL("https://api.mixpanel.com");
            blArray[68] = true;
        }
        String decideEndpoint = metaData.getString("com.mixpanel.android.MPConfig.DecideEndpoint");
        if (decideEndpoint != null) {
            blArray[69] = true;
            this.setDecideEndpoint(decideEndpoint);
            blArray[70] = true;
        } else {
            this.setDecideEndpointWithBaseURL("https://api.mixpanel.com");
            blArray[71] = true;
        }
        String editorUrl = metaData.getString("com.mixpanel.android.MPConfig.EditorUrl");
        if (null != editorUrl) {
            blArray[72] = true;
        } else {
            editorUrl = "wss://switchboard.mixpanel.com/connect/";
            blArray[73] = true;
        }
        this.mEditorUrl = editorUrl;
        blArray[74] = true;
        int resourceId = metaData.getInt("com.mixpanel.android.MPConfig.DisableViewCrawlerForProjects", -1);
        if (resourceId != -1) {
            blArray[75] = true;
            this.mDisableViewCrawlerForProjects = context2.getResources().getStringArray(resourceId);
            blArray[76] = true;
        } else {
            this.mDisableViewCrawlerForProjects = new String[0];
            blArray[77] = true;
        }
        MPLog.v(LOGTAG, this.toString());
        blArray[78] = true;
    }

    public int getBulkUploadLimit() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[79] = true;
        return this.mBulkUploadLimit;
    }

    public int getFlushInterval() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[80] = true;
        return this.mFlushInterval;
    }

    public boolean getFlushOnBackground() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[81] = true;
        return this.mFlushOnBackground;
    }

    public long getDataExpiration() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[82] = true;
        return this.mDataExpiration;
    }

    public int getMinimumDatabaseLimit() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[83] = true;
        return this.mMinimumDatabaseLimit;
    }

    public boolean getDisableGestureBindingUI() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[84] = true;
        return this.mDisableGestureBindingUI;
    }

    public boolean getDisableEmulatorBindingUI() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[85] = true;
        return this.mDisableEmulatorBindingUI;
    }

    public boolean getDisableAppOpenEvent() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[86] = true;
        return this.mDisableAppOpenEvent;
    }

    public boolean getDisableViewCrawler() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[87] = true;
        return this.mDisableViewCrawler;
    }

    public String[] getDisableViewCrawlerForProjects() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[88] = true;
        return this.mDisableViewCrawlerForProjects;
    }

    public boolean getTestMode() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[89] = true;
        return this.mTestMode;
    }

    public String getEventsEndpoint() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[90] = true;
        return this.mEventsEndpoint;
    }

    /*
     * WARNING - void declaration
     */
    public void setServerURL(String string) {
        void serverURL;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.setEventsEndpointWithBaseURL((String)serverURL);
        blArray[91] = true;
        this.setPeopleEndpointWithBaseURL((String)serverURL);
        blArray[92] = true;
        this.setGroupsEndpointWithBaseURL((String)serverURL);
        blArray[93] = true;
        this.setDecideEndpointWithBaseURL((String)serverURL);
        blArray[94] = true;
    }

    /*
     * WARNING - void declaration
     */
    private String getEndPointWithIpTrackingParam(String string, boolean bl) {
        String string2;
        void ifUseIpAddressForGeolocation;
        void endPoint;
        boolean[] blArray = MPConfig.$jacocoInit();
        if (endPoint.contains("?ip=")) {
            String string3;
            blArray[95] = true;
            StringBuilder stringBuilder = new StringBuilder().append(endPoint.substring(0, endPoint.indexOf("?ip="))).append("?ip=");
            if (ifUseIpAddressForGeolocation != false) {
                string3 = "1";
                blArray[96] = true;
            } else {
                string3 = "0";
                blArray[97] = true;
            }
            blArray[98] = true;
            return stringBuilder.append(string3).toString();
        }
        StringBuilder stringBuilder = new StringBuilder().append((String)endPoint).append("?ip=");
        if (ifUseIpAddressForGeolocation != false) {
            string2 = "1";
            blArray[99] = true;
        } else {
            string2 = "0";
            blArray[100] = true;
        }
        blArray[101] = true;
        return stringBuilder.append(string2).toString();
    }

    /*
     * WARNING - void declaration
     */
    private void setEventsEndpointWithBaseURL(String string) {
        void baseURL;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.setEventsEndpoint(this.getEndPointWithIpTrackingParam((String)baseURL + "/track", this.getUseIpAddressForGeolocation()));
        blArray[102] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void setEventsEndpoint(String string) {
        void eventsEndpoint;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.mEventsEndpoint = eventsEndpoint;
        blArray[103] = true;
    }

    public String getPeopleEndpoint() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[104] = true;
        return this.mPeopleEndpoint;
    }

    /*
     * WARNING - void declaration
     */
    private void setPeopleEndpointWithBaseURL(String string) {
        void baseURL;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.setPeopleEndpoint(this.getEndPointWithIpTrackingParam((String)baseURL + "/engage", this.getUseIpAddressForGeolocation()));
        blArray[105] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void setPeopleEndpoint(String string) {
        void peopleEndpoint;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.mPeopleEndpoint = peopleEndpoint;
        blArray[106] = true;
    }

    public String getGroupsEndpoint() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[107] = true;
        return this.mGroupsEndpoint;
    }

    /*
     * WARNING - void declaration
     */
    private void setGroupsEndpointWithBaseURL(String string) {
        void baseURL;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.setGroupsEndpoint((String)baseURL + "/groups");
        blArray[108] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void setGroupsEndpoint(String string) {
        void groupsEndpoint;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.mGroupsEndpoint = groupsEndpoint;
        blArray[109] = true;
    }

    public String getDecideEndpoint() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[110] = true;
        return this.mDecideEndpoint;
    }

    /*
     * WARNING - void declaration
     */
    private void setDecideEndpointWithBaseURL(String string) {
        void baseURL;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.setDecideEndpoint((String)baseURL + "/decide");
        blArray[111] = true;
    }

    /*
     * WARNING - void declaration
     */
    private void setDecideEndpoint(String string) {
        void decideEndpoint;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.mDecideEndpoint = decideEndpoint;
        blArray[112] = true;
    }

    public boolean getAutoShowMixpanelUpdates() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[113] = true;
        return this.mAutoShowMixpanelUpdates;
    }

    public String getEditorUrl() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[114] = true;
        return this.mEditorUrl;
    }

    public boolean getDisableDecideChecker() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[115] = true;
        return this.mDisableDecideChecker;
    }

    public boolean getIgnoreInvisibleViewsEditor() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[116] = true;
        return this.mIgnoreInvisibleViewsEditor;
    }

    public int getNotificationDefaults() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[117] = true;
        return this.mNotificationDefaults;
    }

    public int getMinimumSessionDuration() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[118] = true;
        return this.mMinSessionDuration;
    }

    public int getSessionTimeoutDuration() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[119] = true;
        return this.mSessionTimeoutDuration;
    }

    public boolean getDisableExceptionHandler() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[120] = true;
        return this.mDisableExceptionHandler;
    }

    public String getNotificationChannelId() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[121] = true;
        return this.mNotificationChannelId;
    }

    public String getNotificationChannelName() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[122] = true;
        return this.mNotificationChannelName;
    }

    public int getNotificationChannelImportance() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[123] = true;
        return this.mNotificationChannelImportance;
    }

    private boolean getUseIpAddressForGeolocation() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[124] = true;
        return this.mUseIpAddressForGeolocation;
    }

    /*
     * WARNING - void declaration
     */
    public void setUseIpAddressForGeolocation(boolean bl) {
        void useIpAddressForGeolocation;
        boolean[] blArray = MPConfig.$jacocoInit();
        this.mUseIpAddressForGeolocation = useIpAddressForGeolocation;
        blArray[125] = true;
        this.setEventsEndpoint(this.getEndPointWithIpTrackingParam(this.getEventsEndpoint(), (boolean)useIpAddressForGeolocation));
        blArray[126] = true;
        this.setPeopleEndpoint(this.getEndPointWithIpTrackingParam(this.getPeopleEndpoint(), (boolean)useIpAddressForGeolocation));
        blArray[127] = true;
    }

    /*
     * WARNING - void declaration
     */
    public void setEnableLogging(boolean bl) {
        int n;
        void enableLogging;
        boolean[] blArray = MPConfig.$jacocoInit();
        DEBUG = enableLogging;
        blArray[128] = true;
        if (DEBUG) {
            n = 2;
            blArray[129] = true;
        } else {
            n = Integer.MAX_VALUE;
            blArray[130] = true;
        }
        MPLog.setLevel(n);
        blArray[131] = true;
    }

    public String getResourcePackageName() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[132] = true;
        return this.mResourcePackageName;
    }

    public synchronized SSLSocketFactory getSSLSocketFactory() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[133] = true;
        return this.mSSLSocketFactory;
    }

    public synchronized OfflineMode getOfflineMode() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[134] = true;
        return this.mOfflineMode;
    }

    public int getImageCacheMaxMemoryFactor() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[135] = true;
        return this.mImageCacheMaxMemoryFactor;
    }

    /*
     * WARNING - void declaration
     */
    static MPConfig readConfig(Context context) {
        void packageName;
        Context appContext;
        boolean[] blArray = MPConfig.$jacocoInit();
        String string = appContext.getPackageName();
        try {
            blArray[136] = true;
            ApplicationInfo appInfo = appContext.getPackageManager().getApplicationInfo((String)packageName, 128);
            Bundle configBundle = appInfo.metaData;
            if (null != configBundle) {
                blArray[137] = true;
            } else {
                blArray[138] = true;
                configBundle = new Bundle();
                blArray[139] = true;
            }
            blArray[140] = true;
            return new MPConfig(configBundle, appContext);
        }
        catch (PackageManager.NameNotFoundException appInfo) {
            void e;
            blArray[141] = true;
            blArray[142] = true;
            throw new RuntimeException("Can't configure Mixpanel with package name " + (String)packageName, (Throwable)e);
        }
    }

    public String toString() {
        boolean[] blArray = MPConfig.$jacocoInit();
        blArray[143] = true;
        blArray[144] = true;
        blArray[145] = true;
        blArray[146] = true;
        blArray[147] = true;
        blArray[148] = true;
        blArray[149] = true;
        blArray[150] = true;
        blArray[151] = true;
        blArray[152] = true;
        blArray[153] = true;
        blArray[154] = true;
        blArray[155] = true;
        blArray[156] = true;
        blArray[157] = true;
        blArray[158] = true;
        blArray[159] = true;
        blArray[160] = true;
        blArray[161] = true;
        blArray[162] = true;
        blArray[163] = true;
        blArray[164] = true;
        blArray[165] = true;
        blArray[166] = true;
        blArray[167] = true;
        blArray[168] = true;
        blArray[169] = true;
        return "Mixpanel (5.9.3) configured with:\n    AutoShowMixpanelUpdates " + this.getAutoShowMixpanelUpdates() + "\n    BulkUploadLimit " + this.getBulkUploadLimit() + "\n    FlushInterval " + this.getFlushInterval() + "\n    DataExpiration " + this.getDataExpiration() + "\n    MinimumDatabaseLimit " + this.getMinimumDatabaseLimit() + "\n    DisableAppOpenEvent " + this.getDisableAppOpenEvent() + "\n    DisableViewCrawler " + this.getDisableViewCrawler() + "\n    DisableGestureBindingUI " + this.getDisableGestureBindingUI() + "\n    DisableEmulatorBindingUI " + this.getDisableEmulatorBindingUI() + "\n    EnableDebugLogging " + DEBUG + "\n    TestMode " + this.getTestMode() + "\n    EventsEndpoint " + this.getEventsEndpoint() + "\n    PeopleEndpoint " + this.getPeopleEndpoint() + "\n    DecideEndpoint " + this.getDecideEndpoint() + "\n    EditorUrl " + this.getEditorUrl() + "\n    ImageCacheMaxMemoryFactor " + this.getImageCacheMaxMemoryFactor() + "\n    DisableDecideChecker " + this.getDisableDecideChecker() + "\n    IgnoreInvisibleViewsEditor " + this.getIgnoreInvisibleViewsEditor() + "\n    NotificationDefaults " + this.getNotificationDefaults() + "\n    MinimumSessionDuration: " + this.getMinimumSessionDuration() + "\n    SessionTimeoutDuration: " + this.getSessionTimeoutDuration() + "\n    DisableExceptionHandler: " + this.getDisableExceptionHandler() + "\n    NotificationChannelId: " + this.getNotificationChannelId() + "\n    NotificationChannelName: " + this.getNotificationChannelName() + "\n    NotificationChannelImportance: " + this.getNotificationChannelImportance() + "\n    FlushOnBackground: " + this.getFlushOnBackground() + "\n    UseIpAddressForGeolocation: " + this.getUseIpAddressForGeolocation();
    }

    static {
        boolean[] blArray = MPConfig.$jacocoInit();
        DEBUG = false;
        blArray[170] = true;
        sInstanceLock = new Object();
        blArray[171] = true;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-1885417955859283696L, (String)"com/mixpanel/android/mpmetrics/MPConfig", (int)172);
        }
        return blArray;
    }
}

