/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import com.mixpanel.android.util.MPLog;
import org.jacoco.agent.rt.internal_8ff85ea.Offline;

class FlipGesture
implements SensorEventListener {
    private int mTriggerState;
    private int mFlipState;
    private long mLastFlipTime;
    private final float[] mSmoothed;
    private final OnFlipGestureListener mListener;
    private static final float MINIMUM_GRAVITY_FOR_FLIP = 7.8f;
    private static final float MAXIMUM_GRAVITY_FOR_FLIP = 11.8f;
    private static final long MINIMUM_UP_DOWN_DURATION = 250000000L;
    private static final long MINIMUM_CANCEL_DURATION = 1000000000L;
    private static final int FLIP_STATE_UP = -1;
    private static final int FLIP_STATE_NONE = 0;
    private static final int FLIP_STATE_DOWN = 1;
    private static final int TRIGGER_STATE_NONE = 0;
    private static final int TRIGGER_STATE_BEGIN = 1;
    private static final float ACCELEROMETER_SMOOTHING = 0.7f;
    private static final String LOGTAG = "MixpanelAPI.FlipGesture";
    private static transient /* synthetic */ boolean[] $jacocoData;

    /*
     * WARNING - void declaration
     */
    public FlipGesture(OnFlipGestureListener onFlipGestureListener) {
        void listener;
        boolean[] blArray = FlipGesture.$jacocoInit();
        this.mTriggerState = -1;
        this.mFlipState = 0;
        this.mLastFlipTime = -1L;
        this.mSmoothed = new float[3];
        this.mListener = listener;
        blArray[0] = true;
    }

    /*
     * Unable to fully structure code
     */
    public void onSensorChanged(SensorEvent var1_1) {
        block23: {
            var2_2 = FlipGesture.$jacocoInit();
            smoothed = this.smoothXYZ(event.values);
            oldFlipState = this.mFlipState;
            totalGravitySquared = smoothed[0] * smoothed[0] + smoothed[1] * smoothed[1] + smoothed[2] * smoothed[2];
            minimumGravitySquared = 60.840004f;
            maximumGravitySquared = 139.24f;
            this.mFlipState = 0;
            if (!(smoothed[2] > 7.8f)) {
                var2_2[1] = true;
            } else if (!(smoothed[2] < 11.8f)) {
                var2_2[2] = true;
            } else {
                this.mFlipState = -1;
                var2_2[3] = true;
            }
            if (!(smoothed[2] < -7.8f)) {
                var2_2[4] = true;
            } else if (!(smoothed[2] > -11.8f)) {
                var2_2[5] = true;
            } else {
                this.mFlipState = 1;
                var2_2[6] = true;
            }
            if (!(totalGravitySquared < 60.840004f)) break block23;
            var2_2[7] = true;
            ** GOTO lbl32
        }
        if (!(totalGravitySquared > 139.24f)) {
            var2_2[8] = true;
        } else {
            var2_2[9] = true;
lbl32:
            // 2 sources

            this.mFlipState = 0;
            var2_2[10] = true;
        }
        if (oldFlipState == this.mFlipState) {
            var2_2[11] = true;
        } else {
            this.mLastFlipTime = event.timestamp;
            var2_2[12] = true;
        }
        flipDurationNanos = event.timestamp - this.mLastFlipTime;
        switch (this.mFlipState) {
            default: {
                var2_2[13] = true;
                break;
            }
            case 1: {
                if (flipDurationNanos <= 250000000L) {
                    var2_2[14] = true;
                    break;
                }
                if (this.mTriggerState != 0) {
                    var2_2[15] = true;
                    break;
                }
                var2_2[16] = true;
                MPLog.v("MixpanelAPI.FlipGesture", "Flip gesture begun");
                this.mTriggerState = 1;
                var2_2[17] = true;
                break;
            }
            case -1: {
                if (flipDurationNanos <= 250000000L) {
                    var2_2[18] = true;
                    break;
                }
                if (this.mTriggerState != 1) {
                    var2_2[19] = true;
                    break;
                }
                var2_2[20] = true;
                MPLog.v("MixpanelAPI.FlipGesture", "Flip gesture completed");
                this.mTriggerState = 0;
                var2_2[21] = true;
                this.mListener.onFlipGesture();
                var2_2[22] = true;
                break;
            }
            case 0: {
                if (flipDurationNanos <= 1000000000L) {
                    var2_2[23] = true;
                    break;
                }
                if (this.mTriggerState == 0) {
                    var2_2[24] = true;
                    break;
                }
                var2_2[25] = true;
                MPLog.v("MixpanelAPI.FlipGesture", "Flip gesture abandoned");
                this.mTriggerState = 0;
                var2_2[26] = true;
            }
        }
        var2_2[27] = true;
    }

    public void onAccuracyChanged(Sensor sensor, int n) {
        boolean[] blArray = FlipGesture.$jacocoInit();
        blArray[28] = true;
    }

    /*
     * WARNING - void declaration
     */
    private float[] smoothXYZ(float[] fArray) {
        void i;
        boolean[] blArray = FlipGesture.$jacocoInit();
        boolean bl = false;
        blArray[29] = true;
        while (i < 3) {
            void samples;
            float f;
            if (i < this.mSmoothed.length) {
                f = this.mSmoothed[i];
                blArray[30] = true;
            } else {
                f = 0.0f;
                blArray[31] = true;
            }
            float oldVal = f;
            this.mSmoothed[i] = oldVal + 0.7f * (samples[i] - oldVal);
            ++i;
            blArray[32] = true;
        }
        blArray[33] = true;
        return this.mSmoothed;
    }

    private static /* synthetic */ boolean[] $jacocoInit() {
        boolean[] blArray = $jacocoData;
        if ($jacocoData == null) {
            blArray = $jacocoData = Offline.getProbes((long)-5737532553310433593L, (String)"com/mixpanel/android/viewcrawler/FlipGesture", (int)34);
        }
        return blArray;
    }

    public static interface OnFlipGestureListener {
        public void onFlipGesture();
    }
}

