/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.util.MPLog;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@TargetApi(value=16)
public class UpdateDisplayState
implements Parcelable {
    public static final Parcelable.Creator<UpdateDisplayState> CREATOR = new Parcelable.Creator<UpdateDisplayState>(){

        public UpdateDisplayState createFromParcel(Parcel in) {
            Bundle read = new Bundle(UpdateDisplayState.class.getClassLoader());
            read.readFromParcel(in);
            return new UpdateDisplayState(read);
        }

        public UpdateDisplayState[] newArray(int size) {
            return new UpdateDisplayState[size];
        }
    };
    private final String mDistinctId;
    private final String mToken;
    private final DisplayState mDisplayState;
    private static final ReentrantLock sUpdateDisplayLock = new ReentrantLock();
    private static long sUpdateDisplayLockMillis = -1L;
    private static UpdateDisplayState sUpdateDisplayState = null;
    private static int sNextIntentId = 0;
    private static int sShowingIntentId = -1;
    private static final String LOGTAG = "MixpanelAPI.UpDisplSt";
    private static final long MAX_LOCK_TIME_MILLIS = 43200000L;
    private static final String DISTINCT_ID_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.DISTINCT_ID_BUNDLE_KEY";
    private static final String TOKEN_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.TOKEN_BUNDLE_KEY";
    private static final String DISPLAYSTATE_BUNDLE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.DISPLAYSTATE_BUNDLE_KEY";

    static ReentrantLock getLockObject() {
        return sUpdateDisplayLock;
    }

    static boolean hasCurrentProposal() {
        if (!sUpdateDisplayLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - sUpdateDisplayLockMillis;
        if (sNextIntentId > 0 && deltaTime > 43200000L) {
            MPLog.i(LOGTAG, "UpdateDisplayState set long, long ago, without showing. Update state will be cleared.");
            sUpdateDisplayState = null;
        }
        return null != sUpdateDisplayState;
    }

    static int proposeDisplay(DisplayState state, String distinctId, String token) {
        int ret = -1;
        if (!sUpdateDisplayLock.isHeldByCurrentThread()) {
            throw new AssertionError();
        }
        if (!UpdateDisplayState.hasCurrentProposal()) {
            sUpdateDisplayLockMillis = System.currentTimeMillis();
            sUpdateDisplayState = new UpdateDisplayState(state, distinctId, token);
            ret = ++sNextIntentId;
        } else {
            MPLog.v(LOGTAG, "Already showing (or cooking) a Mixpanel update, declining to show another.");
        }
        return ret;
    }

    public static void releaseDisplayState(int intentId) {
        sUpdateDisplayLock.lock();
        try {
            if (intentId == sShowingIntentId) {
                sShowingIntentId = -1;
                sUpdateDisplayState = null;
            }
        }
        finally {
            sUpdateDisplayLock.unlock();
        }
    }

    public static UpdateDisplayState claimDisplayState(int intentId) {
        sUpdateDisplayLock.lock();
        try {
            if (sShowingIntentId > 0 && sShowingIntentId != intentId) {
                UpdateDisplayState updateDisplayState = null;
                return updateDisplayState;
            }
            if (sUpdateDisplayState == null) {
                UpdateDisplayState updateDisplayState = null;
                return updateDisplayState;
            }
            sUpdateDisplayLockMillis = System.currentTimeMillis();
            sShowingIntentId = intentId;
            UpdateDisplayState updateDisplayState = sUpdateDisplayState;
            return updateDisplayState;
        }
        finally {
            sUpdateDisplayLock.unlock();
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        Bundle bundle = new Bundle();
        bundle.putString(DISTINCT_ID_BUNDLE_KEY, this.mDistinctId);
        bundle.putString(TOKEN_BUNDLE_KEY, this.mToken);
        bundle.putParcelable(DISPLAYSTATE_BUNDLE_KEY, (Parcelable)this.mDisplayState);
        dest.writeBundle(bundle);
    }

    public DisplayState getDisplayState() {
        return this.mDisplayState;
    }

    public String getDistinctId() {
        return this.mDistinctId;
    }

    public String getToken() {
        return this.mToken;
    }

    UpdateDisplayState(DisplayState displayState, String distinctId, String token) {
        this.mDistinctId = distinctId;
        this.mToken = token;
        this.mDisplayState = displayState;
    }

    private UpdateDisplayState(Bundle read) {
        this.mDistinctId = read.getString(DISTINCT_ID_BUNDLE_KEY);
        this.mToken = read.getString(TOKEN_BUNDLE_KEY);
        this.mDisplayState = (DisplayState)read.getParcelable(DISPLAYSTATE_BUNDLE_KEY);
    }

    public static class AnswerMap
    implements Parcelable {
        public static final Parcelable.Creator<AnswerMap> CREATOR = new Parcelable.Creator<AnswerMap>(){

            public AnswerMap createFromParcel(Parcel in) {
                Bundle read = new Bundle(AnswerMap.class.getClassLoader());
                AnswerMap ret = new AnswerMap();
                read.readFromParcel(in);
                for (String kString : read.keySet()) {
                    Integer kInt = Integer.valueOf(kString);
                    ret.put(kInt, read.getString(kString));
                }
                return ret;
            }

            public AnswerMap[] newArray(int size) {
                return new AnswerMap[size];
            }
        };
        private final HashMap<Integer, String> mMap = new HashMap();

        @SuppressLint(value={"UseSparseArrays"})
        public AnswerMap() {
        }

        public void put(Integer i, String s) {
            this.mMap.put(i, s);
        }

        public String get(Integer i) {
            return this.mMap.get(i);
        }

        public boolean contentEquals(AnswerMap other) {
            return this.mMap.equals(other.mMap);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            Bundle out = new Bundle();
            for (Map.Entry<Integer, String> entry : this.mMap.entrySet()) {
                String keyString = Integer.toString(entry.getKey());
                out.putString(keyString, entry.getValue());
            }
            dest.writeBundle(out);
        }
    }

    public static abstract class DisplayState
    implements Parcelable {
        public static final Parcelable.Creator<DisplayState> CREATOR = new Parcelable.Creator<DisplayState>(){

            public DisplayState createFromParcel(Parcel source) {
                Bundle read = new Bundle(DisplayState.class.getClassLoader());
                read.readFromParcel(source);
                String type = read.getString(DisplayState.STATE_TYPE_KEY);
                Bundle implementation = read.getBundle(DisplayState.STATE_IMPL_KEY);
                if ("InAppNotificationState".equals(type)) {
                    return new InAppNotificationState(implementation);
                }
                throw new RuntimeException("Unrecognized display state type " + type);
            }

            public DisplayState[] newArray(int size) {
                return new DisplayState[size];
            }
        };
        public static final String STATE_TYPE_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.DisplayState.STATE_TYPE_KEY";
        public static final String STATE_IMPL_KEY = "com.mixpanel.android.mpmetrics.UpdateDisplayState.DisplayState.STATE_IMPL_KEY";

        private DisplayState() {
        }

        public abstract String getType();

        public static final class InAppNotificationState
        extends DisplayState {
            public static final String TYPE = "InAppNotificationState";
            public static final Parcelable.Creator<InAppNotificationState> CREATOR = new Parcelable.Creator<InAppNotificationState>(){

                public InAppNotificationState createFromParcel(Parcel source) {
                    Bundle read = new Bundle(InAppNotificationState.class.getClassLoader());
                    read.readFromParcel(source);
                    return new InAppNotificationState(read);
                }

                public InAppNotificationState[] newArray(int size) {
                    return new InAppNotificationState[size];
                }
            };
            private final InAppNotification mInAppNotification;
            private final int mHighlightColor;
            private static String INAPP_KEY = "com.com.mixpanel.android.mpmetrics.UpdateDisplayState.InAppNotificationState.INAPP_KEY";
            private static String HIGHLIGHT_KEY = "com.com.mixpanel.android.mpmetrics.UpdateDisplayState.InAppNotificationState.HIGHLIGHT_KEY";

            public InAppNotificationState(InAppNotification notification, int highlightColor) {
                this.mInAppNotification = notification;
                this.mHighlightColor = highlightColor;
            }

            public int getHighlightColor() {
                return this.mHighlightColor;
            }

            public InAppNotification getInAppNotification() {
                return this.mInAppNotification;
            }

            @Override
            public String getType() {
                return TYPE;
            }

            public int describeContents() {
                return 0;
            }

            public void writeToParcel(Parcel dest, int flags) {
                Bundle write = new Bundle();
                write.putParcelable(INAPP_KEY, (Parcelable)this.mInAppNotification);
                write.putInt(HIGHLIGHT_KEY, this.mHighlightColor);
                dest.writeBundle(write);
            }

            private InAppNotificationState(Bundle in) {
                this.mInAppNotification = (InAppNotification)in.getParcelable(INAPP_KEY);
                this.mHighlightColor = in.getInt(HIGHLIGHT_KEY);
            }
        }
    }
}

