/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.takeoverinapp;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

public class FadingImageView
extends ImageView {
    private Matrix mGradientMatrix;
    private Paint mAlphaGradientPaint;
    private Shader mAlphaGradientShader;
    private Paint mDarkenGradientPaint;
    private Shader mDarkenGradientShader;
    private int mHeight;
    private int mWidth;
    private boolean mShouldShowShadow;

    public FadingImageView(Context context) {
        super(context);
        this.initFadingImageView();
    }

    public FadingImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initFadingImageView();
    }

    public FadingImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initFadingImageView();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mShouldShowShadow) {
            this.mHeight = this.getMeasuredHeight();
            this.mWidth = this.getMeasuredWidth();
            int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            this.mGradientMatrix.setScale(1.0f, (float)parentHeight);
            this.mAlphaGradientShader.setLocalMatrix(this.mGradientMatrix);
            this.mDarkenGradientShader.setLocalMatrix(this.mGradientMatrix);
        }
    }

    public void draw(Canvas canvas) {
        if (this.mShouldShowShadow) {
            Rect clip = canvas.getClipBounds();
            int restoreTo = 0;
            restoreTo = Build.VERSION.SDK_INT >= 26 ? canvas.saveLayer(0.0f, 0.0f, (float)clip.width(), (float)clip.height(), null) : canvas.saveLayer(0.0f, 0.0f, (float)clip.width(), (float)clip.height(), null, 31);
            super.draw(canvas);
            canvas.drawRect(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight, this.mAlphaGradientPaint);
            canvas.restoreToCount(restoreTo);
        } else {
            super.draw(canvas);
        }
    }

    private void initFadingImageView() {
        this.mGradientMatrix = new Matrix();
        this.mAlphaGradientPaint = new Paint();
        this.mAlphaGradientShader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, new int[]{-16777216, -16777216, -452984832, 0}, new float[]{0.0f, 0.2f, 0.4f, 1.0f}, Shader.TileMode.CLAMP);
        this.mAlphaGradientPaint.setShader(this.mAlphaGradientShader);
        this.mAlphaGradientPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        this.mDarkenGradientPaint = new Paint();
        this.mDarkenGradientShader = new LinearGradient(0.0f, 0.0f, 0.0f, 1.0f, new int[]{0, 0, -16777216, -16777216}, new float[]{0.0f, 0.85f, 0.98f, 1.0f}, Shader.TileMode.CLAMP);
        this.mDarkenGradientPaint.setShader(this.mDarkenGradientShader);
        this.mAlphaGradientPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
    }

    public void showShadow(boolean shouldShowShadow) {
        this.mShouldShowShadow = shouldShowShadow;
    }
}

