/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.app.Activity;
import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.webkit.URLUtil;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.MixpanelFCMMessagingService;
import com.mixpanel.android.mpmetrics.MixpanelNotificationData;
import com.mixpanel.android.util.MPLog;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelNotificationRouteActivity
extends Activity {
    protected final String LOGTAG = "MixpanelAPI.MixpanelNotificationRouteActivity";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent routeIntent = this.getIntent();
        Bundle extras = routeIntent.getExtras();
        if (null == routeIntent) {
            MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Notification route activity given null intent.");
            return;
        }
        this.trackTapAction(routeIntent);
        Intent notificationIntent = this.handleRouteIntent(routeIntent);
        if (!extras.getBoolean("mp_is_sticky")) {
            MixpanelFCMMessagingService fcmMessagingService = new MixpanelFCMMessagingService();
            Context context = this.getApplicationContext();
            this.getApplicationContext();
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            fcmMessagingService.cancelNotification(extras, notificationManager);
        }
        this.startActivity(notificationIntent);
    }

    protected Intent handleRouteIntent(Intent routeIntent) {
        MixpanelNotificationData.PushTapActionType target;
        CharSequence actionTypeChars = routeIntent.getExtras().getCharSequence("mp_tap_action_type");
        if (null == actionTypeChars) {
            MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Notification action click logged with no action type");
            target = MixpanelNotificationData.PushTapActionType.HOMESCREEN;
        } else {
            target = MixpanelNotificationData.PushTapActionType.fromString(actionTypeChars.toString());
        }
        CharSequence uri = routeIntent.getExtras().getCharSequence("mp_tap_action_uri");
        Intent defaultIntent = this.getPackageManager().getLaunchIntentForPackage(this.getPackageName());
        switch (target) {
            case HOMESCREEN: {
                return defaultIntent;
            }
            case URL_IN_BROWSER: {
                if (URLUtil.isValidUrl((String)uri.toString())) {
                    return new Intent("android.intent.action.VIEW", Uri.parse((String)uri.toString())).addCategory("android.intent.category.BROWSABLE");
                }
                MPLog.d("MixpanelAPI.MixpanelNotificationRouteActivity", "Wanted to open url in browser but url is invalid: " + uri.toString() + ". Starting default intent");
                return defaultIntent;
            }
            case DEEP_LINK: {
                return new Intent("android.intent.action.VIEW", Uri.parse((String)uri.toString()));
            }
        }
        return defaultIntent;
    }

    protected void trackTapAction(Intent routeIntent) {
        String buttonLabel;
        String buttonId;
        String tapTarget = routeIntent.getStringExtra("mp_tap_target");
        String tapActionType = routeIntent.getStringExtra("mp_tap_action_type");
        String tapActionUri = routeIntent.getStringExtra("mp_tap_action_uri");
        Boolean sticky = routeIntent.getBooleanExtra("mp_is_sticky", false);
        if (tapTarget != null && tapTarget.equals("button")) {
            buttonId = routeIntent.getStringExtra("mp_button_id");
            buttonLabel = routeIntent.getStringExtra("mp_button_label");
        } else {
            buttonId = null;
            buttonLabel = null;
        }
        JSONObject additionalProperties = new JSONObject();
        try {
            additionalProperties.putOpt("$tap_target", (Object)tapTarget);
            additionalProperties.putOpt("$tap_action_type", (Object)tapActionType);
            additionalProperties.putOpt("$tap_action_uri", (Object)tapActionUri);
            additionalProperties.putOpt("$is_sticky", (Object)sticky);
            additionalProperties.putOpt("$button_id", (Object)buttonId);
            additionalProperties.putOpt("$button_label", (Object)buttonLabel);
        }
        catch (JSONException e) {
            MPLog.e("MixpanelAPI.MixpanelNotificationRouteActivity", "Error adding tracking JSON properties.", e);
        }
        MixpanelAPI.trackPushNotificationEventFromIntent(this.getApplicationContext(), routeIntent, "$push_notification_tap", additionalProperties);
    }
}

