/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.MixpanelNotificationData;
import com.mixpanel.android.mpmetrics.ResourceIds;
import com.mixpanel.android.mpmetrics.ResourceReader;
import com.mixpanel.android.util.ImageStore;
import com.mixpanel.android.util.MPLog;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelPushNotification {
    private final String LOGTAG = "MixpanelAPI.MixpanelPushNotification";
    private static final String DATETIME_NO_TZ = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String DATETIME_WITH_TZ = "yyyy-MM-dd'T'HH:mm:ssz";
    private static final String DATETIME_ZULU_TZ = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private Context mContext;
    private ResourceIds mDrawableIds;
    private Notification.Builder mBuilder;
    private long mNow;
    private MixpanelNotificationData mData;

    public MixpanelPushNotification(Context context) {
        this(context, new Notification.Builder(context), System.currentTimeMillis());
    }

    public MixpanelPushNotification(Context context, Notification.Builder builder, long now) {
        this.mContext = context;
        this.mBuilder = builder;
        this.mDrawableIds = this.getResourceIds(context);
        this.mNow = now;
    }

    Notification createNotification(Intent inboundIntent) {
        this.parseIntent(inboundIntent);
        if (this.mData == null) {
            return null;
        }
        if (this.mData.isSilent()) {
            MPLog.d("MixpanelAPI.MixpanelPushNotification", "Notification will not be shown because 'mp_silent = true'");
            return null;
        }
        if (this.mData.getMessage() == null) {
            MPLog.d("MixpanelAPI.MixpanelPushNotification", "Notification will not be shown because 'mp_message' was null");
            return null;
        }
        if (this.mData.getMessage().equals("")) {
            MPLog.d("MixpanelAPI.MixpanelPushNotification", "Notification will not be shown because 'mp_message' was empty");
            return null;
        }
        this.buildNotificationFromData();
        Notification n = Build.VERSION.SDK_INT >= 16 ? this.mBuilder.build() : this.mBuilder.getNotification();
        if (!this.mData.isSticky()) {
            n.flags |= 0x10;
        }
        return n;
    }

    void parseIntent(Intent inboundIntent) {
        ArrayList<MixpanelNotificationData.MixpanelNotificationButtonData> buttons = new ArrayList<MixpanelNotificationData.MixpanelNotificationButtonData>();
        String message = inboundIntent.getStringExtra("mp_message");
        String iconName = inboundIntent.getStringExtra("mp_icnm");
        String largeIconName = inboundIntent.getStringExtra("mp_icnm_l");
        String whiteIconName = inboundIntent.getStringExtra("mp_icnm_w");
        String expandableImageURL = inboundIntent.getStringExtra("mp_img");
        String uriString = inboundIntent.getStringExtra("mp_cta");
        CharSequence notificationTitle = inboundIntent.getStringExtra("mp_title");
        String notificationSubText = inboundIntent.getStringExtra("mp_subtxt");
        String colorName = inboundIntent.getStringExtra("mp_color");
        String buttonsJsonStr = inboundIntent.getStringExtra("mp_buttons");
        String campaignId = inboundIntent.getStringExtra("mp_campaign_id");
        String messageId = inboundIntent.getStringExtra("mp_message_id");
        String extraLogData = inboundIntent.getStringExtra("mp");
        int badgeCount = inboundIntent.getIntExtra("mp_bdgcnt", -1);
        String channelId = inboundIntent.getStringExtra("mp_channel_id");
        String notificationTag = inboundIntent.getStringExtra("mp_tag");
        String groupKey = inboundIntent.getStringExtra("mp_groupkey");
        String ticker = inboundIntent.getStringExtra("mp_ticker");
        String stickyString = inboundIntent.getStringExtra("mp_sticky");
        String timeString = inboundIntent.getStringExtra("mp_time");
        int visibility = inboundIntent.getIntExtra("mp_visibility", 0);
        String silent = inboundIntent.getStringExtra("mp_silent");
        this.trackCampaignReceived(campaignId, messageId, extraLogData);
        this.mData = new MixpanelNotificationData();
        this.mData.setMessage(message);
        this.mData.setLargeIconName(largeIconName);
        this.mData.setExpandableImageUrl(expandableImageURL);
        this.mData.setBadgeCount(badgeCount);
        this.mData.setTag(notificationTag);
        this.mData.setGroupKey(groupKey);
        this.mData.setTicker(ticker);
        this.mData.setTimeString(timeString);
        this.mData.setVisibility(visibility);
        if (channelId != null) {
            this.mData.setChannelId(channelId);
        }
        int color = -1;
        if (colorName != null) {
            try {
                color = Color.parseColor((String)colorName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.mData.setColor(color);
        if (notificationSubText != null && notificationSubText.length() == 0) {
            notificationSubText = null;
        }
        this.mData.setSubText(notificationSubText);
        boolean isSilent = silent != null && silent.equals("true");
        this.mData.setSilent(isSilent);
        boolean sticky = stickyString != null && stickyString.equals("true");
        this.mData.setSticky(sticky);
        int notificationIcon = -1;
        if (iconName != null && this.mDrawableIds.knownIdName(iconName)) {
            notificationIcon = this.mDrawableIds.idFromName(iconName);
        }
        if (notificationIcon == -1) {
            notificationIcon = this.getDefaultIcon();
        }
        this.mData.setIcon(notificationIcon);
        int whiteNotificationIcon = -1;
        if (whiteIconName != null && this.mDrawableIds.knownIdName(whiteIconName)) {
            whiteNotificationIcon = this.mDrawableIds.idFromName(whiteIconName);
        }
        this.mData.setWhiteIcon(whiteNotificationIcon);
        if (notificationTitle == null || notificationTitle.length() == 0) {
            notificationTitle = this.getDefaultTitle();
        }
        this.mData.setTitle(notificationTitle);
        if (buttonsJsonStr != null) {
            try {
                JSONArray buttonsArr = new JSONArray(buttonsJsonStr);
                for (int i = 0; i < buttonsArr.length(); ++i) {
                    String btnIconName;
                    MixpanelNotificationData.MixpanelNotificationButtonData buttonData = new MixpanelNotificationData.MixpanelNotificationButtonData();
                    JSONObject buttonObj = buttonsArr.getJSONObject(i);
                    int btnIcon = -1;
                    if (buttonObj.has("icnm") && this.mDrawableIds.knownIdName(btnIconName = buttonObj.getString("icnm"))) {
                        btnIcon = this.mDrawableIds.idFromName(btnIconName);
                    }
                    buttonData.setIcon(btnIcon);
                    String btnLabel = buttonObj.getString("lbl");
                    buttonData.setLabel(btnLabel);
                    String btnUri = buttonObj.getString("uri");
                    buttonData.setUri(btnUri);
                    buttons.add(buttonData);
                }
            }
            catch (JSONException e) {
                MPLog.e("MixpanelAPI.MixpanelPushNotification", "Exception parsing buttons payload", e);
            }
        }
        this.mData.setButtons(buttons);
        Uri uri = null;
        if (uriString != null) {
            uri = Uri.parse((String)uriString);
        }
        Intent intent = uri == null ? this.getDefaultIntent() : this.buildIntentForUri(uri);
        Intent notificationIntent = this.buildNotificationIntent(intent, campaignId, messageId, extraLogData);
        this.mData.setIntent(notificationIntent);
    }

    protected void buildNotificationFromData() {
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)this.mData.getIntent(), (int)0x8000000);
        this.mBuilder.setContentTitle(this.mData.getTitle()).setContentText((CharSequence)this.mData.getMessage()).setTicker((CharSequence)(this.mData.getTicker() == null ? this.mData.getMessage() : this.mData.getTicker())).setContentIntent(contentIntent);
        this.maybeSetNotificationBarIcon();
        this.maybeSetLargeIcon();
        this.maybeSetExpandableNotification();
        this.maybeSetCustomIconColor();
        this.maybeAddActionButtons();
        this.maybeSetChannel();
        this.maybeSetNotificationBadge();
        this.maybeSetTime();
        this.maybeSetVisibility();
        this.maybeSetSubText();
    }

    protected void maybeSetSubText() {
        if (Build.VERSION.SDK_INT >= 16 && this.mData.getSubText() != null) {
            this.mBuilder.setSubText(this.mData.getSubText());
        }
    }

    protected void maybeSetNotificationBarIcon() {
        if (Build.VERSION.SDK_INT >= 21 && this.mData.getWhiteIcon() != -1) {
            this.mBuilder.setSmallIcon(this.mData.getWhiteIcon());
        } else {
            this.mBuilder.setSmallIcon(this.mData.getIcon());
        }
    }

    protected void maybeSetLargeIcon() {
        if (this.mData.getLargeIconName() != null) {
            if (this.mDrawableIds.knownIdName(this.mData.getLargeIconName())) {
                this.mBuilder.setLargeIcon(this.getBitmapFromResourceId(this.mDrawableIds.idFromName(this.mData.getLargeIconName())));
            } else if (this.mData.getLargeIconName().startsWith("http")) {
                Bitmap imageBitmap = this.getBitmapFromUrl(this.mData.getLargeIconName());
                if (imageBitmap != null) {
                    this.mBuilder.setLargeIcon(imageBitmap);
                }
            } else {
                MPLog.d("MixpanelAPI.MixpanelPushNotification", "large icon data was sent but did match a resource name or a valid url: " + this.mData.getLargeIconName());
            }
        }
    }

    protected void maybeSetExpandableNotification() {
        block6: {
            if (Build.VERSION.SDK_INT >= 16) {
                if (null != this.mData.getExpandableImageUrl() && this.mData.getExpandableImageUrl().startsWith("http")) {
                    try {
                        Bitmap imageBitmap = this.getBitmapFromUrl(this.mData.getExpandableImageUrl());
                        if (imageBitmap == null) {
                            this.setBigTextStyle(this.mData.getMessage());
                            break block6;
                        }
                        this.setBigPictureStyle(imageBitmap);
                    }
                    catch (Exception e) {
                        this.setBigTextStyle(this.mData.getMessage());
                    }
                } else {
                    this.setBigTextStyle(this.mData.getMessage());
                }
            }
        }
    }

    protected void setBigTextStyle(String message) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mBuilder.setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)message));
        }
    }

    protected void setBigPictureStyle(Bitmap imageBitmap) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.mBuilder.setStyle((Notification.Style)new Notification.BigPictureStyle().bigPicture(imageBitmap));
        }
    }

    protected void maybeSetCustomIconColor() {
        if (Build.VERSION.SDK_INT >= 21 && this.mData.getColor() != -1) {
            this.mBuilder.setColor(this.mData.getColor());
        }
    }

    protected void maybeAddActionButtons() {
        if (Build.VERSION.SDK_INT >= 20) {
            for (int i = 0; i < this.mData.getButtons().size(); ++i) {
                MixpanelNotificationData.MixpanelNotificationButtonData btn = this.mData.getButtons().get(i);
                this.mBuilder.addAction(this.createAction(btn.getIcon(), btn.getLabel(), btn.getUri()));
            }
        }
    }

    private PendingIntent createActionIntent(String uri) {
        return PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)new Intent("android.intent.action.VIEW", Uri.parse((String)uri)), (int)0x8000000);
    }

    protected void maybeSetChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
            String channelId = this.mData.getChannelId() == null ? MPConfig.getInstance(this.mContext).getNotificationChannelId() : this.mData.getChannelId();
            String channelName = MPConfig.getInstance(this.mContext).getNotificationChannelName();
            NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, 3);
            mNotificationManager.createNotificationChannel(channel);
            this.mBuilder.setChannelId(channelId);
        } else {
            this.mBuilder.setDefaults(MPConfig.getInstance(this.mContext).getNotificationDefaults());
        }
    }

    protected void maybeSetNotificationBadge() {
        if (this.mData.getBadgeCount() > 0) {
            this.mBuilder.setNumber(this.mData.getBadgeCount());
        }
    }

    protected void maybeSetTime() {
        if (Build.VERSION.SDK_INT >= 17) {
            this.mBuilder.setShowWhen(true);
        }
        if (this.mData.getTimeString() == null) {
            this.mBuilder.setWhen(this.mNow);
        } else {
            Date dt = this.parseDateTime(DATETIME_WITH_TZ, this.mData.getTimeString());
            if (null == dt) {
                dt = this.parseDateTime(DATETIME_ZULU_TZ, this.mData.getTimeString());
            }
            if (null == dt) {
                dt = this.parseDateTime(DATETIME_NO_TZ, this.mData.getTimeString());
            }
            if (null == dt) {
                MPLog.d("MixpanelAPI.MixpanelPushNotification", "Unable to parse date string into datetime: " + this.mData.getTimeString());
            } else {
                this.mBuilder.setWhen(dt.getTime());
            }
        }
    }

    protected void maybeSetVisibility() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mBuilder.setVisibility(this.mData.getVisibility());
        }
    }

    protected CharSequence getDefaultTitle() {
        ApplicationInfo appInfo = this.getAppInfo();
        if (null != appInfo) {
            return this.mContext.getPackageManager().getApplicationLabel(appInfo);
        }
        return "A message for you";
    }

    protected int getDefaultIcon() {
        ApplicationInfo appInfo = this.getAppInfo();
        if (null != appInfo) {
            return appInfo.icon;
        }
        return 17301651;
    }

    protected void trackCampaignReceived(final String campaignId, final String messageId, final String extraLogData) {
        if (campaignId != null && messageId != null) {
            MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

                @Override
                public void process(MixpanelAPI api) {
                    if (api.isAppInForeground()) {
                        JSONObject pushProps = new JSONObject();
                        try {
                            if (extraLogData != null) {
                                pushProps = new JSONObject(extraLogData);
                            }
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        try {
                            pushProps.put("campaign_id", Integer.valueOf(campaignId).intValue());
                            pushProps.put("message_id", Integer.valueOf(messageId).intValue());
                            pushProps.put("message_type", (Object)"push");
                            api.track("$campaign_received", pushProps);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    private Date parseDateTime(String format, String datetime) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
            if (format.equals(DATETIME_ZULU_TZ)) {
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            }
            return sdf.parse(datetime);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private ApplicationInfo getAppInfo() {
        try {
            return this.mContext.getPackageManager().getApplicationInfo(this.mContext.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    Intent buildNotificationIntent(Intent intent, String campaignId, String messageId, String extraLogData) {
        if (campaignId != null) {
            intent.putExtra("mp_campaign_id", campaignId);
        }
        if (messageId != null) {
            intent.putExtra("mp_message_id", messageId);
        }
        if (extraLogData != null) {
            intent.putExtra("mp", extraLogData);
        }
        return intent;
    }

    Intent getDefaultIntent() {
        return this.mContext.getPackageManager().getLaunchIntentForPackage(this.mContext.getPackageName());
    }

    Intent buildIntentForUri(Uri uri) {
        return new Intent("android.intent.action.VIEW", uri);
    }

    MixpanelNotificationData getData() {
        return this.mData;
    }

    Bitmap getBitmapFromResourceId(int resourceId) {
        return BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)resourceId);
    }

    @TargetApi(value=20)
    Notification.Action createAction(int icon, CharSequence title, String uri) {
        return new Notification.Action.Builder(icon, title, this.createActionIntent(uri)).build();
    }

    Bitmap getBitmapFromUrl(String url) {
        ImageStore is = new ImageStore(this.mContext, "MixpanelPushNotification");
        try {
            return is.getImage(url);
        }
        catch (ImageStore.CantGetImageException e) {
            return null;
        }
    }

    ResourceIds getResourceIds(Context context) {
        MPConfig config = MPConfig.getInstance(context);
        String resourcePackage = config.getResourcePackageName();
        if (null == resourcePackage) {
            resourcePackage = context.getPackageName();
        }
        return new ResourceReader.Drawables(resourcePackage, context);
    }
}

