/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.ResourceIds;
import com.mixpanel.android.mpmetrics.ResourceReader;
import com.mixpanel.android.util.MPLog;
import org.json.JSONException;
import org.json.JSONObject;

public class MixpanelFCMMessagingService
extends FirebaseMessagingService {
    private static final String LOGTAG = "MixpanelAPI.MixpanelFCMMessagingService";

    static void init() {
        FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

            public void onComplete(Task<InstanceIdResult> task) {
                if (task.isSuccessful()) {
                    String registrationId = ((InstanceIdResult)task.getResult()).getToken();
                    MixpanelFCMMessagingService.addToken(registrationId);
                }
            }
        });
    }

    public void onMessageReceived(RemoteMessage remoteMessage) {
        super.onMessageReceived(remoteMessage);
        MPLog.d(LOGTAG, "MP FCM on new message received");
        this.onMessageReceived(this.getApplicationContext(), remoteMessage.toIntent());
    }

    public void onNewToken(String token) {
        super.onNewToken(token);
        MPLog.d(LOGTAG, "MP FCM on new push token: " + token);
        MixpanelFCMMessagingService.addToken(token);
    }

    protected void onMessageReceived(Context context, Intent intent) {
        MixpanelFCMMessagingService.showPushNotification(context, intent);
    }

    public static void showPushNotification(Context context, Intent messageIntent) {
        MPConfig config = MPConfig.getInstance(context);
        String resourcePackage = config.getResourcePackageName();
        if (null == resourcePackage) {
            resourcePackage = context.getPackageName();
        }
        ResourceReader.Drawables drawableIds = new ResourceReader.Drawables(resourcePackage, context);
        Context applicationContext = context.getApplicationContext();
        Notification notification = MixpanelFCMMessagingService.buildNotification(applicationContext, messageIntent, drawableIds);
        if (null != notification) {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            notificationManager.notify(0, notification);
        }
    }

    public static void addToken(final String token) {
        MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

            @Override
            public void process(MixpanelAPI api) {
                api.getPeople().setPushRegistrationId(token);
            }
        });
    }

    private static Notification buildNotification(Context context, Intent inboundIntent, ResourceIds iconIds) {
        PackageManager manager = context.getPackageManager();
        Intent defaultIntent = manager.getLaunchIntentForPackage(context.getPackageName());
        NotificationData notificationData = MixpanelFCMMessagingService.readInboundIntent(context, inboundIntent, iconIds, defaultIntent);
        if (null == notificationData) {
            return null;
        }
        MPLog.d(LOGTAG, "MP FCM notification received: " + notificationData.message);
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)notificationData.intent, (int)0x8000000);
        Notification notification = Build.VERSION.SDK_INT >= 26 ? MixpanelFCMMessagingService.makeNotificationSDK26OrHigher(context, contentIntent, notificationData) : (Build.VERSION.SDK_INT >= 21 ? MixpanelFCMMessagingService.makeNotificationSDK21OrHigher(context, contentIntent, notificationData) : (Build.VERSION.SDK_INT >= 16 ? MixpanelFCMMessagingService.makeNotificationSDK16OrHigher(context, contentIntent, notificationData) : MixpanelFCMMessagingService.makeNotificationSDK11OrHigher(context, contentIntent, notificationData)));
        return notification;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=26)
    protected static Notification makeNotificationSDK26OrHigher(Context context, PendingIntent intent, NotificationData notificationData) {
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        String channelId = MPConfig.getInstance(context).getNotificationChannelId();
        String channelName = MPConfig.getInstance(context).getNotificationChannelName();
        int importance = MPConfig.getInstance(context).getNotificationChannelImportance();
        NotificationChannel channel = new NotificationChannel(channelId, (CharSequence)channelName, importance);
        int notificationDefaults = MPConfig.getInstance(context).getNotificationDefaults();
        if (notificationDefaults == 2 || notificationDefaults == -1) {
            channel.enableVibration(true);
        }
        if (notificationDefaults == 4 || notificationDefaults == -1) {
            channel.enableLights(true);
            channel.setLightColor(-1);
        }
        mNotificationManager.createNotificationChannel(channel);
        Notification.Builder builder = new Notification.Builder(context).setTicker((CharSequence)notificationData.message).setWhen(System.currentTimeMillis()).setContentTitle(notificationData.title).setContentText((CharSequence)notificationData.message).setContentIntent(intent).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)notificationData.message)).setChannelId(channelId);
        if (notificationData.whiteIcon != -1) {
            builder.setSmallIcon(notificationData.whiteIcon);
        } else {
            builder.setSmallIcon(notificationData.icon);
        }
        if (notificationData.largeIcon != -1) {
            builder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)notificationData.largeIcon));
        }
        if (notificationData.color != -1) {
            builder.setColor(notificationData.color);
        }
        Notification n = builder.build();
        n.flags |= 0x10;
        return n;
    }

    @TargetApi(value=11)
    protected static Notification makeNotificationSDK11OrHigher(Context context, PendingIntent intent, NotificationData notificationData) {
        Notification.Builder builder = new Notification.Builder(context).setSmallIcon(notificationData.icon).setTicker((CharSequence)notificationData.message).setWhen(System.currentTimeMillis()).setContentTitle(notificationData.title).setContentText((CharSequence)notificationData.message).setContentIntent(intent).setDefaults(MPConfig.getInstance(context).getNotificationDefaults());
        if (notificationData.largeIcon != -1) {
            builder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)notificationData.largeIcon));
        }
        Notification n = builder.getNotification();
        n.flags |= 0x10;
        return n;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=16)
    protected static Notification makeNotificationSDK16OrHigher(Context context, PendingIntent intent, NotificationData notificationData) {
        Notification.Builder builder = new Notification.Builder(context).setSmallIcon(notificationData.icon).setTicker((CharSequence)notificationData.message).setWhen(System.currentTimeMillis()).setContentTitle(notificationData.title).setContentText((CharSequence)notificationData.message).setContentIntent(intent).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)notificationData.message)).setDefaults(MPConfig.getInstance(context).getNotificationDefaults());
        if (notificationData.largeIcon != -1) {
            builder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)notificationData.largeIcon));
        }
        Notification n = builder.build();
        n.flags |= 0x10;
        return n;
    }

    @SuppressLint(value={"NewApi"})
    @TargetApi(value=21)
    protected static Notification makeNotificationSDK21OrHigher(Context context, PendingIntent intent, NotificationData notificationData) {
        Notification.Builder builder = new Notification.Builder(context).setTicker((CharSequence)notificationData.message).setWhen(System.currentTimeMillis()).setContentTitle(notificationData.title).setContentText((CharSequence)notificationData.message).setContentIntent(intent).setStyle((Notification.Style)new Notification.BigTextStyle().bigText((CharSequence)notificationData.message)).setDefaults(MPConfig.getInstance(context).getNotificationDefaults());
        if (notificationData.whiteIcon != -1) {
            builder.setSmallIcon(notificationData.whiteIcon);
        } else {
            builder.setSmallIcon(notificationData.icon);
        }
        if (notificationData.largeIcon != -1) {
            builder.setLargeIcon(BitmapFactory.decodeResource((Resources)context.getResources(), (int)notificationData.largeIcon));
        }
        if (notificationData.color != -1) {
            builder.setColor(notificationData.color);
        }
        Notification n = builder.build();
        n.flags |= 0x10;
        return n;
    }

    static NotificationData readInboundIntent(Context context, Intent inboundIntent, ResourceIds iconIds, Intent defaultIntent) {
        ApplicationInfo appInfo;
        PackageManager manager = context.getPackageManager();
        String message = inboundIntent.getStringExtra("mp_message");
        String iconName = inboundIntent.getStringExtra("mp_icnm");
        String largeIconName = inboundIntent.getStringExtra("mp_icnm_l");
        String whiteIconName = inboundIntent.getStringExtra("mp_icnm_w");
        String uriString = inboundIntent.getStringExtra("mp_cta");
        CharSequence notificationTitle = inboundIntent.getStringExtra("mp_title");
        String colorName = inboundIntent.getStringExtra("mp_color");
        String campaignId = inboundIntent.getStringExtra("mp_campaign_id");
        String messageId = inboundIntent.getStringExtra("mp_message_id");
        String extraLogData = inboundIntent.getStringExtra("mp");
        int color = -1;
        MixpanelFCMMessagingService.trackCampaignReceived(campaignId, messageId, extraLogData);
        if (colorName != null) {
            try {
                color = Color.parseColor((String)colorName);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (message == null) {
            return null;
        }
        int notificationIcon = -1;
        if (null != iconName && iconIds.knownIdName(iconName)) {
            notificationIcon = iconIds.idFromName(iconName);
        }
        int largeNotificationIcon = -1;
        if (null != largeIconName && iconIds.knownIdName(largeIconName)) {
            largeNotificationIcon = iconIds.idFromName(largeIconName);
        }
        int whiteNotificationIcon = -1;
        if (null != whiteIconName && iconIds.knownIdName(whiteIconName)) {
            whiteNotificationIcon = iconIds.idFromName(whiteIconName);
        }
        try {
            appInfo = manager.getApplicationInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            appInfo = null;
        }
        if (notificationIcon == -1 && null != appInfo) {
            notificationIcon = appInfo.icon;
        }
        if (notificationIcon == -1) {
            notificationIcon = 17301651;
        }
        if (null == notificationTitle && null != appInfo) {
            notificationTitle = manager.getApplicationLabel(appInfo);
        }
        if (null == notificationTitle) {
            notificationTitle = "A message for you";
        }
        Uri uri = null;
        if (null != uriString) {
            uri = Uri.parse((String)uriString);
        }
        Intent intent = null == uri ? defaultIntent : new Intent("android.intent.action.VIEW", uri);
        Intent notificationIntent = MixpanelFCMMessagingService.buildNotificationIntent(intent, campaignId, messageId, extraLogData);
        return new NotificationData(notificationIcon, largeNotificationIcon, whiteNotificationIcon, notificationTitle, message, notificationIntent, color);
    }

    private static Intent buildNotificationIntent(Intent intent, String campaignId, String messageId, String extraLogData) {
        if (campaignId != null) {
            intent.putExtra("mp_campaign_id", campaignId);
        }
        if (messageId != null) {
            intent.putExtra("mp_message_id", messageId);
        }
        if (extraLogData != null) {
            intent.putExtra("mp", extraLogData);
        }
        return intent;
    }

    private static void trackCampaignReceived(final String campaignId, final String messageId, final String extraLogData) {
        if (campaignId != null && messageId != null) {
            MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

                @Override
                public void process(MixpanelAPI api) {
                    if (api.isAppInForeground()) {
                        JSONObject pushProps = new JSONObject();
                        try {
                            if (extraLogData != null) {
                                pushProps = new JSONObject(extraLogData);
                            }
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                        try {
                            pushProps.put("campaign_id", Integer.valueOf(campaignId).intValue());
                            pushProps.put("message_id", Integer.valueOf(messageId).intValue());
                            pushProps.put("message_type", (Object)"push");
                            api.track("$campaign_received", pushProps);
                        }
                        catch (JSONException jSONException) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    protected static class NotificationData {
        public final int icon;
        public final int largeIcon;
        public final int whiteIcon;
        public final CharSequence title;
        public final String message;
        public final Intent intent;
        public final int color;
        public static final int NOT_SET = -1;

        private NotificationData(int anIcon, int aLargeIcon, int aWhiteIcon, CharSequence aTitle, String aMessage, Intent anIntent, int aColor) {
            this.icon = anIcon;
            this.largeIcon = aLargeIcon;
            this.whiteIcon = aWhiteIcon;
            this.title = aTitle;
            this.message = aMessage;
            this.intent = anIntent;
            this.color = aColor;
        }
    }
}

