/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.app.Activity;
import android.view.MotionEvent;
import android.view.View;
import com.mixpanel.android.mpmetrics.MixpanelAPI;

public class GestureTracker {
    public GestureTracker(MixpanelAPI mMixpanel, Activity parent) {
        this.trackGestures(mMixpanel, parent);
    }

    private void trackGestures(MixpanelAPI mMixpanel, Activity parent) {
        parent.getWindow().getDecorView().setOnTouchListener(this.getGestureTrackerTouchListener(mMixpanel));
    }

    private View.OnTouchListener getGestureTrackerTouchListener(final MixpanelAPI mMixpanel) {
        return new View.OnTouchListener(){
            private long mSecondFingerTimeDown = -1L;
            private long mFirstToSecondFingerDifference = -1L;
            private int mGestureSteps = 0;
            private long mTimePassedBetweenTaps = -1L;
            private boolean mDidTapDownBothFingers = false;
            private final int TIME_BETWEEN_FINGERS_THRESHOLD = 100;
            private final int TIME_BETWEEN_TAPS_THRESHOLD = 1000;
            private final int TIME_FOR_LONG_TAP = 2500;

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getPointerCount() > 2) {
                    this.resetGesture();
                    return false;
                }
                switch (event.getActionMasked()) {
                    case 0: {
                        this.mFirstToSecondFingerDifference = System.currentTimeMillis();
                        break;
                    }
                    case 5: {
                        if (System.currentTimeMillis() - this.mFirstToSecondFingerDifference < 100L) {
                            if (System.currentTimeMillis() - this.mTimePassedBetweenTaps > 1000L) {
                                this.resetGesture();
                            }
                            this.mSecondFingerTimeDown = System.currentTimeMillis();
                            this.mDidTapDownBothFingers = true;
                            break;
                        }
                        this.resetGesture();
                        break;
                    }
                    case 6: {
                        if (this.mDidTapDownBothFingers) {
                            this.mFirstToSecondFingerDifference = System.currentTimeMillis();
                            break;
                        }
                        this.resetGesture();
                        break;
                    }
                    case 1: {
                        if (System.currentTimeMillis() - this.mFirstToSecondFingerDifference >= 100L) break;
                        if (System.currentTimeMillis() - this.mSecondFingerTimeDown >= 2500L) {
                            if (this.mGestureSteps == 3) {
                                mMixpanel.track("$ab_gesture1");
                                this.resetGesture();
                            }
                            this.mGestureSteps = 0;
                            break;
                        }
                        this.mTimePassedBetweenTaps = System.currentTimeMillis();
                        if (this.mGestureSteps < 4) {
                            ++this.mGestureSteps;
                            break;
                        }
                        if (this.mGestureSteps == 4) {
                            mMixpanel.track("$ab_gesture2");
                            this.resetGesture();
                            break;
                        }
                        this.resetGesture();
                    }
                }
                return false;
            }

            private void resetGesture() {
                this.mFirstToSecondFingerDifference = -1L;
                this.mSecondFingerTimeDown = -1L;
                this.mGestureSteps = 0;
                this.mTimePassedBetweenTaps = -1L;
                this.mDidTapDownBothFingers = false;
            }
        };
    }
}

