/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.ImageView;
import android.widget.TextView;
import com.mixpanel.android.R;
import com.mixpanel.android.mpmetrics.MiniInAppNotification;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.UpdateDisplayState;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.ViewUtils;

@TargetApi(value=16)
@SuppressLint(value={"ClickableViewAccessibility"})
public class InAppFragment
extends Fragment {
    private MixpanelAPI mMixpanel;
    private Activity mParent;
    private GestureDetector mDetector;
    private Handler mHandler;
    private int mDisplayStateId;
    private UpdateDisplayState.DisplayState.InAppNotificationState mDisplayState;
    private Runnable mRemover;
    private Runnable mDisplayMini;
    private View mInAppView;
    private boolean mCleanedUp;
    private static final String LOGTAG = "MixpanelAPI.InAppFrag";
    private static final int MINI_REMOVE_TIME = 10000;

    public void setDisplayState(MixpanelAPI mixpanel, int stateId, UpdateDisplayState.DisplayState.InAppNotificationState displayState) {
        this.mMixpanel = mixpanel;
        this.mDisplayStateId = stateId;
        this.mDisplayState = displayState;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mParent = activity;
        if (null == this.mDisplayState) {
            this.cleanUp();
            return;
        }
        this.mHandler = new Handler();
        this.mRemover = new Runnable(){

            @Override
            public void run() {
                InAppFragment.this.remove();
            }
        };
        this.mDisplayMini = new Runnable(){

            @Override
            public void run() {
                InAppFragment.this.mInAppView.setVisibility(0);
                InAppFragment.this.mInAppView.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View view, MotionEvent event) {
                        return InAppFragment.this.mDetector.onTouchEvent(event);
                    }
                });
                ImageView notifImage = (ImageView)InAppFragment.this.mInAppView.findViewById(R.id.com_mixpanel_android_notification_image);
                float heightPx = TypedValue.applyDimension((int)1, (float)65.0f, (DisplayMetrics)InAppFragment.this.mParent.getResources().getDisplayMetrics());
                TranslateAnimation translate = new TranslateAnimation(0.0f, 0.0f, heightPx, 0.0f);
                translate.setInterpolator((Interpolator)new DecelerateInterpolator());
                translate.setDuration(200L);
                InAppFragment.this.mInAppView.startAnimation((Animation)translate);
                ScaleAnimation scale = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, heightPx / 2.0f, heightPx / 2.0f);
                scale.setInterpolator((Interpolator)new SineBounceInterpolator());
                scale.setDuration(400L);
                scale.setStartOffset(200L);
                notifImage.startAnimation((Animation)scale);
            }
        };
        this.mDetector = new GestureDetector((Context)activity, new GestureDetector.OnGestureListener(){

            public boolean onDown(MotionEvent e) {
                return true;
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                if (velocityY > 0.0f) {
                    InAppFragment.this.remove();
                }
                return true;
            }

            public void onLongPress(MotionEvent e) {
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                return false;
            }

            public void onShowPress(MotionEvent e) {
            }

            public boolean onSingleTapUp(MotionEvent event) {
                MiniInAppNotification inApp = (MiniInAppNotification)InAppFragment.this.mDisplayState.getInAppNotification();
                String uriString = inApp.getCtaUrl();
                if (uriString != null && uriString.length() > 0) {
                    Uri uri;
                    try {
                        uri = Uri.parse((String)uriString);
                    }
                    catch (IllegalArgumentException e) {
                        MPLog.i(InAppFragment.LOGTAG, "Can't parse notification URI, will not take any action", e);
                        return true;
                    }
                    try {
                        Intent viewIntent = new Intent("android.intent.action.VIEW", uri);
                        InAppFragment.this.mParent.startActivity(viewIntent);
                        InAppFragment.this.mMixpanel.getPeople().trackNotification("$campaign_open", inApp);
                    }
                    catch (ActivityNotFoundException e) {
                        MPLog.i(InAppFragment.LOGTAG, "User doesn't have an activity for notification URI " + uri);
                    }
                }
                InAppFragment.this.remove();
                return true;
            }
        });
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mCleanedUp = false;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        if (null == this.mDisplayState) {
            this.cleanUp();
        } else {
            this.mInAppView = inflater.inflate(R.layout.com_mixpanel_android_activity_notification_mini, container, false);
            TextView bodyTextView = (TextView)this.mInAppView.findViewById(R.id.com_mixpanel_android_notification_title);
            ImageView notifImage = (ImageView)this.mInAppView.findViewById(R.id.com_mixpanel_android_notification_image);
            MiniInAppNotification inApp = (MiniInAppNotification)this.mDisplayState.getInAppNotification();
            bodyTextView.setText((CharSequence)inApp.getBody());
            bodyTextView.setTextColor(inApp.getBodyColor());
            notifImage.setImageBitmap(inApp.getImage());
            this.mHandler.postDelayed(this.mRemover, 10000L);
            GradientDrawable viewBackground = new GradientDrawable();
            viewBackground.setColor(inApp.getBackgroundColor());
            viewBackground.setCornerRadius(ViewUtils.dpToPx(7.0f, (Context)this.getActivity()));
            viewBackground.setStroke((int)ViewUtils.dpToPx(2.0f, (Context)this.getActivity()), inApp.getBorderColor());
            if (Build.VERSION.SDK_INT < 16) {
                this.mInAppView.setBackgroundDrawable((Drawable)viewBackground);
            } else {
                this.mInAppView.setBackground((Drawable)viewBackground);
            }
            BitmapDrawable myIcon = new BitmapDrawable(this.getResources(), this.mDisplayState.getInAppNotification().getImage());
            myIcon.setColorFilter(inApp.getImageTintColor(), PorterDuff.Mode.SRC_ATOP);
            notifImage.setImageDrawable((Drawable)myIcon);
        }
        return this.mInAppView;
    }

    public void onStart() {
        super.onStart();
        if (this.mCleanedUp) {
            this.mParent.getFragmentManager().beginTransaction().remove((Fragment)this).commit();
        }
    }

    public void onResume() {
        super.onResume();
        this.mHandler.postDelayed(this.mDisplayMini, 500L);
    }

    public void onSaveInstanceState(Bundle outState) {
        this.cleanUp();
        super.onSaveInstanceState(outState);
    }

    public void onPause() {
        super.onPause();
        this.cleanUp();
    }

    private void cleanUp() {
        if (!this.mCleanedUp) {
            this.mHandler.removeCallbacks(this.mRemover);
            this.mHandler.removeCallbacks(this.mDisplayMini);
            UpdateDisplayState.releaseDisplayState(this.mDisplayStateId);
            FragmentManager fragmentManager = this.mParent.getFragmentManager();
            FragmentTransaction transaction = fragmentManager.beginTransaction();
            transaction.remove((Fragment)this).commit();
        }
        this.mCleanedUp = true;
    }

    private void remove() {
        if (this.mParent != null && !this.mCleanedUp) {
            this.mHandler.removeCallbacks(this.mRemover);
            this.mHandler.removeCallbacks(this.mDisplayMini);
            FragmentManager fragmentManager = this.mParent.getFragmentManager();
            FragmentTransaction transaction = fragmentManager.beginTransaction();
            transaction.setCustomAnimations(0, R.animator.com_mixpanel_android_slide_down).remove((Fragment)this).commit();
            UpdateDisplayState.releaseDisplayState(this.mDisplayStateId);
            this.mCleanedUp = true;
        }
    }

    private class SineBounceInterpolator
    implements Interpolator {
        public float getInterpolation(float t) {
            return (float)(-(Math.pow(Math.E, -8.0f * t) * Math.cos(12.0f * t))) + 1.0f;
        }
    }
}

