/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.viewcrawler.GestureTracker;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=14)
class MixpanelActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private Runnable check;
    private boolean mIsForeground = true;
    private boolean mPaused = true;
    public static final int CHECK_DELAY = 500;
    private final MixpanelAPI mMpInstance;
    private final MPConfig mConfig;

    public MixpanelActivityLifecycleCallbacks(MixpanelAPI mpInstance, MPConfig config) {
        this.mMpInstance = mpInstance;
        this.mConfig = config;
    }

    public void onActivityStarted(Activity activity) {
        if (activity.getIntent().hasExtra("mp_campaign_id") && activity.getIntent().hasExtra("mp_message_id")) {
            String campaignId = activity.getIntent().getStringExtra("mp_campaign_id");
            String messageId = activity.getIntent().getStringExtra("mp_message_id");
            JSONObject pushProps = new JSONObject();
            try {
                pushProps.put("campaign_id", (Object)campaignId);
                pushProps.put("message_id", (Object)messageId);
                pushProps.put("message_type", (Object)"push");
                this.mMpInstance.track("$app_open", pushProps);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            activity.getIntent().removeExtra("mp_campaign_id");
            activity.getIntent().removeExtra("mp_message_id");
        }
        if (Build.VERSION.SDK_INT >= 16 && this.mConfig.getAutoShowMixpanelUpdates()) {
            if (!activity.isTaskRoot()) {
                return;
            }
            this.mMpInstance.getPeople().showNotificationIfAvailable(activity);
        }
        new GestureTracker(this.mMpInstance, activity);
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityPaused(Activity activity) {
        this.mPaused = true;
        if (this.check != null) {
            this.mHandler.removeCallbacks(this.check);
        }
        this.check = new Runnable(){

            @Override
            public void run() {
                if (MixpanelActivityLifecycleCallbacks.this.mIsForeground && MixpanelActivityLifecycleCallbacks.this.mPaused) {
                    MixpanelActivityLifecycleCallbacks.this.mIsForeground = false;
                    MixpanelActivityLifecycleCallbacks.this.mMpInstance.flush();
                }
            }
        };
        this.mHandler.postDelayed(this.check, 500L);
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityResumed(Activity activity) {
        if (Build.VERSION.SDK_INT >= 16 && this.mConfig.getAutoShowMixpanelUpdates()) {
            this.mMpInstance.getPeople().joinExperimentIfAvailable();
        }
        this.mPaused = true;
        boolean wasBackground = !this.mIsForeground;
        this.mIsForeground = true;
        if (this.check != null) {
            this.mHandler.removeCallbacks(this.check);
        }
        if (wasBackground) {
            // empty if block
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    protected boolean isInForeground() {
        return this.mIsForeground;
    }
}

