/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.os.Parcel;
import android.os.Parcelable;
import com.mixpanel.android.mpmetrics.BadDecideObjectException;
import com.mixpanel.android.mpmetrics.InAppNotification;
import com.mixpanel.android.util.JSONUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class MiniInAppNotification
extends InAppNotification {
    private final String mCtaUrl;
    private final int mImageTintColor;
    private final int mBorderColor;
    public static final Parcelable.Creator<MiniInAppNotification> CREATOR = new Parcelable.Creator<MiniInAppNotification>(){

        public MiniInAppNotification createFromParcel(Parcel source) {
            return new MiniInAppNotification(source);
        }

        public MiniInAppNotification[] newArray(int size) {
            return new MiniInAppNotification[size];
        }
    };

    public MiniInAppNotification(Parcel in) {
        super(in);
        this.mCtaUrl = in.readString();
        this.mImageTintColor = in.readInt();
        this.mBorderColor = in.readInt();
    }

    MiniInAppNotification(JSONObject description) throws BadDecideObjectException {
        super(description);
        try {
            this.mCtaUrl = JSONUtils.optionalStringKey(description, "cta_url");
            this.mImageTintColor = description.getInt("image_tint_color");
            this.mBorderColor = description.getInt("border_color");
        }
        catch (JSONException e) {
            throw new BadDecideObjectException("Notification JSON was unexpected or bad", e);
        }
    }

    public String getCtaUrl() {
        return this.mCtaUrl;
    }

    public int getImageTintColor() {
        return this.mImageTintColor;
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeString(this.mCtaUrl);
        dest.writeInt(this.mImageTintColor);
        dest.writeInt(this.mBorderColor);
    }

    @Override
    public InAppNotification.Type getType() {
        return InAppNotification.Type.MINI;
    }
}

