/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.os.Parcel;
import android.os.Parcelable;
import com.mixpanel.android.mpmetrics.BadDecideObjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class Survey
implements Parcelable {
    public static final Parcelable.Creator<Survey> CREATOR = new Parcelable.Creator<Survey>(){

        public Survey createFromParcel(Parcel source) {
            String jsonString = source.readString();
            try {
                JSONObject json = new JSONObject(jsonString);
                return new Survey(json);
            }
            catch (JSONException e) {
                throw new RuntimeException("Corrupted JSON object written to survey parcel.", e);
            }
            catch (BadDecideObjectException e) {
                throw new RuntimeException("Unexpected or incomplete object written to survey parcel.", e);
            }
        }

        public Survey[] newArray(int size) {
            return new Survey[size];
        }
    };
    private final JSONObject mDescription;
    private final int mId;
    private final int mCollectionId;
    private final List<Question> mQuestions;

    Survey(JSONObject description) throws BadDecideObjectException {
        try {
            this.mDescription = description;
            this.mId = description.getInt("id");
            JSONArray collectionsJArray = description.getJSONArray("collections");
            JSONObject collection0 = collectionsJArray.getJSONObject(0);
            this.mCollectionId = collection0.getInt("id");
            JSONArray questionsJArray = description.getJSONArray("questions");
            if (questionsJArray.length() == 0) {
                throw new BadDecideObjectException("Survey has no questions.");
            }
            ArrayList<Question> questionsList = new ArrayList<Question>(questionsJArray.length());
            for (int i = 0; i < questionsJArray.length(); ++i) {
                JSONObject q = questionsJArray.getJSONObject(i);
                questionsList.add(new Question(q));
            }
            this.mQuestions = Collections.unmodifiableList(questionsList);
        }
        catch (JSONException e) {
            throw new BadDecideObjectException("Survey JSON was unexpected or bad", e);
        }
    }

    String toJSON() {
        return this.mDescription.toString();
    }

    public int getId() {
        return this.mId;
    }

    public int getCollectionId() {
        return this.mCollectionId;
    }

    public List<Question> getQuestions() {
        return this.mQuestions;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.toJSON());
    }

    public class Question {
        private final int mQuestionId;
        private final String mQuestionType;
        private final String mPrompt;
        private final List<String> mChoices;

        private Question(JSONObject question) throws JSONException, BadDecideObjectException {
            JSONObject extraData;
            this.mQuestionId = question.getInt("id");
            this.mQuestionType = question.getString("type");
            this.mPrompt = question.getString("prompt");
            List choicesList = Collections.emptyList();
            if (question.has("extra_data") && (extraData = question.getJSONObject("extra_data")).has("$choices")) {
                JSONArray choices = extraData.getJSONArray("$choices");
                choicesList = new ArrayList(choices.length());
                for (int i = 0; i < choices.length(); ++i) {
                    choicesList.add(choices.getString(i));
                }
            }
            this.mChoices = Collections.unmodifiableList(choicesList);
            if (this.getType() == QuestionType.MULTIPLE_CHOICE && this.mChoices.size() == 0) {
                throw new BadDecideObjectException("Question is multiple choice but has no answers:" + question.toString());
            }
        }

        public int getId() {
            return this.mQuestionId;
        }

        public String getPrompt() {
            return this.mPrompt;
        }

        public List<String> getChoices() {
            return this.mChoices;
        }

        public QuestionType getType() {
            if (QuestionType.MULTIPLE_CHOICE.toString().equals(this.mQuestionType)) {
                return QuestionType.MULTIPLE_CHOICE;
            }
            if (QuestionType.TEXT.toString().equals(this.mQuestionType)) {
                return QuestionType.TEXT;
            }
            return QuestionType.UNKNOWN;
        }
    }

    public static enum QuestionType {
        UNKNOWN{

            public String toString() {
                return "*unknown_type*";
            }
        }
        ,
        MULTIPLE_CHOICE{

            public String toString() {
                return "multiple_choice";
            }
        }
        ,
        TEXT{

            public String toString() {
                return "text";
            }
        };

    }
}

