/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.util.OfflineMode;
import com.mixpanel.android.util.RemoteService;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpService
implements RemoteService {
    private static boolean sIsMixpanelBlocked;
    private static final int MIN_UNAVAILABLE_HTTP_RESPONSE_CODE = 500;
    private static final int MAX_UNAVAILABLE_HTTP_RESPONSE_CODE = 599;
    private static final String LOGTAG = "MixpanelAPI.Message";

    @Override
    public void checkIsMixpanelBlocked() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    InetAddress apiMixpanelInet = InetAddress.getByName("api.mixpanel.com");
                    InetAddress decideMixpanelInet = InetAddress.getByName("decide.mixpanel.com");
                    sIsMixpanelBlocked = apiMixpanelInet.isLoopbackAddress() || apiMixpanelInet.isAnyLocalAddress() || decideMixpanelInet.isLoopbackAddress() || decideMixpanelInet.isAnyLocalAddress();
                    if (MPConfig.DEBUG && sIsMixpanelBlocked) {
                        Log.v((String)HttpService.LOGTAG, (String)"AdBlocker is enabled. Won't be able to use Mixpanel services.");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    @Override
    public boolean isOnline(Context context, OfflineMode offlineMode) {
        boolean isOnline;
        block5: {
            if (sIsMixpanelBlocked) {
                return false;
            }
            if (this.onOfflineMode(offlineMode)) {
                return false;
            }
            try {
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo netInfo = cm.getActiveNetworkInfo();
                boolean bl = isOnline = netInfo != null && netInfo.isConnectedOrConnecting();
                if (MPConfig.DEBUG) {
                    Log.v((String)LOGTAG, (String)("ConnectivityManager says we " + (isOnline ? "are" : "are not") + " online"));
                }
            }
            catch (SecurityException e) {
                isOnline = true;
                if (!MPConfig.DEBUG) break block5;
                Log.v((String)LOGTAG, (String)"Don't have permission to check connectivity, will assume we are online");
            }
        }
        return isOnline;
    }

    private boolean onOfflineMode(OfflineMode offlineMode) {
        boolean onOfflineMode;
        block2: {
            try {
                onOfflineMode = offlineMode != null && offlineMode.isOffline();
            }
            catch (Exception e) {
                onOfflineMode = false;
                if (!MPConfig.DEBUG) break block2;
                Log.v((String)LOGTAG, (String)"Client State should not throw exception, will assume is not on offline mode", (Throwable)e);
            }
        }
        return onOfflineMode;
    }

    @Override
    public byte[] performRequest(String endpointUrl, Map<String, Object> params, SSLSocketFactory socketFactory) throws RemoteService.ServiceUnavailableException, IOException {
        if (MPConfig.DEBUG) {
            Log.v((String)LOGTAG, (String)("Attempting request to " + endpointUrl));
        }
        byte[] response = null;
        int retries = 0;
        boolean succeeded = false;
        while (retries < 3 && !succeeded) {
            InputStream in = null;
            OutputStream out = null;
            FilterOutputStream bout = null;
            HttpURLConnection connection = null;
            try {
                URL url = new URL(endpointUrl);
                connection = (HttpURLConnection)url.openConnection();
                if (null != socketFactory && connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(socketFactory);
                }
                connection.setConnectTimeout(2000);
                connection.setReadTimeout(10000);
                if (null != params) {
                    Uri.Builder builder = new Uri.Builder();
                    for (Map.Entry<String, Object> param : params.entrySet()) {
                        builder.appendQueryParameter(param.getKey(), param.getValue().toString());
                    }
                    String query = builder.build().getEncodedQuery();
                    connection.setFixedLengthStreamingMode(query.getBytes().length);
                    connection.setDoOutput(true);
                    connection.setRequestMethod("POST");
                    out = connection.getOutputStream();
                    bout = new BufferedOutputStream(out);
                    bout.write(query.getBytes("UTF-8"));
                    ((BufferedOutputStream)bout).flush();
                    bout.close();
                    bout = null;
                    out.close();
                    out = null;
                }
                in = connection.getInputStream();
                response = HttpService.slurp(in);
                in.close();
                in = null;
                succeeded = true;
            }
            catch (EOFException e) {
                if (MPConfig.DEBUG) {
                    Log.d((String)LOGTAG, (String)"Failure to connect, likely caused by a known issue with Android lib. Retrying.");
                }
                ++retries;
            }
            catch (IOException e) {
                if (connection.getResponseCode() >= 500 && connection.getResponseCode() <= 599) {
                    throw new RemoteService.ServiceUnavailableException("Service Unavailable", connection.getHeaderField("Retry-After"));
                }
                throw e;
            }
            finally {
                if (null != bout) {
                    try {
                        bout.close();
                    }
                    catch (IOException e) {}
                }
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (null == connection) continue;
                connection.disconnect();
            }
        }
        if (MPConfig.DEBUG && retries >= 3) {
            Log.v((String)LOGTAG, (String)"Could not connect to Mixpanel service after three retries.");
        }
        return response;
    }

    private static byte[] slurp(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

