/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.surveys;

import android.annotation.TargetApi;
import android.content.Context;
import android.text.Layout;
import android.util.AttributeSet;
import android.widget.TextView;

public class AutoResizeTextView
extends TextView {
    private static final int TEXT_SIZE_SP = 18;
    private static final int MAX_LINES = 4;
    private static final float MIN_TEXT_SIZE_FACTOR = 1.3f;
    private float mMinTextSizePx;

    public AutoResizeTextView(Context context) {
        super(context);
        this.init();
    }

    public AutoResizeTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public AutoResizeTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @TargetApi(value=21)
    public AutoResizeTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.setMaxLines(4);
        this.setTextSize(2, 18.0f);
        this.mMinTextSizePx = this.getTextSize() / 1.3f;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int lineCount;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Layout layout2 = this.getLayout();
        if (layout2 != null && (lineCount = layout2.getLineCount()) == 4 && layout2.getEllipsisCount(lineCount - 1) > 0 && this.getTextSize() > this.mMinTextSizePx) {
            float textSize = this.getTextSize();
            this.setTextSize(0, textSize - 2.0f);
            this.measure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

