/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.mixpanel.android.viewcrawler.Caller;
import com.mixpanel.android.viewcrawler.Pathfinder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

@TargetApi(value=16)
abstract class ViewVisitor
implements Pathfinder.Accumulator {
    private final List<Pathfinder.PathElement> mPath;
    private final Pathfinder mPathfinder;
    private static final String LOGTAG = "MixpanelAPI.ViewVisitor";

    public void visit(View rootView) {
        this.mPathfinder.findTargetsInRoot(rootView, this.mPath, this);
    }

    public abstract void cleanup();

    protected ViewVisitor(List<Pathfinder.PathElement> path) {
        this.mPath = path;
        this.mPathfinder = new Pathfinder();
    }

    protected List<Pathfinder.PathElement> getPath() {
        return this.mPath;
    }

    protected Pathfinder getPathfinder() {
        return this.mPathfinder;
    }

    protected abstract String name();

    private static abstract class EventTriggeringVisitor
    extends ViewVisitor {
        private final OnEventListener mListener;
        private final String mEventName;
        private final boolean mDebounce;

        public EventTriggeringVisitor(List<Pathfinder.PathElement> path, String eventName, OnEventListener listener, boolean debounce) {
            super(path);
            this.mListener = listener;
            this.mEventName = eventName;
            this.mDebounce = debounce;
        }

        protected void fireEvent(View found) {
            this.mListener.OnEvent(found, this.mEventName, this.mDebounce);
        }

        protected String getEventName() {
            return this.mEventName;
        }
    }

    public static class ViewDetectorVisitor
    extends EventTriggeringVisitor {
        private boolean mSeen = false;

        public ViewDetectorVisitor(List<Pathfinder.PathElement> path, String eventName, OnEventListener listener) {
            super(path, eventName, listener, false);
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void accumulate(View found) {
            if (found != null && !this.mSeen) {
                this.fireEvent(found);
            }
            this.mSeen = found != null;
        }

        @Override
        protected String name() {
            return this.getEventName() + " when Detected";
        }
    }

    public static class AddTextChangeListener
    extends EventTriggeringVisitor {
        private final Map<TextView, TextWatcher> mWatching = new HashMap<TextView, TextWatcher>();

        public AddTextChangeListener(List<Pathfinder.PathElement> path, String eventName, OnEventListener listener) {
            super(path, eventName, listener, true);
        }

        @Override
        public void cleanup() {
            for (Map.Entry<TextView, TextWatcher> entry : this.mWatching.entrySet()) {
                TextView v = entry.getKey();
                TextWatcher watcher = entry.getValue();
                v.removeTextChangedListener(watcher);
            }
            this.mWatching.clear();
        }

        @Override
        public void accumulate(View found) {
            if (found instanceof TextView) {
                TextView foundTextView = (TextView)found;
                TrackingTextWatcher watcher = new TrackingTextWatcher((View)foundTextView);
                TextWatcher oldWatcher = this.mWatching.get(foundTextView);
                if (null != oldWatcher) {
                    foundTextView.removeTextChangedListener(oldWatcher);
                }
                foundTextView.addTextChangedListener((TextWatcher)watcher);
                this.mWatching.put(foundTextView, watcher);
            }
        }

        @Override
        protected String name() {
            return this.getEventName() + " on Text Change";
        }

        private class TrackingTextWatcher
        implements TextWatcher {
            private final View mBoundTo;

            public TrackingTextWatcher(View boundTo) {
                this.mBoundTo = boundTo;
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                AddTextChangeListener.this.fireEvent(this.mBoundTo);
            }
        }
    }

    public static class AddAccessibilityEventVisitor
    extends EventTriggeringVisitor {
        private final int mEventType;
        private final WeakHashMap<View, TrackingAccessibilityDelegate> mWatching;

        public AddAccessibilityEventVisitor(List<Pathfinder.PathElement> path, int accessibilityEventType, String eventName, OnEventListener listener) {
            super(path, eventName, listener, false);
            this.mEventType = accessibilityEventType;
            this.mWatching = new WeakHashMap();
        }

        @Override
        public void cleanup() {
            for (Map.Entry<View, TrackingAccessibilityDelegate> entry : this.mWatching.entrySet()) {
                View v = entry.getKey();
                TrackingAccessibilityDelegate toCleanup = entry.getValue();
                View.AccessibilityDelegate currentViewDelegate = this.getOldDelegate(v);
                if (currentViewDelegate == toCleanup) {
                    v.setAccessibilityDelegate(toCleanup.getRealDelegate());
                    continue;
                }
                if (!(currentViewDelegate instanceof TrackingAccessibilityDelegate)) continue;
                TrackingAccessibilityDelegate newChain = (TrackingAccessibilityDelegate)currentViewDelegate;
                newChain.removeFromDelegateChain(toCleanup);
            }
            this.mWatching.clear();
        }

        @Override
        public void accumulate(View found) {
            TrackingAccessibilityDelegate currentTracker;
            View.AccessibilityDelegate realDelegate = this.getOldDelegate(found);
            if (realDelegate instanceof TrackingAccessibilityDelegate && (currentTracker = (TrackingAccessibilityDelegate)realDelegate).willFireEvent(this.getEventName())) {
                return;
            }
            TrackingAccessibilityDelegate newDelegate = new TrackingAccessibilityDelegate(realDelegate);
            found.setAccessibilityDelegate((View.AccessibilityDelegate)newDelegate);
            this.mWatching.put(found, newDelegate);
        }

        @Override
        protected String name() {
            return this.getEventName() + " event when (" + this.mEventType + ")";
        }

        private View.AccessibilityDelegate getOldDelegate(View v) {
            View.AccessibilityDelegate ret = null;
            try {
                Class<?> klass = v.getClass();
                Method m = klass.getMethod("getAccessibilityDelegate", new Class[0]);
                ret = (View.AccessibilityDelegate)m.invoke((Object)v, new Object[0]);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                Log.w((String)ViewVisitor.LOGTAG, (String)"getAccessibilityDelegate threw an exception when called.", (Throwable)e);
            }
            return ret;
        }

        private class TrackingAccessibilityDelegate
        extends View.AccessibilityDelegate {
            private View.AccessibilityDelegate mRealDelegate;

            public TrackingAccessibilityDelegate(View.AccessibilityDelegate realDelegate) {
                this.mRealDelegate = realDelegate;
            }

            public View.AccessibilityDelegate getRealDelegate() {
                return this.mRealDelegate;
            }

            public boolean willFireEvent(String eventName) {
                if (AddAccessibilityEventVisitor.this.getEventName() == eventName) {
                    return true;
                }
                if (this.mRealDelegate instanceof TrackingAccessibilityDelegate) {
                    return ((TrackingAccessibilityDelegate)this.mRealDelegate).willFireEvent(eventName);
                }
                return false;
            }

            public void removeFromDelegateChain(TrackingAccessibilityDelegate other) {
                if (this.mRealDelegate == other) {
                    this.mRealDelegate = other.getRealDelegate();
                } else if (this.mRealDelegate instanceof TrackingAccessibilityDelegate) {
                    TrackingAccessibilityDelegate child = (TrackingAccessibilityDelegate)this.mRealDelegate;
                    child.removeFromDelegateChain(other);
                }
            }

            public void sendAccessibilityEvent(View host, int eventType) {
                if (eventType == AddAccessibilityEventVisitor.this.mEventType) {
                    AddAccessibilityEventVisitor.this.fireEvent(host);
                }
                if (null != this.mRealDelegate) {
                    this.mRealDelegate.sendAccessibilityEvent(host, eventType);
                }
            }
        }
    }

    public static class LayoutRule {
        public final int viewId;
        public final int verb;
        public final int anchor;

        public LayoutRule(int vi, int v, int a) {
            this.viewId = vi;
            this.verb = v;
            this.anchor = a;
        }
    }

    public static class LayoutUpdateVisitor
    extends ViewVisitor {
        private final WeakHashMap<View, int[]> mOriginalValues = new WeakHashMap();
        private final ArrayList<LayoutRule> mArgs;
        private final String mName;
        private static final Set<Integer> mHorizontalRules = new HashSet<Integer>(Arrays.asList(0, 1, 5, 7));
        private static final Set<Integer> mVerticalRules = new HashSet<Integer>(Arrays.asList(2, 3, 4, 6, 8));
        private boolean mAlive;
        private final OnLayoutErrorListener mOnLayoutErrorListener;
        private final CycleDetector mCycleDetector;

        public LayoutUpdateVisitor(List<Pathfinder.PathElement> path, ArrayList<LayoutRule> args, String name, OnLayoutErrorListener onLayoutErrorListener) {
            super(path);
            this.mArgs = args;
            this.mName = name;
            this.mAlive = true;
            this.mOnLayoutErrorListener = onLayoutErrorListener;
            this.mCycleDetector = new CycleDetector();
        }

        @Override
        public void cleanup() {
            for (Map.Entry<View, int[]> original : this.mOriginalValues.entrySet()) {
                View changedView = original.getKey();
                int[] originalValue = original.getValue();
                RelativeLayout.LayoutParams originalParams = (RelativeLayout.LayoutParams)changedView.getLayoutParams();
                for (int i = 0; i < originalValue.length; ++i) {
                    originalParams.addRule(i, originalValue[i]);
                }
                changedView.setLayoutParams((ViewGroup.LayoutParams)originalParams);
            }
            this.mAlive = false;
        }

        @Override
        public void visit(View rootView) {
            if (this.mAlive) {
                this.getPathfinder().findTargetsInRoot(rootView, this.getPath(), this);
            }
        }

        @Override
        public void accumulate(View found) {
            ViewGroup parent = (ViewGroup)found;
            SparseArray idToChild = new SparseArray();
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = parent.getChildAt(i);
                int childId = child.getId();
                if (childId <= 0) continue;
                idToChild.put(childId, (Object)child);
            }
            int size = this.mArgs.size();
            for (int i = 0; i < size; ++i) {
                RelativeLayout.LayoutParams currentParams;
                int[] currentRules;
                LayoutRule layoutRule = this.mArgs.get(i);
                View currentChild = (View)idToChild.get(layoutRule.viewId);
                if (null == currentChild || (currentRules = (int[])(currentParams = (RelativeLayout.LayoutParams)currentChild.getLayoutParams()).getRules().clone())[layoutRule.verb] == layoutRule.anchor) continue;
                if (!this.mOriginalValues.containsKey(currentChild)) {
                    this.mOriginalValues.put(currentChild, currentRules);
                }
                currentParams.addRule(layoutRule.verb, layoutRule.anchor);
                Set<Integer> rules = mHorizontalRules.contains(layoutRule.verb) ? mHorizontalRules : (mVerticalRules.contains(layoutRule.verb) ? mVerticalRules : null);
                if (rules != null && !this.verifyLayout(rules, (SparseArray<View>)idToChild)) {
                    this.cleanup();
                    this.mOnLayoutErrorListener.onLayoutError(new LayoutErrorMessage("circular_dependency", this.mName));
                    return;
                }
                currentChild.setLayoutParams((ViewGroup.LayoutParams)currentParams);
            }
        }

        private boolean verifyLayout(Set<Integer> rules, SparseArray<View> idToChild) {
            ArrayMap dependencyGraph = new ArrayMap();
            int size = idToChild.size();
            for (int i = 0; i < size; ++i) {
                View child = (View)idToChild.valueAt(i);
                RelativeLayout.LayoutParams childLayoutParams = (RelativeLayout.LayoutParams)child.getLayoutParams();
                int[] layoutRules = childLayoutParams.getRules();
                ArrayList<Object> dependencies = new ArrayList<Object>();
                for (int rule : rules) {
                    int dependencyId = layoutRules[rule];
                    if (dependencyId <= 0 || dependencyId == child.getId()) continue;
                    dependencies.add(idToChild.get(dependencyId));
                }
                dependencyGraph.put((Object)child, dependencies);
            }
            return this.mCycleDetector.hasCycle((ArrayMap<View, ArrayList<View>>)dependencyGraph);
        }

        @Override
        protected String name() {
            return "Layout Update";
        }
    }

    private static class CycleDetector {
        private CycleDetector() {
        }

        public boolean hasCycle(ArrayMap<View, ArrayList<View>> dependencyGraph) {
            ArrayList<View> dfsStack = new ArrayList<View>();
            while (!dependencyGraph.isEmpty()) {
                View currentNode = (View)dependencyGraph.keyAt(0);
                if (this.detectSubgraphCycle(dependencyGraph, currentNode, dfsStack)) continue;
                return false;
            }
            return true;
        }

        private boolean detectSubgraphCycle(ArrayMap<View, ArrayList<View>> dependencyGraph, View currentNode, ArrayList<View> dfsStack) {
            if (dfsStack.contains(currentNode)) {
                return false;
            }
            if (dependencyGraph.containsKey((Object)currentNode)) {
                ArrayList dependencies = (ArrayList)dependencyGraph.remove((Object)currentNode);
                dfsStack.add(currentNode);
                int size = dependencies.size();
                for (int i = 0; i < size; ++i) {
                    if (this.detectSubgraphCycle(dependencyGraph, (View)dependencies.get(i), dfsStack)) continue;
                    return false;
                }
                dfsStack.remove(currentNode);
            }
            return true;
        }
    }

    public static class PropertySetVisitor
    extends ViewVisitor {
        private final Caller mMutator;
        private final Caller mAccessor;
        private final WeakHashMap<View, Object> mOriginalValues;
        private final Object[] mOriginalValueHolder;

        public PropertySetVisitor(List<Pathfinder.PathElement> path, Caller mutator, Caller accessor) {
            super(path);
            this.mMutator = mutator;
            this.mAccessor = accessor;
            this.mOriginalValueHolder = new Object[1];
            this.mOriginalValues = new WeakHashMap();
        }

        @Override
        public void cleanup() {
            for (Map.Entry<View, Object> original : this.mOriginalValues.entrySet()) {
                View changedView = original.getKey();
                Object originalValue = original.getValue();
                if (null == originalValue) continue;
                this.mOriginalValueHolder[0] = originalValue;
                this.mMutator.applyMethodWithArguments(changedView, this.mOriginalValueHolder);
            }
        }

        @Override
        public void accumulate(View found) {
            Object[] setArgs;
            if (null != this.mAccessor && 1 == (setArgs = this.mMutator.getArgs()).length) {
                Object desiredValue = setArgs[0];
                Object currentValue = this.mAccessor.applyMethod(found);
                if (desiredValue == currentValue) {
                    return;
                }
                if (null != desiredValue) {
                    if (desiredValue instanceof Bitmap && currentValue instanceof Bitmap) {
                        Bitmap desiredBitmap = (Bitmap)desiredValue;
                        Bitmap currentBitmap = (Bitmap)currentValue;
                        if (desiredBitmap.sameAs(currentBitmap)) {
                            return;
                        }
                    } else if (desiredValue instanceof BitmapDrawable && currentValue instanceof BitmapDrawable) {
                        Bitmap desiredBitmap = ((BitmapDrawable)desiredValue).getBitmap();
                        Bitmap currentBitmap = ((BitmapDrawable)currentValue).getBitmap();
                        if (desiredBitmap != null && desiredBitmap.sameAs(currentBitmap)) {
                            return;
                        }
                    } else if (desiredValue.equals(currentValue)) {
                        return;
                    }
                }
                if (!(currentValue instanceof Bitmap || currentValue instanceof BitmapDrawable || this.mOriginalValues.containsKey(found))) {
                    this.mOriginalValueHolder[0] = currentValue;
                    if (this.mMutator.argsAreApplicable(this.mOriginalValueHolder)) {
                        this.mOriginalValues.put(found, currentValue);
                    } else {
                        this.mOriginalValues.put(found, null);
                    }
                }
            }
            this.mMutator.applyMethod(found);
        }

        @Override
        protected String name() {
            return "Property Mutator";
        }
    }

    public static class LayoutErrorMessage {
        private final String mErrorType;
        private final String mName;

        public LayoutErrorMessage(String errorType, String name) {
            this.mErrorType = errorType;
            this.mName = name;
        }

        public String getErrorType() {
            return this.mErrorType;
        }

        public String getName() {
            return this.mName;
        }
    }

    public static interface OnLayoutErrorListener {
        public void onLayoutError(LayoutErrorMessage var1);
    }

    public static interface OnEventListener {
        public void OnEvent(View var1, String var2, boolean var3);
    }
}

