/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.mixpanel.android.mpmetrics.DecideChecker;
import com.mixpanel.android.mpmetrics.DecideMessages;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MPDbAdapter;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.ServerMessage;
import com.mixpanel.android.mpmetrics.SystemInformation;
import com.mixpanel.android.util.Base64Coder;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

class AnalyticsMessages {
    private final Worker mWorker;
    private final Context mContext;
    private final MPConfig mConfig;
    private static int ENQUEUE_PEOPLE = 0;
    private static int ENQUEUE_EVENTS = 1;
    private static int FLUSH_QUEUE = 2;
    private static int KILL_WORKER = 5;
    private static int INSTALL_DECIDE_CHECK = 12;
    private static int REGISTER_FOR_GCM = 13;
    private static final String LOGTAG = "MixpanelAPI.AnalyticsMessages";
    private static final Map<Context, AnalyticsMessages> sInstances = new HashMap<Context, AnalyticsMessages>();

    AnalyticsMessages(Context context) {
        this.mContext = context;
        this.mConfig = this.getConfig(context);
        this.mWorker = new Worker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyticsMessages getInstance(Context messageContext) {
        Map<Context, AnalyticsMessages> map = sInstances;
        synchronized (map) {
            AnalyticsMessages ret;
            Context appContext = messageContext.getApplicationContext();
            if (!sInstances.containsKey(appContext)) {
                ret = new AnalyticsMessages(appContext);
                sInstances.put(appContext, ret);
            } else {
                ret = sInstances.get(appContext);
            }
            return ret;
        }
    }

    public void eventsMessage(EventDescription eventDescription) {
        Message m = Message.obtain();
        m.what = ENQUEUE_EVENTS;
        m.obj = eventDescription;
        this.mWorker.runMessage(m);
    }

    public void peopleMessage(JSONObject peopleJson) {
        Message m = Message.obtain();
        m.what = ENQUEUE_PEOPLE;
        m.obj = peopleJson;
        this.mWorker.runMessage(m);
    }

    public void postToServer() {
        Message m = Message.obtain();
        m.what = FLUSH_QUEUE;
        this.mWorker.runMessage(m);
    }

    public void installDecideCheck(DecideMessages check) {
        Message m = Message.obtain();
        m.what = INSTALL_DECIDE_CHECK;
        m.obj = check;
        this.mWorker.runMessage(m);
    }

    public void registerForGCM(String senderID) {
        Message m = Message.obtain();
        m.what = REGISTER_FOR_GCM;
        m.obj = senderID;
        this.mWorker.runMessage(m);
    }

    public void hardKill() {
        Message m = Message.obtain();
        m.what = KILL_WORKER;
        this.mWorker.runMessage(m);
    }

    boolean isDead() {
        return this.mWorker.isDead();
    }

    protected MPDbAdapter makeDbAdapter(Context context) {
        return new MPDbAdapter(context);
    }

    protected MPConfig getConfig(Context context) {
        return MPConfig.getInstance(context);
    }

    protected ServerMessage getPoster() {
        return new ServerMessage();
    }

    private void logAboutMessageToMixpanel(String message) {
        if (MPConfig.DEBUG) {
            Log.v((String)LOGTAG, (String)(message + " (Thread " + Thread.currentThread().getId() + ")"));
        }
    }

    private void logAboutMessageToMixpanel(String message, Throwable e) {
        if (MPConfig.DEBUG) {
            Log.v((String)LOGTAG, (String)(message + " (Thread " + Thread.currentThread().getId() + ")"), (Throwable)e);
        }
    }

    private class Worker {
        private final Object mHandlerLock = new Object();
        private Handler mHandler = this.restartWorkerThread();
        private long mFlushCount = 0L;
        private long mAveFlushFrequency = 0L;
        private long mLastFlushTime = -1L;
        private SystemInformation mSystemInformation;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDead() {
            Object object = this.mHandlerLock;
            synchronized (object) {
                return this.mHandler == null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runMessage(Message msg) {
            Object object = this.mHandlerLock;
            synchronized (object) {
                if (this.mHandler == null) {
                    AnalyticsMessages.this.logAboutMessageToMixpanel("Dead mixpanel worker dropping a message: " + msg.what);
                } else {
                    this.mHandler.sendMessage(msg);
                }
            }
        }

        private Handler restartWorkerThread() {
            HandlerThread thread = new HandlerThread("com.mixpanel.android.AnalyticsWorker", 1);
            thread.start();
            AnalyticsMessageHandler ret = new AnalyticsMessageHandler(thread.getLooper());
            return ret;
        }

        private void updateFlushFrequency() {
            long now = System.currentTimeMillis();
            long newFlushCount = this.mFlushCount + 1L;
            if (this.mLastFlushTime > 0L) {
                long flushInterval = now - this.mLastFlushTime;
                long totalFlushTime = flushInterval + this.mAveFlushFrequency * this.mFlushCount;
                this.mAveFlushFrequency = totalFlushTime / newFlushCount;
                long seconds = this.mAveFlushFrequency / 1000L;
                AnalyticsMessages.this.logAboutMessageToMixpanel("Average send frequency approximately " + seconds + " seconds.");
            }
            this.mLastFlushTime = now;
            this.mFlushCount = newFlushCount;
        }

        private class AnalyticsMessageHandler
        extends Handler {
            private MPDbAdapter mDbAdapter;
            private final DecideChecker mDecideChecker;
            private final long mFlushInterval;
            private final boolean mDisableFallback;

            public AnalyticsMessageHandler(Looper looper) {
                super(looper);
                this.mDbAdapter = null;
                this.mDecideChecker = new DecideChecker(AnalyticsMessages.this.mContext, AnalyticsMessages.this.mConfig);
                this.mDisableFallback = AnalyticsMessages.this.mConfig.getDisableFallback();
                this.mFlushInterval = AnalyticsMessages.this.mConfig.getFlushInterval();
                Worker.this.mSystemInformation = new SystemInformation(AnalyticsMessages.this.mContext);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                if (this.mDbAdapter == null) {
                    this.mDbAdapter = AnalyticsMessages.this.makeDbAdapter(AnalyticsMessages.this.mContext);
                    this.mDbAdapter.cleanupEvents(System.currentTimeMillis() - (long)AnalyticsMessages.this.mConfig.getDataExpiration(), MPDbAdapter.Table.EVENTS);
                    this.mDbAdapter.cleanupEvents(System.currentTimeMillis() - (long)AnalyticsMessages.this.mConfig.getDataExpiration(), MPDbAdapter.Table.PEOPLE);
                }
                try {
                    int queueDepth = -1;
                    if (msg.what == ENQUEUE_PEOPLE) {
                        JSONObject message = (JSONObject)msg.obj;
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Queuing people record for sending later");
                        AnalyticsMessages.this.logAboutMessageToMixpanel("    " + message.toString());
                        queueDepth = this.mDbAdapter.addJSON(message, MPDbAdapter.Table.PEOPLE);
                    } else if (msg.what == ENQUEUE_EVENTS) {
                        EventDescription eventDescription = (EventDescription)msg.obj;
                        try {
                            JSONObject message = this.prepareEventObject(eventDescription);
                            AnalyticsMessages.this.logAboutMessageToMixpanel("Queuing event for sending later");
                            AnalyticsMessages.this.logAboutMessageToMixpanel("    " + message.toString());
                            queueDepth = this.mDbAdapter.addJSON(message, MPDbAdapter.Table.EVENTS);
                        }
                        catch (JSONException e) {
                            Log.e((String)AnalyticsMessages.LOGTAG, (String)("Exception tracking event " + eventDescription.getEventName()), (Throwable)e);
                        }
                    } else if (msg.what == FLUSH_QUEUE) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Flushing queue due to scheduled or forced flush");
                        Worker.this.updateFlushFrequency();
                        this.sendAllData(this.mDbAdapter);
                        this.mDecideChecker.runDecideChecks(AnalyticsMessages.this.getPoster());
                    } else if (msg.what == INSTALL_DECIDE_CHECK) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Installing a check for surveys and in app notifications");
                        DecideMessages check = (DecideMessages)msg.obj;
                        this.mDecideChecker.addDecideCheck(check);
                        this.mDecideChecker.runDecideChecks(AnalyticsMessages.this.getPoster());
                    } else if (msg.what == REGISTER_FOR_GCM) {
                        String senderId = (String)msg.obj;
                        this.runGCMRegistration(senderId);
                    } else if (msg.what == KILL_WORKER) {
                        Log.w((String)AnalyticsMessages.LOGTAG, (String)("Worker received a hard kill. Dumping all events and force-killing. Thread id " + Thread.currentThread().getId()));
                        Object object = Worker.this.mHandlerLock;
                        synchronized (object) {
                            this.mDbAdapter.deleteDB();
                            Worker.this.mHandler = null;
                            Looper.myLooper().quit();
                        }
                    } else {
                        Log.e((String)AnalyticsMessages.LOGTAG, (String)("Unexpected message received by Mixpanel worker: " + msg));
                    }
                    if (queueDepth >= AnalyticsMessages.this.mConfig.getBulkUploadLimit()) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Flushing queue due to bulk upload limit");
                        Worker.this.updateFlushFrequency();
                        this.sendAllData(this.mDbAdapter);
                        this.mDecideChecker.runDecideChecks(AnalyticsMessages.this.getPoster());
                    } else if (queueDepth > 0 && !this.hasMessages(FLUSH_QUEUE)) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Queue depth " + queueDepth + " - Adding flush in " + this.mFlushInterval);
                        if (this.mFlushInterval >= 0L) {
                            this.sendEmptyMessageDelayed(FLUSH_QUEUE, this.mFlushInterval);
                        }
                    }
                }
                catch (RuntimeException e) {
                    Log.e((String)AnalyticsMessages.LOGTAG, (String)"Worker threw an unhandled exception", (Throwable)e);
                    Object object = Worker.this.mHandlerLock;
                    synchronized (object) {
                        Worker.this.mHandler = null;
                        try {
                            Looper.myLooper().quit();
                            Log.e((String)AnalyticsMessages.LOGTAG, (String)"Mixpanel will not process any more analytics messages", (Throwable)e);
                        }
                        catch (Exception tooLate) {
                            Log.e((String)AnalyticsMessages.LOGTAG, (String)"Could not halt looper", (Throwable)tooLate);
                        }
                    }
                }
            }

            private void runGCMRegistration(String senderID) {
                String registrationId;
                try {
                    try {
                        int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)AnalyticsMessages.this.mContext);
                        if (resultCode != 0) {
                            Log.i((String)AnalyticsMessages.LOGTAG, (String)"Can't register for push notifications, Google Play Services are not installed.");
                            return;
                        }
                    }
                    catch (RuntimeException e) {
                        Log.i((String)AnalyticsMessages.LOGTAG, (String)"Can't register for push notifications, Google Play services are not configured.");
                        return;
                    }
                    GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)AnalyticsMessages.this.mContext);
                    registrationId = gcm.register(new String[]{senderID});
                }
                catch (IOException e) {
                    Log.i((String)AnalyticsMessages.LOGTAG, (String)"Exception when trying to register for GCM", (Throwable)e);
                    return;
                }
                catch (NoClassDefFoundError e) {
                    Log.w((String)AnalyticsMessages.LOGTAG, (String)"Google play services were not part of this build, push notifications cannot be registered or delivered");
                    return;
                }
                MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

                    @Override
                    public void process(MixpanelAPI api) {
                        if (MPConfig.DEBUG) {
                            Log.v((String)AnalyticsMessages.LOGTAG, (String)("Using existing pushId " + registrationId));
                        }
                        api.getPeople().setPushRegistrationId(registrationId);
                    }
                });
            }

            private void sendAllData(MPDbAdapter dbAdapter) {
                ServerMessage poster = AnalyticsMessages.this.getPoster();
                if (!poster.isOnline(AnalyticsMessages.this.mContext)) {
                    AnalyticsMessages.this.logAboutMessageToMixpanel("Not flushing data to Mixpanel because the device is not connected to the internet.");
                    return;
                }
                AnalyticsMessages.this.logAboutMessageToMixpanel("Sending records to Mixpanel");
                if (this.mDisableFallback) {
                    this.sendData(dbAdapter, MPDbAdapter.Table.EVENTS, new String[]{AnalyticsMessages.this.mConfig.getEventsEndpoint()});
                    this.sendData(dbAdapter, MPDbAdapter.Table.PEOPLE, new String[]{AnalyticsMessages.this.mConfig.getPeopleEndpoint()});
                } else {
                    this.sendData(dbAdapter, MPDbAdapter.Table.EVENTS, new String[]{AnalyticsMessages.this.mConfig.getEventsEndpoint(), AnalyticsMessages.this.mConfig.getEventsFallbackEndpoint()});
                    this.sendData(dbAdapter, MPDbAdapter.Table.PEOPLE, new String[]{AnalyticsMessages.this.mConfig.getPeopleEndpoint(), AnalyticsMessages.this.mConfig.getPeopleFallbackEndpoint()});
                }
            }

            private void sendData(MPDbAdapter dbAdapter, MPDbAdapter.Table table, String[] urls) {
                ServerMessage poster = AnalyticsMessages.this.getPoster();
                String[] eventsData = dbAdapter.generateDataString(table);
                if (eventsData != null) {
                    String lastId = eventsData[0];
                    String rawMessage = eventsData[1];
                    String encodedData = Base64Coder.encodeString(rawMessage);
                    ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(1);
                    params.add((NameValuePair)new BasicNameValuePair("data", encodedData));
                    if (MPConfig.DEBUG) {
                        params.add((NameValuePair)new BasicNameValuePair("verbose", "1"));
                    }
                    boolean deleteEvents = true;
                    for (String url : urls) {
                        try {
                            String parsedResponse;
                            byte[] response = poster.performRequest(url, params);
                            deleteEvents = true;
                            if (null == response) {
                                AnalyticsMessages.this.logAboutMessageToMixpanel("Response was null, unexpected failure posting to " + url + ".");
                                break;
                            }
                            try {
                                parsedResponse = new String(response, "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new RuntimeException("UTF not supported on this platform?", e);
                            }
                            AnalyticsMessages.this.logAboutMessageToMixpanel("Successfully posted to " + url + ": \n" + rawMessage);
                            AnalyticsMessages.this.logAboutMessageToMixpanel("Response was " + parsedResponse);
                            break;
                        }
                        catch (OutOfMemoryError e) {
                            Log.e((String)AnalyticsMessages.LOGTAG, (String)("Out of memory when posting to " + url + "."), (Throwable)e);
                            break;
                        }
                        catch (MalformedURLException e) {
                            Log.e((String)AnalyticsMessages.LOGTAG, (String)("Cannot interpret " + url + " as a URL."), (Throwable)e);
                            break;
                        }
                        catch (IOException e) {
                            AnalyticsMessages.this.logAboutMessageToMixpanel("Cannot post message to " + url + ".", e);
                            deleteEvents = false;
                        }
                    }
                    if (deleteEvents) {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Not retrying this batch of events, deleting them from DB.");
                        dbAdapter.cleanupEvents(lastId, table);
                    } else {
                        AnalyticsMessages.this.logAboutMessageToMixpanel("Retrying this batch of events.");
                        if (!this.hasMessages(FLUSH_QUEUE)) {
                            this.sendEmptyMessageDelayed(FLUSH_QUEUE, this.mFlushInterval);
                        }
                    }
                }
            }

            private JSONObject getDefaultEventProperties() throws JSONException {
                String bluetoothVersion;
                Boolean isBluetoothEnabled;
                Boolean isWifi;
                String carrier;
                Boolean hasTelephony;
                Boolean hasNFC;
                JSONObject ret = new JSONObject();
                ret.put("mp_lib", (Object)"android");
                ret.put("$lib_version", (Object)"4.5.1-SNAPSHOT");
                ret.put("$os", (Object)"Android");
                ret.put("$os_version", (Object)(Build.VERSION.RELEASE == null ? "UNKNOWN" : Build.VERSION.RELEASE));
                ret.put("$manufacturer", (Object)(Build.MANUFACTURER == null ? "UNKNOWN" : Build.MANUFACTURER));
                ret.put("$brand", (Object)(Build.BRAND == null ? "UNKNOWN" : Build.BRAND));
                ret.put("$model", (Object)(Build.MODEL == null ? "UNKNOWN" : Build.MODEL));
                try {
                    try {
                        int servicesAvailable = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)AnalyticsMessages.this.mContext);
                        switch (servicesAvailable) {
                            case 0: {
                                ret.put("$google_play_services", (Object)"available");
                                break;
                            }
                            case 1: {
                                ret.put("$google_play_services", (Object)"missing");
                                break;
                            }
                            case 2: {
                                ret.put("$google_play_services", (Object)"out of date");
                                break;
                            }
                            case 3: {
                                ret.put("$google_play_services", (Object)"disabled");
                                break;
                            }
                            case 9: {
                                ret.put("$google_play_services", (Object)"invalid");
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        ret.put("$google_play_services", (Object)"not configured");
                    }
                }
                catch (NoClassDefFoundError e) {
                    ret.put("$google_play_services", (Object)"not included");
                }
                DisplayMetrics displayMetrics = Worker.this.mSystemInformation.getDisplayMetrics();
                ret.put("$screen_dpi", displayMetrics.densityDpi);
                ret.put("$screen_height", displayMetrics.heightPixels);
                ret.put("$screen_width", displayMetrics.widthPixels);
                String applicationVersionName = Worker.this.mSystemInformation.getAppVersionName();
                if (null != applicationVersionName) {
                    ret.put("$app_version", (Object)applicationVersionName);
                }
                if (null != (hasNFC = Boolean.valueOf(Worker.this.mSystemInformation.hasNFC()))) {
                    ret.put("$has_nfc", hasNFC.booleanValue());
                }
                if (null != (hasTelephony = Boolean.valueOf(Worker.this.mSystemInformation.hasTelephony()))) {
                    ret.put("$has_telephone", hasTelephony.booleanValue());
                }
                if (null != (carrier = Worker.this.mSystemInformation.getCurrentNetworkOperator())) {
                    ret.put("$carrier", (Object)carrier);
                }
                if (null != (isWifi = Worker.this.mSystemInformation.isWifiConnected())) {
                    ret.put("$wifi", isWifi.booleanValue());
                }
                if ((isBluetoothEnabled = Worker.this.mSystemInformation.isBluetoothEnabled()) != null) {
                    ret.put("$bluetooth_enabled", (Object)isBluetoothEnabled);
                }
                if ((bluetoothVersion = Worker.this.mSystemInformation.getBluetoothVersion()) != null) {
                    ret.put("$bluetooth_version", (Object)bluetoothVersion);
                }
                return ret;
            }

            private JSONObject prepareEventObject(EventDescription eventDescription) throws JSONException {
                JSONObject eventObj = new JSONObject();
                JSONObject eventProperties = eventDescription.getProperties();
                JSONObject sendProperties = this.getDefaultEventProperties();
                sendProperties.put("token", (Object)eventDescription.getToken());
                if (eventProperties != null) {
                    Iterator iter = eventProperties.keys();
                    while (iter.hasNext()) {
                        String key = (String)iter.next();
                        sendProperties.put(key, eventProperties.get(key));
                    }
                }
                eventObj.put("event", (Object)eventDescription.getEventName());
                eventObj.put("properties", (Object)sendProperties);
                return eventObj;
            }
        }
    }

    static class EventDescription {
        private final String eventName;
        private final JSONObject properties;
        private final String token;

        public EventDescription(String eventName, JSONObject properties, String token) {
            this.eventName = eventName;
            this.properties = properties;
            this.token = token;
        }

        public String getEventName() {
            return this.eventName;
        }

        public JSONObject getProperties() {
            return this.properties;
        }

        public String getToken() {
            return this.token;
        }
    }
}

