/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.java_websocket.drafts;

import com.mixpanel.android.java_websocket.WebSocket;
import com.mixpanel.android.java_websocket.drafts.Draft;
import com.mixpanel.android.java_websocket.drafts.Draft_75;
import com.mixpanel.android.java_websocket.exceptions.IncompleteHandshakeException;
import com.mixpanel.android.java_websocket.exceptions.InvalidDataException;
import com.mixpanel.android.java_websocket.exceptions.InvalidFrameException;
import com.mixpanel.android.java_websocket.exceptions.InvalidHandshakeException;
import com.mixpanel.android.java_websocket.framing.CloseFrameBuilder;
import com.mixpanel.android.java_websocket.framing.Framedata;
import com.mixpanel.android.java_websocket.handshake.ClientHandshake;
import com.mixpanel.android.java_websocket.handshake.ClientHandshakeBuilder;
import com.mixpanel.android.java_websocket.handshake.HandshakeBuilder;
import com.mixpanel.android.java_websocket.handshake.Handshakedata;
import com.mixpanel.android.java_websocket.handshake.ServerHandshake;
import com.mixpanel.android.java_websocket.handshake.ServerHandshakeBuilder;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class Draft_76
extends Draft_75 {
    private boolean failed = false;
    private static final byte[] closehandshake = new byte[]{-1, 0};
    private final Random reuseableRandom = new Random();

    public static byte[] createChallenge(String key1, String key2, byte[] key3) throws InvalidHandshakeException {
        MessageDigest md5;
        byte[] part1 = Draft_76.getPart(key1);
        byte[] part2 = Draft_76.getPart(key2);
        byte[] challenge = new byte[]{part1[0], part1[1], part1[2], part1[3], part2[0], part2[1], part2[2], part2[3], key3[0], key3[1], key3[2], key3[3], key3[4], key3[5], key3[6], key3[7]};
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return md5.digest(challenge);
    }

    private static String generateKey() {
        int position;
        int i;
        Random r = new Random();
        long maxNumber = 0xFFFFFFFFL;
        long spaces = r.nextInt(12) + 1;
        int max = new Long(maxNumber / spaces).intValue();
        max = Math.abs(max);
        int number = r.nextInt(max) + 1;
        long product = (long)number * spaces;
        String key = Long.toString(product);
        int numChars = r.nextInt(12) + 1;
        for (i = 0; i < numChars; ++i) {
            position = r.nextInt(key.length());
            position = Math.abs(position);
            char randChar = (char)(r.nextInt(95) + 33);
            if (randChar >= '0' && randChar <= '9') {
                randChar = (char)(randChar - 15);
            }
            key = new StringBuilder(key).insert(position, randChar).toString();
        }
        i = 0;
        while ((long)i < spaces) {
            position = r.nextInt(key.length() - 1) + 1;
            position = Math.abs(position);
            key = new StringBuilder(key).insert(position, " ").toString();
            ++i;
        }
        return key;
    }

    private static byte[] getPart(String key) throws InvalidHandshakeException {
        try {
            long keyNumber = Long.parseLong(key.replaceAll("[^0-9]", ""));
            long keySpace = key.split(" ").length - 1;
            if (keySpace == 0L) {
                throw new InvalidHandshakeException("invalid Sec-WebSocket-Key (/key2/)");
            }
            long part = new Long(keyNumber / keySpace);
            return new byte[]{(byte)(part >> 24), (byte)(part << 8 >> 24), (byte)(part << 16 >> 24), (byte)(part << 24 >> 24)};
        }
        catch (NumberFormatException e) {
            throw new InvalidHandshakeException("invalid Sec-WebSocket-Key (/key1/ or /key2/)");
        }
    }

    @Override
    public Draft.HandshakeState acceptHandshakeAsClient(ClientHandshake request, ServerHandshake response) {
        if (this.failed) {
            return Draft.HandshakeState.NOT_MATCHED;
        }
        try {
            if (!response.getFieldValue("Sec-WebSocket-Origin").equals(request.getFieldValue("Origin")) || !this.basicAccept(response)) {
                return Draft.HandshakeState.NOT_MATCHED;
            }
            byte[] content = response.getContent();
            if (content == null || content.length == 0) {
                throw new IncompleteHandshakeException();
            }
            if (Arrays.equals(content, Draft_76.createChallenge(request.getFieldValue("Sec-WebSocket-Key1"), request.getFieldValue("Sec-WebSocket-Key2"), request.getContent()))) {
                return Draft.HandshakeState.MATCHED;
            }
            return Draft.HandshakeState.NOT_MATCHED;
        }
        catch (InvalidHandshakeException e) {
            throw new RuntimeException("bad handshakerequest", e);
        }
    }

    @Override
    public Draft.HandshakeState acceptHandshakeAsServer(ClientHandshake handshakedata) {
        if (handshakedata.getFieldValue("Upgrade").equals("WebSocket") && handshakedata.getFieldValue("Connection").contains("Upgrade") && handshakedata.getFieldValue("Sec-WebSocket-Key1").length() > 0 && !handshakedata.getFieldValue("Sec-WebSocket-Key2").isEmpty() && handshakedata.hasFieldValue("Origin")) {
            return Draft.HandshakeState.MATCHED;
        }
        return Draft.HandshakeState.NOT_MATCHED;
    }

    @Override
    public ClientHandshakeBuilder postProcessHandshakeRequestAsClient(ClientHandshakeBuilder request) {
        request.put("Upgrade", "WebSocket");
        request.put("Connection", "Upgrade");
        request.put("Sec-WebSocket-Key1", Draft_76.generateKey());
        request.put("Sec-WebSocket-Key2", Draft_76.generateKey());
        if (!request.hasFieldValue("Origin")) {
            request.put("Origin", "random" + this.reuseableRandom.nextInt());
        }
        byte[] key3 = new byte[8];
        this.reuseableRandom.nextBytes(key3);
        request.setContent(key3);
        return request;
    }

    @Override
    public HandshakeBuilder postProcessHandshakeResponseAsServer(ClientHandshake request, ServerHandshakeBuilder response) throws InvalidHandshakeException {
        response.setHttpStatusMessage("WebSocket Protocol Handshake");
        response.put("Upgrade", "WebSocket");
        response.put("Connection", request.getFieldValue("Connection"));
        response.put("Sec-WebSocket-Origin", request.getFieldValue("Origin"));
        String location = "ws://" + request.getFieldValue("Host") + request.getResourceDescriptor();
        response.put("Sec-WebSocket-Location", location);
        String key1 = request.getFieldValue("Sec-WebSocket-Key1");
        String key2 = request.getFieldValue("Sec-WebSocket-Key2");
        byte[] key3 = request.getContent();
        if (key1 == null || key2 == null || key3 == null || key3.length != 8) {
            throw new InvalidHandshakeException("Bad keys");
        }
        response.setContent(Draft_76.createChallenge(key1, key2, key3));
        return response;
    }

    @Override
    public Handshakedata translateHandshake(ByteBuffer buf) throws InvalidHandshakeException {
        HandshakeBuilder bui = Draft_76.translateHandshakeHttp(buf, this.role);
        if ((bui.hasFieldValue("Sec-WebSocket-Key1") || this.role == WebSocket.Role.CLIENT) && !bui.hasFieldValue("Sec-WebSocket-Version")) {
            byte[] key3 = new byte[this.role == WebSocket.Role.SERVER ? 8 : 16];
            try {
                buf.get(key3);
            }
            catch (BufferUnderflowException e) {
                throw new IncompleteHandshakeException(buf.capacity() + 16);
            }
            bui.setContent(key3);
        }
        return bui;
    }

    @Override
    public List<Framedata> translateFrame(ByteBuffer buffer) throws InvalidDataException {
        buffer.mark();
        List frames = super.translateRegularFrame(buffer);
        if (frames == null) {
            buffer.reset();
            frames = this.readyframes;
            this.readingState = true;
            if (this.currentFrame != null) {
                throw new InvalidFrameException();
            }
            this.currentFrame = ByteBuffer.allocate(2);
            if (buffer.remaining() > this.currentFrame.remaining()) {
                throw new InvalidFrameException();
            }
            this.currentFrame.put(buffer);
            if (!this.currentFrame.hasRemaining()) {
                if (Arrays.equals(this.currentFrame.array(), closehandshake)) {
                    frames.add(new CloseFrameBuilder(1000));
                    return frames;
                }
                throw new InvalidFrameException();
            }
            this.readyframes = new LinkedList();
            return frames;
        }
        return frames;
    }

    @Override
    public ByteBuffer createBinaryFrame(Framedata framedata) {
        if (framedata.getOpcode() == Framedata.Opcode.CLOSING) {
            return ByteBuffer.wrap(closehandshake);
        }
        return super.createBinaryFrame(framedata);
    }

    @Override
    public Draft.CloseHandshakeType getCloseHandshakeType() {
        return Draft.CloseHandshakeType.ONEWAY;
    }

    @Override
    public Draft copyInstance() {
        return new Draft_76();
    }
}

