/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.os.AsyncTask;
import com.mixpanel.android.util.ActivityImageUtils;
import com.mixpanel.android.util.StackBlurManager;

class BackgroundCapture {
    private static final int GRAY_72PERCENT_OPAQUE = Color.argb((int)186, (int)28, (int)28, (int)28);
    private static final String LOGTAG = "MixpanelAPI.BackgroundCapture";

    BackgroundCapture() {
    }

    public static void captureBackground(final Activity parentActivity, final OnBackgroundCapturedListener listener) {
        parentActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BackgroundCaptureTask task = new BackgroundCaptureTask(parentActivity, listener);
                task.execute(new Void[0]);
            }
        });
    }

    private static class BackgroundCaptureTask
    extends AsyncTask<Void, Void, Void> {
        private final OnBackgroundCapturedListener mListener;
        private final Activity mParentActivity;
        private Bitmap mSourceImage;
        private int mCalculatedHighlightColor;

        public BackgroundCaptureTask(Activity parentActivity, OnBackgroundCapturedListener listener) {
            this.mParentActivity = parentActivity;
            this.mListener = listener;
            this.mCalculatedHighlightColor = -16777216;
        }

        protected void onPreExecute() {
            this.mSourceImage = ActivityImageUtils.getScaledScreenshot(this.mParentActivity, 2, 2, true);
            this.mCalculatedHighlightColor = ActivityImageUtils.getHighlightColorFromBitmap(this.mSourceImage);
        }

        protected Void doInBackground(Void ... params) {
            if (null != this.mSourceImage) {
                try {
                    StackBlurManager.process(this.mSourceImage, 20);
                    Canvas canvas = new Canvas(this.mSourceImage);
                    canvas.drawColor(GRAY_72PERCENT_OPAQUE, PorterDuff.Mode.SRC_ATOP);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.mSourceImage = null;
                }
                catch (OutOfMemoryError e) {
                    this.mSourceImage = null;
                }
            }
            return null;
        }

        protected void onPostExecute(Void _) {
            this.mListener.onBackgroundCaptured(this.mSourceImage, this.mCalculatedHighlightColor);
        }
    }

    public static interface OnBackgroundCapturedListener {
        public void onBackgroundCaptured(Bitmap var1, int var2);
    }
}

