/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MPConfig;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;

class ServerMessage {
    private static final String LOGTAG = "MixpanelAPI";

    ServerMessage() {
    }

    public boolean isOnline(Context context) {
        boolean isOnline;
        block3: {
            try {
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo netInfo = cm.getActiveNetworkInfo();
                boolean bl = isOnline = netInfo != null && netInfo.isConnectedOrConnecting();
                if (MPConfig.DEBUG) {
                    Log.d((String)LOGTAG, (String)("ConnectivityManager says we " + (isOnline ? "are" : "are not") + " online"));
                }
            }
            catch (SecurityException e) {
                isOnline = true;
                if (!MPConfig.DEBUG) break block3;
                Log.d((String)LOGTAG, (String)"Don't have permission to check connectivity, assuming online");
            }
        }
        return isOnline;
    }

    public byte[] getUrls(Context context, String[] urls) {
        if (!this.isOnline(context)) {
            return null;
        }
        byte[] response = null;
        for (String url : urls) {
            try {
                response = this.performRequest(url, null);
                break;
            }
            catch (MalformedURLException e) {
                Log.e((String)LOGTAG, (String)("Cannot interpret " + url + " as a URL."), (Throwable)e);
            }
            catch (IOException e) {
                if (!MPConfig.DEBUG) continue;
                Log.d((String)LOGTAG, (String)("Cannot get " + url + "."), (Throwable)e);
            }
            catch (OutOfMemoryError e) {
                Log.e((String)LOGTAG, (String)("Out of memory when getting to " + url + "."), (Throwable)e);
                break;
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] performRequest(String endpointUrl, List<NameValuePair> params) throws IOException {
        if (MPConfig.DEBUG) {
            Log.d((String)LOGTAG, (String)("Attempting request to " + endpointUrl));
        }
        byte[] response = null;
        int retries = 0;
        boolean succeeded = false;
        while (retries < 3 && !succeeded) {
            InputStream in = null;
            OutputStream out = null;
            FilterOutputStream bout = null;
            HttpURLConnection connection = null;
            try {
                URL url = new URL(endpointUrl);
                connection = (HttpURLConnection)url.openConnection();
                connection.setConnectTimeout(2000);
                connection.setReadTimeout(10000);
                if (null != params) {
                    connection.setDoOutput(true);
                    UrlEncodedFormEntity form = new UrlEncodedFormEntity(params, "UTF-8");
                    connection.setRequestMethod("POST");
                    connection.setFixedLengthStreamingMode((int)form.getContentLength());
                    out = connection.getOutputStream();
                    bout = new BufferedOutputStream(out);
                    form.writeTo((OutputStream)bout);
                    bout.close();
                    bout = null;
                    out.close();
                    out = null;
                }
                in = connection.getInputStream();
                response = this.slurp(in);
                in.close();
                in = null;
                succeeded = true;
            }
            catch (EOFException e) {
                if (MPConfig.DEBUG) {
                    Log.d((String)LOGTAG, (String)"Failure to connect, likely caused by a known issue with Android lib. Retrying.");
                }
                ++retries;
            }
            finally {
                if (null != bout) {
                    try {
                        bout.close();
                    }
                    catch (IOException e) {}
                }
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (null == connection) continue;
                connection.disconnect();
            }
        }
        return response;
    }

    private byte[] slurp(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

