/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.util.Base64Coder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONException;
import org.json.JSONObject;

class ServerMessage {
    private static final String LOGTAG = "MixpanelAPI";
    private static final Result OFFLINE_RESULT = new Result(Status.FAILED_RECOVERABLE, null);

    ServerMessage() {
    }

    public boolean isOnline(Context context) {
        boolean isOnline;
        block3: {
            try {
                ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
                NetworkInfo netInfo = cm.getActiveNetworkInfo();
                boolean bl = isOnline = netInfo != null && netInfo.isConnectedOrConnecting();
                if (MPConfig.DEBUG) {
                    Log.d((String)LOGTAG, (String)("ConnectivityManager says we " + (isOnline ? "are" : "are not") + " online"));
                }
            }
            catch (SecurityException e) {
                isOnline = true;
                if (!MPConfig.DEBUG) break block3;
                Log.d((String)LOGTAG, (String)"Don't have permission to check connectivity, assuming online");
            }
        }
        return isOnline;
    }

    public Result postData(Context context, String rawMessage, String endpointUrl, String fallbackUrl) {
        Result result;
        Status baseStatus;
        if (!this.isOnline(context)) {
            return OFFLINE_RESULT;
        }
        Status status = Status.FAILED_UNRECOVERABLE;
        String encodedData = Base64Coder.encodeString(rawMessage);
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>(1);
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("data", encodedData));
        if (MPConfig.DEBUG) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("verbose", "1"));
        }
        if ((baseStatus = (result = this.performRequest(endpointUrl, nameValuePairs)).getStatus()) == Status.SUCCEEDED) {
            String baseResponse = result.getResponse();
            if (MPConfig.DEBUG) {
                try {
                    JSONObject verboseResponse = new JSONObject(baseResponse);
                    if (verboseResponse.optInt("status") == 1) {
                        status = Status.SUCCEEDED;
                    }
                }
                catch (JSONException e) {
                    status = Status.FAILED_UNRECOVERABLE;
                }
            } else if (baseResponse.equals("1\n")) {
                status = Status.SUCCEEDED;
            }
        }
        if (baseStatus == Status.FAILED_RECOVERABLE && fallbackUrl != null) {
            Status retryStatus;
            if (MPConfig.DEBUG) {
                Log.d((String)LOGTAG, (String)("Retrying post with new URL: " + fallbackUrl));
            }
            if ((retryStatus = (result = this.postData(context, rawMessage, fallbackUrl, null)).getStatus()) != Status.SUCCEEDED) {
                Log.e((String)LOGTAG, (String)"Could not post data to Mixpanel");
            } else {
                status = Status.SUCCEEDED;
            }
        }
        return new Result(status, result.getResponseBytes());
    }

    public Result get(Context context, String endpointUrl, String fallbackUrl) {
        if (!this.isOnline(context)) {
            return OFFLINE_RESULT;
        }
        Result ret = this.performRequest(endpointUrl, null);
        if (ret.getStatus() == Status.FAILED_RECOVERABLE && fallbackUrl != null) {
            ret = this.get(context, fallbackUrl, null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result performRequest(String endpointUrl, List<NameValuePair> nameValuePairs) {
        Status status = Status.FAILED_UNRECOVERABLE;
        byte[] response = null;
        try {
            int retries = 0;
            boolean succeeded = false;
            while (retries < 3 && !succeeded) {
                InputStream in = null;
                OutputStream out = null;
                FilterOutputStream bout = null;
                HttpURLConnection connection = null;
                try {
                    URL url = new URL(endpointUrl);
                    connection = (HttpURLConnection)url.openConnection();
                    connection.setConnectTimeout(2000);
                    connection.setReadTimeout(10000);
                    if (null != nameValuePairs) {
                        connection.setDoOutput(true);
                        UrlEncodedFormEntity form = new UrlEncodedFormEntity(nameValuePairs, "UTF-8");
                        connection.setRequestMethod("POST");
                        connection.setFixedLengthStreamingMode((int)form.getContentLength());
                        out = connection.getOutputStream();
                        bout = new BufferedOutputStream(out);
                        form.writeTo((OutputStream)bout);
                        bout.close();
                        bout = null;
                        out.close();
                        out = null;
                    }
                    in = connection.getInputStream();
                    response = this.slurp(in);
                    in.close();
                    in = null;
                    succeeded = true;
                }
                catch (EOFException e) {
                    if (MPConfig.DEBUG) {
                        Log.d((String)LOGTAG, (String)"Failure to connect, likely caused by a known issue with Android lib. Retrying.");
                    }
                    ++retries;
                }
                finally {
                    if (null != bout) {
                        try {
                            bout.close();
                        }
                        catch (IOException e) {}
                    }
                    if (null != out) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {}
                    }
                    if (null != in) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                    if (null == connection) continue;
                    connection.disconnect();
                }
            }
        }
        catch (MalformedURLException e) {
            Log.e((String)LOGTAG, (String)("Cannot interpret " + endpointUrl + " as a URL"), (Throwable)e);
            status = Status.FAILED_UNRECOVERABLE;
        }
        catch (IOException e) {
            if (MPConfig.DEBUG) {
                Log.d((String)LOGTAG, (String)"Cannot post message to Mixpanel Servers (ok, can retry.)", (Throwable)e);
            }
            status = Status.FAILED_RECOVERABLE;
        }
        catch (OutOfMemoryError e) {
            Log.e((String)LOGTAG, (String)"Cannot post message to Mixpanel Servers, will not retry.", (Throwable)e);
            status = Status.FAILED_UNRECOVERABLE;
        }
        if (null != response) {
            status = Status.SUCCEEDED;
        }
        return new Result(status, response);
    }

    private byte[] slurp(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public static class Result {
        private final byte[] mResponseBytes;
        private final Status mStatus;

        Result(Status status, byte[] responseBytes) {
            this.mStatus = status;
            this.mResponseBytes = responseBytes;
        }

        public Status getStatus() {
            return this.mStatus;
        }

        public byte[] getResponseBytes() {
            return this.mResponseBytes;
        }

        public String getResponse() {
            if (null == this.mResponseBytes) {
                return null;
            }
            try {
                return new String(this.mResponseBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("UTF not supported on this platform?", e);
            }
        }
    }

    public static enum Status {
        SUCCEEDED,
        FAILED_RECOVERABLE,
        FAILED_UNRECOVERABLE;

    }
}

