/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.mixpanel.android.mpmetrics.PersistentProperties;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstallReferrerReceiver
extends BroadcastReceiver {
    private final Pattern UTM_SOURCE_PATTERN = Pattern.compile("(^|&)utm_source=([^&#=]*)([#&]|$)");
    private final Pattern UTM_MEDIUM_PATTERN = Pattern.compile("(^|&)utm_medium=([^&#=]*)([#&]|$)");
    private final Pattern UTM_CAMPAIGN_PATTERN = Pattern.compile("(^|&)utm_campaign=([^&#=]*)([#&]|$)");
    private final Pattern UTM_CONTENT_PATTERN = Pattern.compile("(^|&)utm_content=([^&#=]*)([#&]|$)");
    private final Pattern UTM_TERM_PATTERN = Pattern.compile("(^|&)utm_term=([^&#=]*)([#&]|$)");
    private static final String LOGTAG = "Mixpanel InstallReferrer";

    public void onReceive(Context context, Intent intent) {
        Matcher termMatcher;
        String term;
        Matcher contentMatcher;
        String content;
        Matcher campaignMatcher;
        String campaign;
        Matcher mediumMatcher;
        String medium;
        Bundle extras = intent.getExtras();
        if (null == extras) {
            return;
        }
        String referrer = extras.getString("referrer");
        if (null == referrer) {
            return;
        }
        HashMap<String, String> newPrefs = new HashMap<String, String>();
        newPrefs.put("referrer", referrer);
        Matcher sourceMatcher = this.UTM_SOURCE_PATTERN.matcher(referrer);
        String source = this.find(sourceMatcher);
        if (null != source) {
            newPrefs.put("utm_source", source);
        }
        if (null != (medium = this.find(mediumMatcher = this.UTM_MEDIUM_PATTERN.matcher(referrer)))) {
            newPrefs.put("utm_medium", medium);
        }
        if (null != (campaign = this.find(campaignMatcher = this.UTM_CAMPAIGN_PATTERN.matcher(referrer)))) {
            newPrefs.put("utm_campaign", campaign);
        }
        if (null != (content = this.find(contentMatcher = this.UTM_CONTENT_PATTERN.matcher(referrer)))) {
            newPrefs.put("utm_content", content);
        }
        if (null != (term = this.find(termMatcher = this.UTM_TERM_PATTERN.matcher(referrer)))) {
            newPrefs.put("utm_term", term);
        }
        PersistentProperties.writeReferrerPrefs(context, "com.mixpanel.android.mpmetrics.ReferralInfo", newPrefs);
    }

    private String find(Matcher matcher) {
        String encoded;
        if (matcher.find() && null != (encoded = matcher.group(2))) {
            try {
                return URLDecoder.decode(encoded, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)LOGTAG, (String)"Could not decode a parameter into UTF-8");
            }
        }
        return null;
    }
}

