/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.os.AsyncTask;
import android.view.View;
import com.mixpanel.android.util.StackBlurManager;

class BackgroundCapture {
    private static final String LOGTAG = "MixpanelAPI BackgroundCapture";
    private static final int GRAY_72PERCENT_OPAQUE = Color.argb((int)186, (int)28, (int)28, (int)28);

    BackgroundCapture() {
    }

    public static void captureBackground(final Activity parentActivity, final OnBackgroundCapturedListener listener) {
        parentActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BackgroundCaptureTask task = new BackgroundCaptureTask(parentActivity, listener);
                task.execute(new Void[0]);
            }
        });
    }

    private static class BackgroundCaptureTask
    extends AsyncTask<Void, Void, Void> {
        private final OnBackgroundCapturedListener mListener;
        private final Activity mParentActivity;
        private Bitmap mSourceImage;
        private int mCalculatedHighlightColor;

        public BackgroundCaptureTask(Activity parentActivity, OnBackgroundCapturedListener listener) {
            this.mParentActivity = parentActivity;
            this.mListener = listener;
        }

        protected void onPreExecute() {
            View someView = this.mParentActivity.findViewById(0x1020002);
            View rootView = someView.getRootView();
            boolean originalCacheState = rootView.isDrawingCacheEnabled();
            rootView.setDrawingCacheEnabled(true);
            rootView.buildDrawingCache(true);
            Bitmap original = rootView.getDrawingCache();
            Bitmap scaled = null;
            if (null != original && original.getWidth() > 0 && original.getHeight() > 0) {
                int scaledWidth = original.getWidth() / 2;
                int scaledHeight = original.getHeight() / 2;
                if (scaledWidth > 0 && scaledHeight > 0) {
                    scaled = Bitmap.createScaledBitmap((Bitmap)original, (int)scaledWidth, (int)scaledHeight, (boolean)false);
                }
            }
            if (!originalCacheState) {
                rootView.setDrawingCacheEnabled(false);
            }
            this.mSourceImage = scaled;
        }

        protected Void doInBackground(Void ... params) {
            if (null == this.mSourceImage) {
                this.mCalculatedHighlightColor = -1;
                this.mSourceImage = null;
                return null;
            }
            try {
                long startTime = System.currentTimeMillis();
                Bitmap background1px = Bitmap.createScaledBitmap((Bitmap)this.mSourceImage, (int)1, (int)1, (boolean)true);
                this.mCalculatedHighlightColor = background1px.getPixel(0, 0);
                StackBlurManager.process(this.mSourceImage, 20);
                long endTime = System.currentTimeMillis();
                Canvas canvas = new Canvas(this.mSourceImage);
                canvas.drawColor(GRAY_72PERCENT_OPAQUE, PorterDuff.Mode.SRC_ATOP);
            }
            catch (OutOfMemoryError e) {
                this.mCalculatedHighlightColor = -1;
                this.mSourceImage = null;
            }
            return null;
        }

        protected void onPostExecute(Void _) {
            this.mListener.OnBackgroundCaptured(this.mSourceImage, this.mCalculatedHighlightColor);
        }
    }

    public static interface OnBackgroundCapturedListener {
        public void OnBackgroundCaptured(Bitmap var1, int var2);
    }
}

