/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.Survey;
import com.mixpanel.android.mpmetrics.SurveyCallbacks;

class MixpanelActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private final MixpanelAPI mMpInstance;
    private boolean mHasDoneFirstCheck = false;
    private Integer mCurOrientation;
    private final long timeoutMillis = 2000L;
    private static final String LOGTAG = "MixpanelAPI:MixpanelActivityLifecycleCallbacks";

    public MixpanelActivityLifecycleCallbacks(MixpanelAPI mpInstance) {
        this.mMpInstance = mpInstance;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        boolean dueToOrientationChange;
        Configuration config = activity.getResources().getConfiguration();
        boolean bl = dueToOrientationChange = this.mCurOrientation != null && config.orientation != this.mCurOrientation;
        if (!dueToOrientationChange && activity.isTaskRoot()) {
            Log.d((String)LOGTAG, (String)"checkForSureys called from onActivityCreated");
            this.checkForSurveys(activity);
        }
        this.mCurOrientation = config.orientation;
    }

    public void onActivityStarted(Activity activity) {
        if (!this.mHasDoneFirstCheck && activity.isTaskRoot()) {
            this.mCurOrientation = activity.getResources().getConfiguration().orientation;
            Log.d((String)LOGTAG, (String)"checkForSurveys called from onActivityCreated");
            this.checkForSurveys(activity);
        }
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    private void checkForSurveys(final Activity activity) {
        if (null == activity) {
            return;
        }
        final long startTime = System.currentTimeMillis();
        this.mHasDoneFirstCheck = true;
        this.mMpInstance.getPeople().checkForSurvey(new SurveyCallbacks(){

            @Override
            public void foundSurvey(final Survey survey) {
                long endTime = System.currentTimeMillis();
                long totalTime = endTime - startTime;
                if (null == survey) {
                    Log.d((String)MixpanelActivityLifecycleCallbacks.LOGTAG, (String)"No survey found, nothing to show the user.");
                } else if (totalTime <= 2000L) {
                    Log.d((String)MixpanelActivityLifecycleCallbacks.LOGTAG, (String)("found survey " + survey.getId() + ", calling showSurvey..."));
                    MixpanelActivityLifecycleCallbacks.this.mMpInstance.getPeople().showSurvey(survey, activity);
                } else {
                    final AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)activity);
                    alertBuilder.setTitle((CharSequence)"We'd love your feedback!");
                    alertBuilder.setMessage((CharSequence)"Mind taking a quick survey?");
                    alertBuilder.setPositiveButton((CharSequence)"Sure", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            MixpanelActivityLifecycleCallbacks.this.mMpInstance.getPeople().showSurvey(survey, activity);
                        }
                    });
                    alertBuilder.setNegativeButton((CharSequence)"No, Thanks", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            MixpanelActivityLifecycleCallbacks.this.mMpInstance.getPeople().append("$surveys", survey.getId());
                            MixpanelActivityLifecycleCallbacks.this.mMpInstance.getPeople().append("$collections", survey.getCollectionId());
                        }
                    });
                    activity.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            alertBuilder.show();
                        }
                    });
                }
            }
        }, activity);
    }
}

