/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MixpanelAPI;

public class GCMReceiver
extends BroadcastReceiver {
    String LOGTAG = "MPGCMReceiver";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("com.google.android.c2dm.intent.REGISTRATION".equals(action)) {
            this.handleRegistrationIntent(intent);
        } else if ("com.google.android.c2dm.intent.RECEIVE".equals(action)) {
            this.handleNotificationIntent(context, intent);
        }
    }

    private void handleRegistrationIntent(Intent intent) {
        final String registration = intent.getStringExtra("registration_id");
        if (intent.getStringExtra("error") != null) {
            Log.e((String)this.LOGTAG, (String)("Error when registering for GCM: " + intent.getStringExtra("error")));
        } else if (registration != null) {
            Log.d((String)this.LOGTAG, (String)("registering GCM ID: " + registration));
            MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

                @Override
                public void process(MixpanelAPI api) {
                    api.getPeople().setPushRegistrationId(registration);
                }
            });
        } else if (intent.getStringExtra("unregistered") != null) {
            Log.d((String)this.LOGTAG, (String)"unregistering from GCM");
            MixpanelAPI.allInstances(new MixpanelAPI.InstanceProcessor(){

                @Override
                public void process(MixpanelAPI api) {
                    api.getPeople().clearPushRegistrationId();
                }
            });
        }
    }

    private void handleNotificationIntent(Context context, Intent intent) {
        String message = intent.getExtras().getString("mp_message");
        if (message == null) {
            return;
        }
        Log.d((String)this.LOGTAG, (String)("MP GCM notification received: " + message));
        PackageManager manager = context.getPackageManager();
        Intent appIntent = manager.getLaunchIntentForPackage(context.getPackageName());
        CharSequence notificationTitle = "";
        int notificationIcon = 17301651;
        try {
            ApplicationInfo appInfo = manager.getApplicationInfo(context.getPackageName(), 0);
            notificationTitle = manager.getApplicationLabel(appInfo);
            notificationIcon = appInfo.icon;
        }
        catch (PackageManager.NameNotFoundException e) {
            // empty catch block
        }
        PendingIntent contentIntent = PendingIntent.getActivity((Context)context.getApplicationContext(), (int)0, (Intent)appIntent, (int)0x8000000);
        NotificationManager nm = (NotificationManager)context.getSystemService("notification");
        Notification n = new Notification.Builder(context).setSmallIcon(notificationIcon).setTicker((CharSequence)message).setWhen(System.currentTimeMillis()).setContentTitle(notificationTitle).setContentIntent(contentIntent).build();
        n.flags |= 0x10;
        nm.notify(0, n);
    }
}

