/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.http.request;

import com.mistyrain.http.callback.Callback;
import com.mistyrain.http.request.OKHttpRequest;
import com.mistyrain.http.utils.OkHttpUtils;
import com.mistyrain.okhttp.Call;
import com.mistyrain.okhttp.OkHttpClient;
import com.mistyrain.okhttp.Request;
import com.mistyrain.okhttp.Response;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class RequestCall {
    private OKHttpRequest okHttpRequest;
    private Request request;
    private Call call;
    private long readTimeOut;
    private long writeTimeOut;
    private long connTimeOut;
    private OkHttpClient clone;

    public RequestCall(OKHttpRequest request) {
        this.okHttpRequest = request;
    }

    public RequestCall readTimeOut(long readTimeOut) {
        this.readTimeOut = readTimeOut;
        return this;
    }

    public RequestCall writeTimeOut(long writeTimeOut) {
        this.writeTimeOut = writeTimeOut;
        return this;
    }

    public RequestCall connTimeOut(long connTimeOut) {
        this.connTimeOut = connTimeOut;
        return this;
    }

    public Call generateCall(Callback callback) {
        this.request = this.generateRequest(callback);
        if (this.readTimeOut > 0L || this.writeTimeOut > 0L || this.connTimeOut > 0L) {
            this.readTimeOut = this.readTimeOut > 0L ? this.readTimeOut : 10000L;
            this.writeTimeOut = this.writeTimeOut > 0L ? this.writeTimeOut : 10000L;
            this.connTimeOut = this.connTimeOut > 0L ? this.connTimeOut : 10000L;
            this.clone = OkHttpUtils.getInstance().getOkHttpClient().newBuilder().readTimeout(this.readTimeOut, TimeUnit.MILLISECONDS).writeTimeout(this.writeTimeOut, TimeUnit.MILLISECONDS).connectTimeout(this.connTimeOut, TimeUnit.MILLISECONDS).build();
            this.call = this.clone.newCall(this.request);
        } else {
            this.call = OkHttpUtils.getInstance().getOkHttpClient().newCall(this.request);
        }
        return this.call;
    }

    private Request generateRequest(Callback callback) {
        return this.okHttpRequest.generateRequest(callback);
    }

    public void execute(Callback callback) {
        this.generateCall(callback);
        if (callback != null) {
            callback.onBefore(this.request);
        }
        OkHttpUtils.getInstance().execute(this, callback);
    }

    public Call getCall() {
        return this.call;
    }

    public Request getRequest() {
        return this.request;
    }

    public OKHttpRequest getOkHttpRequest() {
        return this.okHttpRequest;
    }

    public Response execute() throws IOException {
        this.generateCall(null);
        return this.call.execute();
    }

    public void cancel() {
        if (this.call != null) {
            this.call.cancel();
        }
    }
}

