/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.http.request;

import com.mistyrain.http.request.OKHttpRequest;
import com.mistyrain.http.utils.Exceptions;
import com.mistyrain.okhttp.MediaType;
import com.mistyrain.okhttp.Request;
import com.mistyrain.okhttp.RequestBody;
import java.util.Map;

public class OKHttpPostStringRequest
extends OKHttpRequest {
    private static MediaType MEDIA_TYPE_PLAIN = MediaType.parse((String)"text/plain;charset=utf-8");
    private String content;
    private MediaType mediaType;

    public OKHttpPostStringRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, String content, MediaType mediaType) {
        super(url, tag, params, headers);
        this.content = content;
        this.mediaType = mediaType;
        if (this.content == null) {
            Exceptions.illegalArgument("the content can not be null !");
        }
        if (this.mediaType == null) {
            this.mediaType = MEDIA_TYPE_PLAIN;
        }
    }

    @Override
    protected RequestBody buildRequestBody() {
        return RequestBody.create((MediaType)this.mediaType, (String)this.content);
    }

    @Override
    protected Request buildRequest(Request.Builder builder, RequestBody requestBody) {
        return builder.post(requestBody).build();
    }

    @Override
    public String toString() {
        return super.toString() + ", requestBody{content=" + this.content + "} ";
    }
}

