/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.http.request;

import com.mistyrain.http.request.OKHttpRequest;
import com.mistyrain.http.utils.Exceptions;
import com.mistyrain.okhttp.MediaType;
import com.mistyrain.okhttp.Request;
import com.mistyrain.okhttp.RequestBody;
import java.io.File;
import java.util.Map;

public class OKHttpFileRequest
extends OKHttpRequest {
    private static MediaType MEDIA_TYPE_STREAM = MediaType.parse((String)"application/octet-stream");
    private File file;
    private MediaType mediaType;

    public OKHttpFileRequest(String url, Object tag, Map<String, String> params, Map<String, String> headers, File file, MediaType mediaType) {
        super(url, tag, params, headers);
        this.file = file;
        this.mediaType = mediaType;
        if (this.file == null) {
            Exceptions.illegalArgument("the file can not be null !");
        }
        if (this.mediaType == null) {
            this.mediaType = MEDIA_TYPE_STREAM;
        }
    }

    @Override
    protected RequestBody buildRequestBody() {
        return RequestBody.create((MediaType)this.mediaType, (File)this.file);
    }

    @Override
    protected Request buildRequest(Request.Builder builder, RequestBody requestBody) {
        return builder.post(requestBody).build();
    }

    @Override
    public String toString() {
        return super.toString() + ", requestBody{uploadfilePath=" + this.file.getAbsolutePath() + "} ";
    }
}

