/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.http.body;

import com.mistyrain.okhttp.MediaType;
import com.mistyrain.okhttp.RequestBody;
import com.mistyrain.okhttp.okio.Buffer;
import com.mistyrain.okhttp.okio.BufferedSink;
import com.mistyrain.okhttp.okio.ForwardingSink;
import com.mistyrain.okhttp.okio.Okio;
import com.mistyrain.okhttp.okio.Sink;
import java.io.IOException;

public class CountingRequestBody
extends RequestBody {
    protected RequestBody delegate;
    protected Listener listener;
    protected CountingSink countingSink;

    public CountingRequestBody(RequestBody delegate, Listener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public MediaType contentType() {
        return this.delegate.contentType();
    }

    public long contentLength() {
        try {
            return this.delegate.contentLength();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.countingSink = new CountingSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)this.countingSink);
        this.delegate.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    public static interface Listener {
        public void onRequestProgress(long var1, long var3);
    }

    protected final class CountingSink
    extends ForwardingSink {
        private long bytesWritten;

        public CountingSink(Sink delegate) {
            super(delegate);
            this.bytesWritten = 0L;
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            this.bytesWritten += byteCount;
            CountingRequestBody.this.listener.onRequestProgress(this.bytesWritten, CountingRequestBody.this.contentLength());
        }
    }
}

