/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.http;

import com.mistyrain.http.builder.OKHttpGetBuilder;
import com.mistyrain.http.builder.OKHttpPostBuilder;
import com.mistyrain.http.builder.OKHttpPostFormBuilder;
import com.mistyrain.http.builder.OKHttpPostStringBuilder;
import com.mistyrain.http.callback.BitmapCallback;
import com.mistyrain.http.callback.Callback;
import com.mistyrain.http.callback.FileCallback;
import com.mistyrain.http.config.FileInput;
import com.mistyrain.http.config.HttpMethod;
import com.mistyrain.http.utils.OkHttpUtils;
import com.mistyrain.okhttp.OkHttpClient;
import com.mistyrain.okhttp.Request;
import com.mistyrain.okhttp.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpUtility {
    private static HttpUtility httpUtility;

    private HttpUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtility getInstance() {
        if (httpUtility != null) return httpUtility;
        Class<HttpUtility> clazz = HttpUtility.class;
        synchronized (HttpUtility.class) {
            if (httpUtility != null) return httpUtility;
            httpUtility = new HttpUtility();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpUtility;
        }
    }

    public void execute(HttpMethod httpMethod, String url, Map<String, String> param, Callback callback) throws Exception {
        switch (httpMethod) {
            case POST: {
                ((OKHttpPostBuilder)OkHttpUtils.getInstance().post().url(url).params((Map)param)).build().execute(callback);
                break;
            }
            case GET: {
                ((OKHttpGetBuilder)OkHttpUtils.getInstance().get().url(url).params((Map)param)).build().execute(callback);
                break;
            }
            case POSTSTRING: {
                ((OKHttpPostStringBuilder)OkHttpUtils.getInstance().postString().url(url).params((Map)param)).build().execute(callback);
            }
        }
    }

    public void execute(String url, Map<String, String> param, List<FileInput> files, Callback callback) throws Exception {
        HashMap headers = new HashMap();
        ((OKHttpPostFormBuilder)((OKHttpPostFormBuilder)OkHttpUtils.getInstance().postFrom().addFile(files).url(url).params((Map)param)).headers((Map)headers)).build().execute(callback);
    }

    public void executeDisplayImage(String urlAddress, Object tag, BitmapCallback callback) throws Exception {
        OkHttpUtils.getInstance().get().url(urlAddress).tag(tag).build().connTimeOut(20000L).readTimeOut(20000L).writeTimeOut(20000L).execute(callback);
    }

    public void executeUpLoadFile(String urlAddress, Map<String, String> params, List<FileInput> file, Callback callback) throws Exception {
        ((OKHttpPostBuilder)OkHttpUtils.getInstance().post().addFile(file).url(urlAddress).params((Map)params)).build().execute(callback);
    }

    public void executeDownloadFile(String urlAddress, FileCallback callback) {
        OkHttpUtils.getInstance().get().url(urlAddress).build().execute(callback);
    }

    public Response syncRequest(HttpMethod httpMethod, String url, Map<String, String> param, Callback callback) throws Exception {
        switch (httpMethod) {
            case GET: {
                OkHttpClient client = new OkHttpClient();
                Request request = new Request.Builder().url("http://publicobject.com/helloworld.txt").build();
                Response response = client.newCall(request).execute();
                return response;
            }
        }
        return null;
    }
}

