/*
 * Decompiled with CFR 0.152.
 */
package com.mistyrain.logger;

import com.mistyrain.logger.Helper;
import com.mistyrain.logger.LogLevel;
import com.mistyrain.logger.Logger;
import com.mistyrain.logger.Printer;
import com.mistyrain.logger.Settings;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class LoggerPrinter
implements Printer {
    private static final String DEFAULT_TAG = "FRIENDTIMESLOGGER";
    private static final int DEBUG = 3;
    private static final int ERROR = 6;
    private static final int ASSERT = 7;
    private static final int INFO = 4;
    private static final int VERBOSE = 2;
    private static final int WARN = 5;
    private static final int CHUNK_SIZE = 4000;
    private static final int JSON_INDENT = 2;
    private static final int MIN_STACK_OFFSET = 3;
    private static final char TOP_LEFT_CORNER = '\u2554';
    private static final char BOTTOM_LEFT_CORNER = '\u255a';
    private static final char MIDDLE_CORNER = '\u255f';
    private static final char HORIZONTAL_DOUBLE_LINE = '\u2551';
    private static final String DOUBLE_DIVIDER = "\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String SINGLE_DIVIDER = "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private static final String TOP_BORDER = "\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String BOTTOM_BORDER = "\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550";
    private static final String MIDDLE_BORDER = "\u255f\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500";
    private String tag;
    private final ThreadLocal<String> localTag = new ThreadLocal();
    private final ThreadLocal<Integer> localMethodCount = new ThreadLocal();
    private final Settings settings = new Settings();

    public LoggerPrinter() {
        this.init(DEFAULT_TAG);
    }

    @Override
    public Settings init(String tag) {
        if (tag == null) {
            throw new NullPointerException("tag may not be null");
        }
        if (tag.trim().length() == 0) {
            throw new IllegalStateException("tag may not be empty");
        }
        this.tag = tag;
        return this.settings;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    public Printer t(String tag, int methodCount) {
        if (tag != null) {
            this.localTag.set(tag);
        }
        this.localMethodCount.set(methodCount);
        return this;
    }

    @Override
    public void d(String message, Object ... args) {
        this.log(3, null, message, args);
    }

    @Override
    public void d(Object object) {
        String message = object.getClass().isArray() ? Arrays.deepToString((Object[])object) : object.toString();
        this.log(3, null, message, new Object[0]);
    }

    @Override
    public void e(String message, Object ... args) {
        this.e(null, message, args);
    }

    @Override
    public void e(Throwable throwable, String message, Object ... args) {
        this.log(6, throwable, message, args);
    }

    @Override
    public void w(String message, Object ... args) {
        this.log(5, null, message, args);
    }

    @Override
    public void i(String message, Object ... args) {
        this.log(4, null, message, args);
    }

    @Override
    public void v(String message, Object ... args) {
        this.log(2, null, message, args);
    }

    @Override
    public void wtf(String message, Object ... args) {
        this.log(7, null, message, args);
    }

    @Override
    public void json(String json) {
        if (Helper.isEmpty(json)) {
            this.d("Empty/Null json content");
            return;
        }
        try {
            json = json.trim();
            if (json.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(json);
                String message = jsonObject.toString(2);
                this.d(message);
                return;
            }
            if (json.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(json);
                String message = jsonArray.toString(2);
                this.d(message);
                return;
            }
            this.e("Invalid Json", new Object[0]);
        }
        catch (JSONException e) {
            this.e("Invalid Json", new Object[0]);
        }
    }

    @Override
    public void xml(String xml) {
        if (Helper.isEmpty(xml)) {
            this.d("Empty/Null xml content");
            return;
        }
        try {
            StreamSource xmlInput = new StreamSource(new StringReader(xml));
            StreamResult xmlOutput = new StreamResult(new StringWriter());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(xmlInput, xmlOutput);
            this.d(xmlOutput.getWriter().toString().replaceFirst(">", ">\n"));
        }
        catch (TransformerException e) {
            this.e("Invalid xml", new Object[0]);
        }
    }

    @Override
    public synchronized void log(int priority, String tag, String message, Throwable throwable) {
        if (this.settings.getLogLevel() == LogLevel.NONE) {
            return;
        }
        if (throwable != null && message != null) {
            message = message + " : " + Helper.getStackTraceString(throwable);
        }
        if (throwable != null && message == null) {
            message = Helper.getStackTraceString(throwable);
        }
        if (message == null) {
            message = "No message/exception is set";
        }
        int methodCount = this.getMethodCount();
        if (Helper.isEmpty(message)) {
            message = "Empty/NULL log message";
        }
        this.logTopBorder(priority, tag);
        this.logHeaderContent(priority, tag, methodCount);
        byte[] bytes = message.getBytes();
        int length = bytes.length;
        if (length <= 4000) {
            if (methodCount > 0) {
                this.logDivider(priority, tag);
            }
            this.logContent(priority, tag, message);
            this.logBottomBorder(priority, tag);
            return;
        }
        if (methodCount > 0) {
            this.logDivider(priority, tag);
        }
        for (int i = 0; i < length; i += 4000) {
            int count = Math.min(length - i, 4000);
            this.logContent(priority, tag, new String(bytes, i, count));
        }
        this.logBottomBorder(priority, tag);
    }

    @Override
    public void resetSettings() {
        this.settings.reset();
    }

    private synchronized void log(int priority, Throwable throwable, String msg, Object ... args) {
        if (this.settings.getLogLevel() == LogLevel.NONE) {
            return;
        }
        String tag = this.getTag();
        String message = this.createMessage(msg, args);
        this.log(priority, tag, message, throwable);
    }

    private void logTopBorder(int logType, String tag) {
        this.logChunk(logType, tag, TOP_BORDER);
    }

    private void logHeaderContent(int logType, String tag, int methodCount) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (this.settings.isShowThreadInfo()) {
            this.logChunk(logType, tag, "\u2551 Thread: " + Thread.currentThread().getName());
            this.logDivider(logType, tag);
        }
        String level = "";
        int stackOffset = this.getStackOffset(trace) + this.settings.getMethodOffset();
        if (methodCount + stackOffset > trace.length) {
            methodCount = trace.length - stackOffset - 1;
        }
        for (int i = methodCount; i > 0; --i) {
            int stackIndex = i + stackOffset;
            if (stackIndex >= trace.length) continue;
            StringBuilder builder = new StringBuilder();
            builder.append("\u2551 ").append(level).append(this.getSimpleClassName(trace[stackIndex].getClassName())).append(".").append(trace[stackIndex].getMethodName()).append(" ").append(" (").append(trace[stackIndex].getFileName()).append(":").append(trace[stackIndex].getLineNumber()).append(")");
            level = level + "   ";
            this.logChunk(logType, tag, builder.toString());
        }
    }

    private void logBottomBorder(int logType, String tag) {
        this.logChunk(logType, tag, BOTTOM_BORDER);
    }

    private void logDivider(int logType, String tag) {
        this.logChunk(logType, tag, MIDDLE_BORDER);
    }

    private void logContent(int logType, String tag, String chunk) {
        String[] lines;
        for (String line : lines = chunk.split(System.getProperty("line.separator"))) {
            this.logChunk(logType, tag, "\u2551 " + line);
        }
    }

    private void logChunk(int logType, String tag, String chunk) {
        String finalTag = this.formatTag(tag);
        switch (logType) {
            case 6: {
                this.settings.getLogAdapter().e(finalTag, chunk);
                break;
            }
            case 4: {
                this.settings.getLogAdapter().i(finalTag, chunk);
                break;
            }
            case 2: {
                this.settings.getLogAdapter().v(finalTag, chunk);
                break;
            }
            case 5: {
                this.settings.getLogAdapter().w(finalTag, chunk);
                break;
            }
            case 7: {
                this.settings.getLogAdapter().wtf(finalTag, chunk);
                break;
            }
            default: {
                this.settings.getLogAdapter().d(finalTag, chunk);
            }
        }
    }

    private String getSimpleClassName(String name) {
        int lastIndex = name.lastIndexOf(".");
        return name.substring(lastIndex + 1);
    }

    private String formatTag(String tag) {
        if (!Helper.isEmpty(tag) && !Helper.equals(this.tag, tag)) {
            return this.tag + "-" + tag;
        }
        return this.tag;
    }

    private String getTag() {
        String tag = this.localTag.get();
        if (tag != null) {
            this.localTag.remove();
            return tag;
        }
        return this.tag;
    }

    private String createMessage(String message, Object ... args) {
        return args == null || args.length == 0 ? message : String.format(message, args);
    }

    private int getMethodCount() {
        Integer count = this.localMethodCount.get();
        int result = this.settings.getMethodCount();
        if (count != null) {
            this.localMethodCount.remove();
            result = count;
        }
        if (result < 0) {
            throw new IllegalStateException("methodCount cannot be negative");
        }
        return result;
    }

    private int getStackOffset(StackTraceElement[] trace) {
        for (int i = 3; i < trace.length; ++i) {
            StackTraceElement e = trace[i];
            String name = e.getClassName();
            if (name.equals(LoggerPrinter.class.getName()) || name.equals(Logger.class.getName())) continue;
            return --i;
        }
        return -1;
    }
}

