package com.mistyrain.http.callback;

import com.mistyrain.okhttp.Call;
import com.mistyrain.okhttp.Request;
import com.mistyrain.okhttp.Response;

/**
 * Created by wutao on 2016/2/1.
 * okhttp 返回结果抽象基类 ，目前回调的主要分为三种 string、file、bitmap
 */
public abstract class Callback<T> {
    /**
     * UI Thread
     *
     * @param request
     */
    public void onBefore(Request request) {
    }

    /**
     * UI Thread
     *
     * @param
     */
    public void onAfter() {
    }

    /**
     * UI Thread
     *
     * @param progress
     */
    public void inProgress(float progress) {

    }

    /**
     * Thread Pool Thread
     *
     * @param response
     */
    public abstract T parseNetworkResponse(Response response) throws Exception;

    public abstract void onError(Call call, Exception e);

    public abstract void onError(Call call,Response response, Exception e);

    public abstract void onResponse(T response);


    public static Callback CALLBACK_DEFAULT = new Callback() {

        @Override
        public Object parseNetworkResponse(Response response) throws Exception {
            return null;
        }

        @Override
        public void onError(Call call, Exception e) {

        }

        @Override
        public void onError(Call call,Response response, Exception e) {

        }
        @Override
        public void onResponse(Object response) {

        }
    };

}
