/*
 * Decompiled with CFR 0.152.
 */
package com.downloader.request;

import com.downloader.Error;
import com.downloader.OnCancelListener;
import com.downloader.OnDownloadListener;
import com.downloader.OnPauseListener;
import com.downloader.OnProgressListener;
import com.downloader.OnStartOrResumeListener;
import com.downloader.Priority;
import com.downloader.Response;
import com.downloader.Status;
import com.downloader.core.Core;
import com.downloader.internal.ComponentHolder;
import com.downloader.internal.DownloadRequestQueue;
import com.downloader.internal.SynchronousCall;
import com.downloader.request.DownloadRequestBuilder;
import com.downloader.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Future;

public class DownloadRequest {
    private Priority priority;
    private Object tag;
    private String url;
    private String dirPath;
    private String fileName;
    private int sequenceNumber;
    private Future future;
    private long downloadedBytes;
    private long totalBytes;
    private int readTimeout;
    private int connectTimeout;
    private String userAgent;
    private OnProgressListener onProgressListener;
    private OnDownloadListener onDownloadListener;
    private OnStartOrResumeListener onStartOrResumeListener;
    private OnPauseListener onPauseListener;
    private OnCancelListener onCancelListener;
    private int downloadId;
    private HashMap<String, List<String>> headerMap;
    private Status status;

    DownloadRequest(DownloadRequestBuilder builder) {
        this.url = builder.url;
        this.dirPath = builder.dirPath;
        this.fileName = builder.fileName;
        this.headerMap = builder.headerMap;
        this.priority = builder.priority;
        this.tag = builder.tag;
        this.readTimeout = builder.readTimeout != 0 ? builder.readTimeout : this.getReadTimeoutFromConfig();
        this.connectTimeout = builder.connectTimeout != 0 ? builder.connectTimeout : this.getConnectTimeoutFromConfig();
        this.userAgent = builder.userAgent;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void setDirPath(String dirPath) {
        this.dirPath = dirPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public HashMap<String, List<String>> getHeaders() {
        return this.headerMap;
    }

    public Future getFuture() {
        return this.future;
    }

    public void setFuture(Future future) {
        this.future = future;
    }

    public long getDownloadedBytes() {
        return this.downloadedBytes;
    }

    public void setDownloadedBytes(long downloadedBytes) {
        this.downloadedBytes = downloadedBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public void setTotalBytes(long totalBytes) {
        this.totalBytes = totalBytes;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getUserAgent() {
        if (this.userAgent == null) {
            this.userAgent = ComponentHolder.getInstance().getUserAgent();
        }
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public int getDownloadId() {
        return this.downloadId;
    }

    public void setDownloadId(int downloadId) {
        this.downloadId = downloadId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public OnProgressListener getOnProgressListener() {
        return this.onProgressListener;
    }

    public DownloadRequest setOnStartOrResumeListener(OnStartOrResumeListener onStartOrResumeListener) {
        this.onStartOrResumeListener = onStartOrResumeListener;
        return this;
    }

    public DownloadRequest setOnProgressListener(OnProgressListener onProgressListener) {
        this.onProgressListener = onProgressListener;
        return this;
    }

    public DownloadRequest setOnPauseListener(OnPauseListener onPauseListener) {
        this.onPauseListener = onPauseListener;
        return this;
    }

    public DownloadRequest setOnCancelListener(OnCancelListener onCancelListener) {
        this.onCancelListener = onCancelListener;
        return this;
    }

    public int start(OnDownloadListener onDownloadListener) {
        this.onDownloadListener = onDownloadListener;
        this.downloadId = Utils.getUniqueId(this.url, this.dirPath, this.fileName);
        DownloadRequestQueue.getInstance().addRequest(this);
        return this.downloadId;
    }

    public Response executeSync() {
        this.downloadId = Utils.getUniqueId(this.url, this.dirPath, this.fileName);
        return new SynchronousCall(this).execute();
    }

    public void deliverError(final Error error) {
        if (this.status != Status.CANCELLED) {
            Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                @Override
                public void run() {
                    if (DownloadRequest.this.onDownloadListener != null) {
                        DownloadRequest.this.onDownloadListener.onError(error);
                    }
                    DownloadRequest.this.finish();
                }
            });
        }
    }

    public void deliverSuccess() {
        if (this.status != Status.CANCELLED) {
            this.setStatus(Status.COMPLETED);
            Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                @Override
                public void run() {
                    if (DownloadRequest.this.onDownloadListener != null) {
                        DownloadRequest.this.onDownloadListener.onDownloadComplete();
                    }
                    DownloadRequest.this.finish();
                }
            });
        }
    }

    public void deliverStartEvent() {
        if (this.status != Status.CANCELLED) {
            Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                @Override
                public void run() {
                    if (DownloadRequest.this.onStartOrResumeListener != null) {
                        DownloadRequest.this.onStartOrResumeListener.onStartOrResume();
                    }
                }
            });
        }
    }

    public void deliverPauseEvent() {
        if (this.status != Status.CANCELLED) {
            Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

                @Override
                public void run() {
                    if (DownloadRequest.this.onPauseListener != null) {
                        DownloadRequest.this.onPauseListener.onPause();
                    }
                }
            });
        }
    }

    private void deliverCancelEvent() {
        Core.getInstance().getExecutorSupplier().forMainThreadTasks().execute(new Runnable(){

            @Override
            public void run() {
                if (DownloadRequest.this.onCancelListener != null) {
                    DownloadRequest.this.onCancelListener.onCancel();
                }
            }
        });
    }

    public void cancel() {
        this.status = Status.CANCELLED;
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.deliverCancelEvent();
        Utils.deleteTempFileAndDatabaseEntryInBackground(Utils.getTempPath(this.dirPath, this.fileName), this.downloadId);
    }

    private void finish() {
        this.destroy();
        DownloadRequestQueue.getInstance().finish(this);
    }

    private void destroy() {
        this.onProgressListener = null;
        this.onDownloadListener = null;
        this.onStartOrResumeListener = null;
        this.onPauseListener = null;
        this.onCancelListener = null;
    }

    private int getReadTimeoutFromConfig() {
        return ComponentHolder.getInstance().getReadTimeout();
    }

    private int getConnectTimeoutFromConfig() {
        return ComponentHolder.getInstance().getConnectTimeout();
    }
}

