/*
 * Decompiled with CFR 0.152.
 */
package com.downloader.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.downloader.database.DatabaseOpenHelper;
import com.downloader.database.DbHelper;
import com.downloader.database.DownloadModel;
import java.util.ArrayList;
import java.util.List;

public class AppDbHelper
implements DbHelper {
    public static final String TABLE_NAME = "prdownloader";
    private final SQLiteDatabase db;

    public AppDbHelper(Context context) {
        DatabaseOpenHelper databaseOpenHelper = new DatabaseOpenHelper(context);
        this.db = databaseOpenHelper.getWritableDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadModel find(int id) {
        DownloadModel model = null;
        try (Cursor cursor = null;){
            cursor = this.db.rawQuery("SELECT * FROM prdownloader WHERE id = " + id, null);
            if (cursor != null && cursor.moveToFirst()) {
                model = new DownloadModel();
                model.setId(id);
                model.setUrl(cursor.getString(cursor.getColumnIndex("url")));
                model.setETag(cursor.getString(cursor.getColumnIndex("etag")));
                model.setDirPath(cursor.getString(cursor.getColumnIndex("dir_path")));
                model.setFileName(cursor.getString(cursor.getColumnIndex("file_name")));
                model.setTotalBytes(cursor.getLong(cursor.getColumnIndex("total_bytes")));
                model.setDownloadedBytes(cursor.getLong(cursor.getColumnIndex("downloaded_bytes")));
                model.setLastModifiedAt(cursor.getLong(cursor.getColumnIndex("last_modified_at")));
            }
        }
        return model;
    }

    @Override
    public void insert(DownloadModel model) {
        try {
            ContentValues values = new ContentValues();
            values.put("id", Integer.valueOf(model.getId()));
            values.put("url", model.getUrl());
            values.put("etag", model.getETag());
            values.put("dir_path", model.getDirPath());
            values.put("file_name", model.getFileName());
            values.put("total_bytes", Long.valueOf(model.getTotalBytes()));
            values.put("downloaded_bytes", Long.valueOf(model.getDownloadedBytes()));
            values.put("last_modified_at", Long.valueOf(model.getLastModifiedAt()));
            this.db.insert(TABLE_NAME, null, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update(DownloadModel model) {
        try {
            ContentValues values = new ContentValues();
            values.put("url", model.getUrl());
            values.put("etag", model.getETag());
            values.put("dir_path", model.getDirPath());
            values.put("file_name", model.getFileName());
            values.put("total_bytes", Long.valueOf(model.getTotalBytes()));
            values.put("downloaded_bytes", Long.valueOf(model.getDownloadedBytes()));
            values.put("last_modified_at", Long.valueOf(model.getLastModifiedAt()));
            this.db.update(TABLE_NAME, values, "id = ? ", new String[]{String.valueOf(model.getId())});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateProgress(int id, long downloadedBytes, long lastModifiedAt) {
        try {
            ContentValues values = new ContentValues();
            values.put("downloaded_bytes", Long.valueOf(downloadedBytes));
            values.put("last_modified_at", Long.valueOf(lastModifiedAt));
            this.db.update(TABLE_NAME, values, "id = ? ", new String[]{String.valueOf(id)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void remove(int id) {
        try {
            this.db.execSQL("DELETE FROM prdownloader WHERE id = " + id);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadModel> getUnwantedModels(int days) {
        ArrayList<DownloadModel> models = new ArrayList<DownloadModel>();
        try (Cursor cursor = null;){
            long daysInMillis = (long)(days * 24 * 60 * 60) * 1000L;
            long beforeTimeInMillis = System.currentTimeMillis() - daysInMillis;
            cursor = this.db.rawQuery("SELECT * FROM prdownloader WHERE last_modified_at <= " + beforeTimeInMillis, null);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    DownloadModel model = new DownloadModel();
                    model.setId(cursor.getInt(cursor.getColumnIndex("id")));
                    model.setUrl(cursor.getString(cursor.getColumnIndex("url")));
                    model.setETag(cursor.getString(cursor.getColumnIndex("etag")));
                    model.setDirPath(cursor.getString(cursor.getColumnIndex("dir_path")));
                    model.setFileName(cursor.getString(cursor.getColumnIndex("file_name")));
                    model.setTotalBytes(cursor.getLong(cursor.getColumnIndex("total_bytes")));
                    model.setDownloadedBytes(cursor.getLong(cursor.getColumnIndex("downloaded_bytes")));
                    model.setLastModifiedAt(cursor.getLong(cursor.getColumnIndex("last_modified_at")));
                    models.add(model);
                } while (cursor.moveToNext());
            }
        }
        return models;
    }

    @Override
    public void clear() {
        try {
            this.db.delete(TABLE_NAME, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

