/*
 * Decompiled with CFR 0.152.
 */
package com.downloader.httpclient;

import com.downloader.httpclient.HttpClient;
import com.downloader.request.DownloadRequest;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DefaultHttpClient
implements HttpClient {
    private URLConnection connection;

    @Override
    public HttpClient clone() {
        return new DefaultHttpClient();
    }

    @Override
    public void connect(DownloadRequest request) throws IOException {
        this.connection = new URL(request.getUrl()).openConnection();
        this.connection.setReadTimeout(request.getReadTimeout());
        this.connection.setConnectTimeout(request.getConnectTimeout());
        String range = String.format(Locale.ENGLISH, "bytes=%d-", request.getDownloadedBytes());
        this.connection.addRequestProperty("Range", range);
        this.connection.addRequestProperty("User-Agent", request.getUserAgent());
        this.addHeaders(request);
        this.connection.connect();
    }

    @Override
    public int getResponseCode() throws IOException {
        int responseCode = 0;
        if (this.connection instanceof HttpURLConnection) {
            responseCode = ((HttpURLConnection)this.connection).getResponseCode();
        }
        return responseCode;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.connection.getInputStream();
    }

    @Override
    public long getContentLength() {
        String length = this.connection.getHeaderField("Content-Length");
        try {
            return Long.parseLong(length);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    @Override
    public String getResponseHeader(String name) {
        return this.connection.getHeaderField(name);
    }

    @Override
    public void close() {
    }

    private void addHeaders(DownloadRequest request) {
        HashMap<String, List<String>> headers = request.getHeaders();
        if (headers != null) {
            Set<Map.Entry<String, List<String>>> entries = headers.entrySet();
            for (Map.Entry<String, List<String>> entry : entries) {
                String name = entry.getKey();
                List<String> list = entry.getValue();
                if (list == null) continue;
                for (String value : list) {
                    this.connection.addRequestProperty(name, value);
                }
            }
        }
    }
}

