/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.view.View;
import com.mindorks.placeholderview.AnimationResolver;

public abstract class ViewBinder<T, V extends View> {
    private int mLayoutId;
    private int mPosition;
    private T mResolver;
    private AnimationResolver<T, V> mAnimationResolver;
    private boolean mNullable = false;

    protected ViewBinder(T resolver, int layoutId, boolean nullable) {
        this.mResolver = resolver;
        this.mLayoutId = layoutId;
        this.mNullable = nullable;
        this.mAnimationResolver = new AnimationResolver();
    }

    protected void bindView(V itemView, int position) {
        this.bindViews(this.mResolver, itemView);
        this.bindViewPosition(this.mResolver, position);
        this.bindClick(this.mResolver, itemView);
        this.bindLongClick(this.mResolver, itemView);
        this.resolveView(this.mResolver);
    }

    protected void bindAnimation(int deviceWidth, int deviceHeight, V view) {
        this.mAnimationResolver.bindAnimation(deviceWidth, deviceHeight, this.mResolver, view);
    }

    protected abstract void bindViews(T var1, V var2);

    protected abstract void bindViewPosition(T var1, int var2);

    protected abstract void resolveView(T var1);

    protected abstract void bindClick(T var1, V var2);

    protected abstract void bindLongClick(T var1, V var2);

    protected abstract void recycleView();

    protected abstract void unbind();

    protected int getLayoutId() {
        return this.mLayoutId;
    }

    protected T getResolver() {
        return this.mResolver;
    }

    public void setResolver(T resolver) {
        this.mResolver = resolver;
    }

    protected int getPosition() {
        return this.mPosition;
    }

    protected AnimationResolver getAnimationResolver() {
        return this.mAnimationResolver;
    }

    public void setAnimationResolver(AnimationResolver<T, V> animationResolver) {
        this.mAnimationResolver = animationResolver;
    }

    protected boolean isNullable() {
        return this.mNullable;
    }
}

