/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.mindorks.placeholderview.Binding;
import com.mindorks.placeholderview.SwipeDecor;
import com.mindorks.placeholderview.SwipeViewBinder;
import com.mindorks.placeholderview.SwipeViewBuilder;
import com.mindorks.placeholderview.ViewBinder;
import com.mindorks.placeholderview.listeners.ItemRemovedListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class SwipePlaceHolderView
extends FrameLayout
implements SwipeViewBinder.SwipeCallback<SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor>> {
    public static final int DEFAULT_DISPLAY_VIEW_COUNT = 20;
    public static final int SWIPE_TYPE_DEFAULT = 1;
    public static final int SWIPE_TYPE_HORIZONTAL = 2;
    public static final int SWIPE_TYPE_VERTICAL = 3;
    private SwipeOption mSwipeOption;
    private SwipeViewBuilder<SwipePlaceHolderView> mSwipeViewBuilder;
    private LayoutInflater mLayoutInflater;
    private int mDisplayViewCount = 20;
    private int mSwipeType = 1;
    private boolean mIsReverse = false;
    private SwipeDecor mSwipeDecor;
    private List<SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor>> mSwipeViewBinderList;
    private boolean mIsBtnSwipeDone = true;
    private Object mRestoreResolverOnUndo;
    private int mRestoreResolverLastPosition;
    private ItemRemovedListener mItemRemovedListener;
    private float mPreviousSwipeAngle = 0.0f;

    public SwipePlaceHolderView(Context context) {
        super(context);
        this.setupView(new ArrayList(), new SwipeViewBuilder<SwipePlaceHolderView>(this), new SwipeOption(), new SwipeDecor());
    }

    public SwipePlaceHolderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupView(new ArrayList(), new SwipeViewBuilder<SwipePlaceHolderView>(this), new SwipeOption(), new SwipeDecor());
    }

    public SwipePlaceHolderView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setupView(new ArrayList(), new SwipeViewBuilder<SwipePlaceHolderView>(this), new SwipeOption(), new SwipeDecor());
    }

    @TargetApi(value=21)
    public SwipePlaceHolderView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setupView(new ArrayList(), new SwipeViewBuilder<SwipePlaceHolderView>(this), new SwipeOption(), new SwipeDecor());
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        if (this.mIsReverse) {
            return super.getChildDrawingOrder(childCount, i);
        }
        return super.getChildDrawingOrder(childCount, childCount - 1 - i);
    }

    protected <S extends SwipeViewBinder<?, ? extends FrameView, ? extends SwipeOption, ? extends SwipeDecor>, P extends SwipeOption, Q extends SwipeDecor, T extends SwipeViewBuilder<?>> void setupView(List<S> swipeViewBinderList, T swipeViewBuilder, P swipeOption, Q swipeDecor) {
        this.mSwipeViewBinderList = swipeViewBinderList;
        this.mSwipeViewBuilder = swipeViewBuilder;
        this.mLayoutInflater = LayoutInflater.from((Context)this.getContext());
        this.mSwipeDecor = swipeDecor;
        this.mSwipeOption = swipeOption;
        this.setChildrenDrawingOrderEnabled(true);
    }

    public <T extends SwipePlaceHolderView, S extends SwipeViewBuilder<T>> S getBuilder() {
        return (S)this.mSwipeViewBuilder;
    }

    protected SwipeOption getSwipeOption() {
        return this.mSwipeOption;
    }

    protected SwipeViewBuilder<SwipePlaceHolderView> getSwipeViewBuilder() {
        return this.mSwipeViewBuilder;
    }

    protected LayoutInflater getLayoutInflater() {
        return this.mLayoutInflater;
    }

    protected int getDisplayViewCount() {
        return this.mDisplayViewCount;
    }

    protected void setDisplayViewCount(int displayViewCount) {
        this.mDisplayViewCount = displayViewCount;
    }

    protected int getSwipeType() {
        return this.mSwipeType;
    }

    protected void setSwipeType(int swipeType) {
        this.mSwipeType = swipeType;
    }

    protected boolean isIsReverse() {
        return this.mIsReverse;
    }

    protected void setIsReverse(boolean isReverse) {
        this.mIsReverse = isReverse;
    }

    protected SwipeDecor getSwipeDecor() {
        return this.mSwipeDecor;
    }

    protected void setSwipeDecor(SwipeDecor swipeDecor) {
        if (swipeDecor != null) {
            this.mSwipeDecor = swipeDecor;
        }
    }

    protected List<SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor>> getSwipeViewBinderList() {
        return this.mSwipeViewBinderList;
    }

    protected boolean isIsBtnSwipeDone() {
        return this.mIsBtnSwipeDone;
    }

    protected boolean isUndoEnabled() {
        return this.mSwipeOption.isUndoEnabled();
    }

    protected void setIsUndoEnabled(boolean isUndoEnabled) {
        this.mSwipeOption.setIsUndoEnabled(isUndoEnabled);
    }

    protected Object getRestoreResolverOnUndo() {
        return this.mRestoreResolverOnUndo;
    }

    protected int getRestoreResolverLastPosition() {
        return this.mRestoreResolverLastPosition;
    }

    protected void setWidthSwipeDistFactor(float factor) {
        this.mSwipeOption.setWidthSwipeDistFactor(factor);
    }

    protected void setHeightSwipeDistFactor(float factor) {
        this.mSwipeOption.setHeightSwipeDistFactor(factor);
    }

    protected ItemRemovedListener getItemRemovedListener() {
        return this.mItemRemovedListener;
    }

    protected <T, F extends FrameView, P extends SwipeOption, Q extends SwipeDecor, V extends SwipeViewBinder<T, F, P, Q>> V getViewBinder(T resolver) {
        return (V)Binding.bindSwipeViewResolver(resolver);
    }

    public <T> SwipePlaceHolderView addView(T resolver) {
        FrameView swipeViewBinder = this.getViewBinder(resolver);
        this.mSwipeViewBinderList.add((SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor>)((Object)swipeViewBinder));
        if (this.mSwipeViewBinderList.size() <= this.mDisplayViewCount) {
            int position = this.mSwipeViewBinderList.indexOf((Object)swipeViewBinder);
            FrameView frameView = new FrameView(this.getContext());
            frameView.setLayoutParams((ViewGroup.LayoutParams)this.getLayoutParamsWithSwipeDecor(position, this.mSwipeDecor));
            this.mLayoutInflater.inflate(((ViewBinder)((Object)swipeViewBinder)).getLayoutId(), (ViewGroup)frameView, true);
            this.attachSwipeInfoViews(frameView, swipeViewBinder, this.mSwipeDecor);
            this.addView((View)frameView);
            this.setRelativeScale(frameView, position, this.mSwipeDecor);
            ((SwipeViewBinder)((Object)swipeViewBinder)).bindView((FrameView)frameView, position, this.mSwipeType, (SwipeDecor)this.mSwipeDecor, (SwipeOption)this.mSwipeOption, this);
            if (this.mSwipeViewBinderList.indexOf((Object)swipeViewBinder) == 0) {
                ((SwipeViewBinder)((Object)swipeViewBinder)).setOnTouch();
            }
        }
        return this;
    }

    protected <T> void addView(T resolver, int position) {
        if (position >= 0 && position <= this.mDisplayViewCount) {
            FrameView swipeViewBinder = this.getViewBinder(resolver);
            this.mSwipeViewBinderList.add(position, (SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor>)((Object)swipeViewBinder));
            int binderPosition = this.mSwipeViewBinderList.indexOf((Object)swipeViewBinder);
            FrameView frameView = new FrameView(this.getContext());
            frameView.setLayoutParams((ViewGroup.LayoutParams)this.getLayoutParamsWithSwipeDecor(binderPosition, this.mSwipeDecor));
            this.mLayoutInflater.inflate(((ViewBinder)((Object)swipeViewBinder)).getLayoutId(), (ViewGroup)frameView, true);
            this.attachSwipeInfoViews(frameView, swipeViewBinder, this.mSwipeDecor);
            this.addView((View)frameView, position);
            this.setRelativeScale(frameView, binderPosition, this.mSwipeDecor);
            ((SwipeViewBinder)((Object)swipeViewBinder)).bindView((FrameView)frameView, binderPosition, this.mSwipeType, (SwipeDecor)this.mSwipeDecor, (SwipeOption)this.mSwipeOption, this);
            if (this.mSwipeViewBinderList.indexOf((Object)swipeViewBinder) == 0) {
                ((SwipeViewBinder)((Object)swipeViewBinder)).setOnTouch();
            }
        }
    }

    protected <T> void addPendingView(SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> swipeViewBinder) {
        int position = this.mSwipeViewBinderList.indexOf(swipeViewBinder);
        FrameView frameView = new FrameView(this.getContext());
        frameView.setLayoutParams((ViewGroup.LayoutParams)this.getLayoutParamsWithSwipeDecor(position, this.mSwipeDecor));
        this.mLayoutInflater.inflate(swipeViewBinder.getLayoutId(), (ViewGroup)frameView, true);
        this.attachSwipeInfoViews(frameView, swipeViewBinder, this.mSwipeDecor);
        this.addView((View)frameView);
        this.setRelativeScale(frameView, position, this.mSwipeDecor);
        swipeViewBinder.bindView(frameView, position, this.mSwipeType, this.mSwipeDecor, this.mSwipeOption, this);
    }

    protected <V extends FrameLayout, T extends SwipeViewBinder> void attachSwipeInfoViews(V frame, T swipeViewBinder, SwipeDecor swipeDecor) {
        if (swipeDecor.getSwipeInMsgLayoutId() != -1 && swipeDecor.getSwipeOutMsgLayoutId() != -1) {
            FrameLayout swipeInMsgView = new FrameLayout(this.getContext());
            FrameLayout swipeOutMsgView = new FrameLayout(this.getContext());
            FrameLayout.LayoutParams layoutParamsInMsg = new FrameLayout.LayoutParams(-2, -2);
            FrameLayout.LayoutParams layoutParamsOutMsg = new FrameLayout.LayoutParams(-2, -2);
            layoutParamsInMsg.gravity = this.mSwipeDecor.getSwipeInMsgGravity();
            layoutParamsOutMsg.gravity = this.mSwipeDecor.getSwipeOutMsgGravity();
            swipeInMsgView.setLayoutParams((ViewGroup.LayoutParams)layoutParamsInMsg);
            swipeOutMsgView.setLayoutParams((ViewGroup.LayoutParams)layoutParamsOutMsg);
            this.mLayoutInflater.inflate(swipeDecor.getSwipeInMsgLayoutId(), (ViewGroup)swipeInMsgView, true);
            this.mLayoutInflater.inflate(swipeDecor.getSwipeOutMsgLayoutId(), (ViewGroup)swipeOutMsgView, true);
            frame.addView((View)swipeInMsgView);
            frame.addView((View)swipeOutMsgView);
            swipeInMsgView.setVisibility(8);
            swipeOutMsgView.setVisibility(8);
            swipeViewBinder.setSwipeInMsgView((View)swipeInMsgView);
            swipeViewBinder.setSwipeOutMsgView((View)swipeOutMsgView);
        }
    }

    protected FrameLayout.LayoutParams getLayoutParamsWithSwipeDecor(int position, SwipeDecor decor) {
        if (decor.getViewHeight() != 0 && decor.getViewWidth() != 0) {
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(decor.getViewWidth(), decor.getViewHeight());
            layoutParams.gravity = decor.getViewGravity();
            layoutParams.setMargins(decor.getMarginLeft() + decor.getPaddingLeft() * position, decor.getMarginTop() + decor.getPaddingTop() * position, 0, 0);
            return layoutParams;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = decor.getViewGravity();
        layoutParams.setMargins(decor.getMarginLeft() + decor.getPaddingLeft() * position, decor.getMarginTop() + decor.getPaddingTop() * position, 0, 0);
        return layoutParams;
    }

    protected <V extends FrameLayout> void setLayoutParamsWithSwipeDecor(V frame, int position, SwipeDecor decor) {
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)frame.getLayoutParams();
        layoutParams.setMargins(decor.getMarginLeft() + decor.getPaddingLeft() * position, decor.getMarginTop() + decor.getPaddingTop() * position, 0, 0);
        frame.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    protected <V extends View, T extends SwipeDecor> void setRelativeScale(V view, int position, T swipeDecor) {
        view.setScaleX(1.0f - (float)position * swipeDecor.getRelativeScale());
        view.setScaleY(1.0f - (float)position * swipeDecor.getRelativeScale());
    }

    public void doSwipe(Object resolver, boolean isSwipeIn) {
        if (this.mIsBtnSwipeDone) {
            this.mIsBtnSwipeDone = false;
            SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> swipeViewBinder = null;
            for (SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> viewBinder : this.mSwipeViewBinderList) {
                if (viewBinder.getResolver() != resolver) continue;
                swipeViewBinder = viewBinder;
                break;
            }
            if (swipeViewBinder != null) {
                swipeViewBinder.doSwipe(isSwipeIn);
            }
            new CountDownTimer((int)(2.25 * (double)this.mSwipeDecor.getSwipeAnimTime()), this.mSwipeDecor.getSwipeAnimTime()){

                public void onTick(long millisUntilFinished) {
                }

                public void onFinish() {
                    SwipePlaceHolderView.this.mIsBtnSwipeDone = true;
                }
            }.start();
        }
    }

    public void doSwipe(boolean isSwipeIn) {
        if (this.mIsBtnSwipeDone) {
            this.mIsBtnSwipeDone = false;
            if (this.mSwipeViewBinderList.size() > 0) {
                this.mSwipeViewBinderList.get(0).doSwipe(isSwipeIn);
            }
            new CountDownTimer((int)(2.25 * (double)this.mSwipeDecor.getSwipeAnimTime()), this.mSwipeDecor.getSwipeAnimTime()){

                public void onTick(long millisUntilFinished) {
                }

                public void onFinish() {
                    SwipePlaceHolderView.this.mIsBtnSwipeDone = true;
                }
            }.start();
        }
    }

    public void lockViews() {
        this.mSwipeOption.setIsViewLocked(true);
    }

    public void unlockViews() {
        this.mSwipeOption.setIsViewLocked(false);
    }

    public void activatePutBack() {
        this.mSwipeOption.setIsPutBackActive(true);
    }

    public void deactivatePutBack() {
        this.mSwipeOption.setIsPutBackActive(false);
    }

    public void disableTouchSwipe() {
        this.mSwipeOption.setIsTouchSwipeLocked(true);
    }

    public void enableTouchSwipe() {
        this.mSwipeOption.setIsTouchSwipeLocked(false);
    }

    @Override
    public void onRemoveView(SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> swipeViewBinder) {
        SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> newSwipeViewBinder = null;
        int position = -1;
        if (this.mSwipeViewBinderList.size() > this.mDisplayViewCount) {
            newSwipeViewBinder = this.mSwipeViewBinderList.get(this.mDisplayViewCount);
            position = this.mSwipeViewBinderList.indexOf(newSwipeViewBinder);
        }
        this.mSwipeViewBinderList.remove(swipeViewBinder);
        this.removeView((View)swipeViewBinder.getLayoutView());
        if (newSwipeViewBinder != null && position != -1) {
            this.addPendingView(newSwipeViewBinder);
            --position;
        } else {
            position = this.mSwipeViewBinderList.size() - 1;
        }
        this.resetViewOrientation(position, this.mSwipeDecor);
        if (this.mSwipeViewBinderList.size() > 0) {
            this.mSwipeViewBinderList.get(0).setOnTouch();
        }
        if (this.mSwipeOption.isUndoEnabled()) {
            this.mRestoreResolverOnUndo = swipeViewBinder.getResolver();
            this.mRestoreResolverLastPosition = position;
        }
        swipeViewBinder.unbind();
        if (this.mItemRemovedListener != null) {
            this.mItemRemovedListener.onItemRemoved(this.mSwipeViewBinderList.size());
        }
    }

    @Override
    public void onAnimateView(float distXMoved, float distYMoved, float finalXDist, float finalYDist, SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> swipeViewBinder) {
        float distYMovedAbs;
        float distXMovedAbs = distXMoved > 0.0f ? distXMoved : -distXMoved;
        float f = distYMovedAbs = distYMoved > 0.0f ? distYMoved : -distYMoved;
        if (this.mSwipeDecor.isAnimateScale() && this.mSwipeViewBinderList.contains(swipeViewBinder) && distXMovedAbs <= finalXDist && distYMovedAbs <= finalYDist) {
            float finalAngle;
            float finalDist;
            float distMoved;
            if (distXMovedAbs > distYMovedAbs) {
                distMoved = distXMovedAbs;
                finalDist = finalXDist;
            } else {
                distMoved = distYMovedAbs;
                finalDist = finalYDist;
            }
            int count = this.mSwipeViewBinderList.size() > this.mDisplayViewCount ? this.mDisplayViewCount : this.mSwipeViewBinderList.size();
            for (int i = this.mSwipeViewBinderList.indexOf(swipeViewBinder) + 1; i < count; ++i) {
                SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> swipeViewBinderBelow = this.mSwipeViewBinderList.get(i);
                float scaleDefault = 1.0f - (float)i * this.mSwipeDecor.getRelativeScale();
                float scaleOfAboveViewDefault = 1.0f - (float)(i - 1) * this.mSwipeDecor.getRelativeScale();
                float scale = (scaleOfAboveViewDefault - scaleDefault) / finalDist * distMoved + scaleDefault;
                swipeViewBinderBelow.getLayoutView().setScaleX(scale);
                swipeViewBinderBelow.getLayoutView().setScaleY(scale);
                FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)swipeViewBinderBelow.getLayoutView().getLayoutParams();
                float value = (float)(-this.mSwipeDecor.getPaddingTop()) / finalDist * distMoved + (float)(this.mSwipeDecor.getMarginTop() + this.mSwipeDecor.getPaddingTop() * i);
                layoutParams.topMargin = (int)value;
                value = (float)(-this.mSwipeDecor.getPaddingLeft()) / finalDist * distMoved + (float)(this.mSwipeDecor.getMarginLeft() + this.mSwipeDecor.getPaddingLeft() * i);
                layoutParams.leftMargin = (int)value;
                swipeViewBinderBelow.getLayoutView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            float angleMax = 0.0f;
            if (distXMoved > 0.0f && distYMoved > 0.0f) {
                angleMax = this.mSwipeDecor.getSwipeRotationAngle();
            } else if (distXMoved > 0.0f && distYMoved < 0.0f) {
                angleMax = -this.mSwipeDecor.getSwipeRotationAngle();
            } else if (distXMoved < 0.0f && distYMoved > 0.0f) {
                angleMax = -this.mSwipeDecor.getSwipeRotationAngle();
            } else if (distXMoved < 0.0f && distYMoved < 0.0f) {
                angleMax = this.mSwipeDecor.getSwipeRotationAngle();
            }
            float angle = angleMax / finalDist * distMoved;
            float deltaAngleSign = angle - this.mPreviousSwipeAngle > 0.0f ? 1.0f : -1.0f;
            float deltaAngle = Math.abs(angle - this.mPreviousSwipeAngle);
            deltaAngle = Math.min(this.mSwipeDecor.getSwipeMaxChangeAngle(), deltaAngle);
            this.mPreviousSwipeAngle = finalAngle = this.mPreviousSwipeAngle + deltaAngleSign * deltaAngle;
            swipeViewBinder.getLayoutView().setRotation(finalAngle);
        }
        if (distXMovedAbs > (float)this.mSwipeDecor.getSwipeDistToDisplayMsg() || distYMovedAbs > (float)this.mSwipeDecor.getSwipeDistToDisplayMsg()) {
            boolean isSwipeIn = false;
            if (distXMoved > 0.0f) {
                isSwipeIn = true;
            } else if (distXMoved < 0.0f) {
                isSwipeIn = false;
            } else if (distYMoved > 0.0f) {
                isSwipeIn = true;
            } else if (distYMoved < 0.0f) {
                isSwipeIn = false;
            }
            if (isSwipeIn) {
                swipeViewBinder.bindSwipeInState();
            } else {
                swipeViewBinder.bindSwipeOutState();
            }
            if (this.mSwipeDecor.getSwipeInMsgLayoutId() != -1 && this.mSwipeDecor.getSwipeOutMsgLayoutId() != -1) {
                if (isSwipeIn) {
                    if (swipeViewBinder.getSwipeInMsgView() != null && swipeViewBinder.getSwipeInMsgView().getVisibility() == 8) {
                        swipeViewBinder.getSwipeInMsgView().setVisibility(0);
                    }
                    if (swipeViewBinder.getSwipeOutMsgView() != null && swipeViewBinder.getSwipeOutMsgView().getVisibility() == 0) {
                        swipeViewBinder.getSwipeOutMsgView().setVisibility(8);
                    }
                } else {
                    if (swipeViewBinder.getSwipeOutMsgView() != null && swipeViewBinder.getSwipeOutMsgView().getVisibility() == 8) {
                        swipeViewBinder.getSwipeOutMsgView().setVisibility(0);
                    }
                    if (swipeViewBinder.getSwipeInMsgView() != null && swipeViewBinder.getSwipeInMsgView().getVisibility() == 0) {
                        swipeViewBinder.getSwipeInMsgView().setVisibility(8);
                    }
                }
            }
        }
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)swipeViewBinder.getLayoutView().getLayoutParams();
        swipeViewBinder.setFinalLeftMargin(layoutParams.leftMargin);
        swipeViewBinder.setFinalTopMargin(layoutParams.topMargin);
    }

    @Override
    public void onResetView(SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> swipeViewBinder) {
        if (this.mSwipeViewBinderList.size() > this.mDisplayViewCount) {
            this.resetViewOrientation(this.mDisplayViewCount - 1, this.mSwipeDecor);
        } else {
            this.resetViewOrientation(this.mSwipeViewBinderList.size() - 1, this.mSwipeDecor);
        }
        if (this.mSwipeDecor.getSwipeInMsgLayoutId() != -1 && this.mSwipeDecor.getSwipeOutMsgLayoutId() != -1) {
            if (swipeViewBinder.getSwipeInMsgView() != null && swipeViewBinder.getSwipeInMsgView().getVisibility() == 0) {
                swipeViewBinder.getSwipeInMsgView().setVisibility(8);
            }
            if (swipeViewBinder.getSwipeOutMsgView() != null && swipeViewBinder.getSwipeOutMsgView().getVisibility() == 0) {
                swipeViewBinder.getSwipeOutMsgView().setVisibility(8);
            }
        }
        swipeViewBinder.getLayoutView().setRotation(0.0f);
        swipeViewBinder.bindSwipeCancelState();
        swipeViewBinder.getLayoutView().reset();
    }

    protected <T extends SwipeDecor> void resetViewOrientation(int lastPosition, T swipeDecor) {
        if (swipeDecor.isAnimateScale() && lastPosition >= 0) {
            for (int i = 0; i <= lastPosition; ++i) {
                if (this.mSwipeViewBinderList.get(i) == null) continue;
                SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> swipeViewBinder = this.mSwipeViewBinderList.get(i);
                this.setRelativeScale(swipeViewBinder.getLayoutView(), i, swipeDecor);
                this.setLayoutParamsWithSwipeDecor(swipeViewBinder.getLayoutView(), i, swipeDecor);
            }
        }
        this.mPreviousSwipeAngle = 0.0f;
    }

    public void undoLastSwipe() {
        if (this.mSwipeOption.isUndoEnabled() && this.mRestoreResolverOnUndo != null) {
            SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> lowerCard;
            if (this.mRestoreResolverLastPosition >= 0 && this.mRestoreResolverLastPosition >= this.mDisplayViewCount - 1) {
                this.removeViewAt(this.mRestoreResolverLastPosition);
            }
            this.addView(this.mRestoreResolverOnUndo, 0);
            this.mRestoreResolverOnUndo = null;
            if (this.mSwipeViewBinderList.size() > 1 && (lowerCard = this.mSwipeViewBinderList.get(1)).getLayoutView() != null) {
                lowerCard.blockTouch();
            }
            SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> topCard = this.mSwipeViewBinderList.get(0);
            topCard.doUndoAnimation();
            if (this.mRestoreResolverLastPosition >= 0 && this.mRestoreResolverLastPosition >= this.mDisplayViewCount - 1) {
                this.resetViewOrientation(this.mRestoreResolverLastPosition, this.mSwipeDecor);
            } else {
                this.resetViewOrientation(this.mRestoreResolverLastPosition + 1, this.mSwipeDecor);
            }
        }
    }

    public void addItemRemoveListener(ItemRemovedListener listener) {
        this.mItemRemovedListener = listener;
    }

    public List<Object> getAllResolvers() {
        ArrayList<Object> resolverList = new ArrayList<Object>();
        for (SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> binder : this.mSwipeViewBinderList) {
            resolverList.add(binder.getResolver());
        }
        return resolverList;
    }

    @Deprecated
    public void removeView(View view) {
        super.removeView(view);
    }

    @Deprecated
    public void removeViewInLayout(View view) {
        super.removeViewInLayout(view);
    }

    @Deprecated
    public void removeViewsInLayout(int start, int count) {
        super.removeViewsInLayout(start, count);
    }

    @Deprecated
    public void removeViewAt(int index) {
        super.removeViewAt(index);
    }

    @Deprecated
    public void removeViews(int start, int count) {
        super.removeViews(start, count);
    }

    public void removeAllViews() {
        Iterator<SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor>> iterator = this.mSwipeViewBinderList.iterator();
        while (iterator.hasNext()) {
            SwipeViewBinder<Object, FrameView, SwipeOption, SwipeDecor> swipeViewBinder = iterator.next();
            if (swipeViewBinder != null) {
                swipeViewBinder.unbind();
            }
            iterator.remove();
        }
        this.mRestoreResolverOnUndo = null;
        this.mPreviousSwipeAngle = 0.0f;
        super.removeAllViews();
    }

    @Deprecated
    public void removeAllViewsInLayout() {
        super.removeAllViewsInLayout();
    }

    @Deprecated
    protected void removeDetachedView(View child, boolean animate) {
        super.removeDetachedView(child, animate);
    }

    @Deprecated
    public void addView(View child) {
        super.addView(child);
    }

    @Deprecated
    public void addView(View child, int index) {
        super.addView(child, index);
    }

    @Deprecated
    public void addView(View child, int width, int height) {
        super.addView(child, width, height);
    }

    @Deprecated
    public void addView(View child, ViewGroup.LayoutParams params) {
        super.addView(child, params);
    }

    @Deprecated
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        super.addView(child, index, params);
    }

    @Deprecated
    protected boolean addViewInLayout(View child, int index, ViewGroup.LayoutParams params) {
        return super.addViewInLayout(child, index, params);
    }

    @Deprecated
    protected boolean addViewInLayout(View child, int index, ViewGroup.LayoutParams params, boolean preventRequestLayout) {
        return super.addViewInLayout(child, index, params, preventRequestLayout);
    }

    public static class SwipeOption {
        private float mWidthSwipeDistFactor = 3.0f;
        private float mHeightSwipeDistFactor = 3.0f;
        private AtomicBoolean mIsViewLocked = new AtomicBoolean(false);
        private AtomicBoolean mIsPutBackActive = new AtomicBoolean(false);
        private AtomicBoolean mIsViewToRestoreOnLock = new AtomicBoolean(true);
        private AtomicBoolean mIsViewToRestoreOnTouchLock = new AtomicBoolean(true);
        private AtomicBoolean mIsTouchSwipeLocked = new AtomicBoolean(false);
        private boolean mIsUndoEnabled = false;

        protected boolean getIsViewLocked() {
            return this.mIsViewLocked.get();
        }

        protected void setIsViewLocked(boolean isViewLocked) {
            this.mIsViewToRestoreOnLock.set(true);
            this.mIsViewLocked.set(isViewLocked);
        }

        protected boolean getIsPutBackActive() {
            return this.mIsPutBackActive.get();
        }

        protected void setIsPutBackActive(boolean isPutBackActive) {
            this.mIsPutBackActive.set(isPutBackActive);
        }

        protected boolean getIsViewToRestoredOnLock() {
            return this.mIsViewToRestoreOnLock.get();
        }

        protected void setIsViewToRestoredOnLock(boolean isViewToRestoredOnLock) {
            this.mIsViewToRestoreOnLock.set(isViewToRestoredOnLock);
        }

        protected boolean getIsViewToRestoreOnTouchLock() {
            return this.mIsViewToRestoreOnTouchLock.get();
        }

        protected void setIsViewToRestoreOnTouchLock(boolean isViewToRestoreOnTouchLock) {
            this.mIsViewToRestoreOnTouchLock.set(isViewToRestoreOnTouchLock);
        }

        protected boolean getIsTouchSwipeLocked() {
            return this.mIsTouchSwipeLocked.get();
        }

        protected void setIsTouchSwipeLocked(boolean locked) {
            this.mIsViewToRestoreOnTouchLock.set(true);
            this.mIsTouchSwipeLocked.set(locked);
        }

        public float getWidthSwipeDistFactor() {
            return this.mWidthSwipeDistFactor;
        }

        public void setWidthSwipeDistFactor(float widthSwipeDistFactor) {
            this.mWidthSwipeDistFactor = widthSwipeDistFactor;
        }

        public float getHeightSwipeDistFactor() {
            return this.mHeightSwipeDistFactor;
        }

        public void setHeightSwipeDistFactor(float heightSwipeDistFactor) {
            this.mHeightSwipeDistFactor = heightSwipeDistFactor;
        }

        public boolean isUndoEnabled() {
            return this.mIsUndoEnabled;
        }

        public void setIsUndoEnabled(boolean isUndoEnabled) {
            this.mIsUndoEnabled = isUndoEnabled;
        }
    }

    public static class FrameView
    extends FrameLayout {
        private int mTouchSlop;
        private boolean mIsBeingDragged = false;
        private int mLastMotionY;
        private int mLastMotionX;

        public FrameView(Context context) {
            super(context);
            ViewConfiguration vc = ViewConfiguration.get((Context)this.getContext());
            this.mTouchSlop = vc.getScaledTouchSlop();
        }

        public boolean onInterceptTouchEvent(MotionEvent ev) {
            int action = ev.getAction();
            if (action == 2 && this.mIsBeingDragged) {
                return true;
            }
            switch (action & 0xFF) {
                case 2: {
                    int y = (int)ev.getRawY();
                    int x = (int)ev.getRawX();
                    int yDiff = Math.abs(y - this.mLastMotionY);
                    int xDiff = Math.abs(x - this.mLastMotionX);
                    if (yDiff <= this.mTouchSlop && xDiff <= this.mTouchSlop) break;
                    this.mIsBeingDragged = true;
                    this.mLastMotionY = y;
                    this.mLastMotionX = x;
                    break;
                }
                case 0: {
                    this.mLastMotionY = (int)ev.getRawY();
                    this.mLastMotionX = (int)ev.getRawX();
                    break;
                }
                case 1: 
                case 3: {
                    this.mIsBeingDragged = false;
                }
            }
            return this.mIsBeingDragged;
        }

        public void reset() {
            this.mIsBeingDragged = false;
        }
    }
}

