/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.animation.TimeInterpolator;
import android.graphics.PointF;
import android.os.CountDownTimer;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.FrameLayout;
import com.mindorks.placeholderview.SwipeDecor;
import com.mindorks.placeholderview.SwipeDirection;
import com.mindorks.placeholderview.SwipeDirectionalView;
import com.mindorks.placeholderview.SwipePlaceHolderView;
import com.mindorks.placeholderview.SwipeViewBinder;

public abstract class SwipeDirectionalViewBinder<T, V extends SwipePlaceHolderView.FrameView, P extends SwipeDirectionalView.SwipeDirectionalOption, Q extends SwipeDecor>
extends SwipeViewBinder<T, V, P, Q> {
    private boolean mHasInterceptedEvent = false;
    private int mOriginalLeftMargin;
    private int mOriginalTopMargin;
    private float mTransXToRestore;
    private float mTransYToRestore;

    protected SwipeDirectionalViewBinder(T resolver, int layoutId, boolean nullable) {
        super(resolver, layoutId, nullable);
    }

    @Override
    protected void setDefaultTouchListener(V view) {
        this.setAnimatorListener();
        final DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        FrameLayout.LayoutParams layoutParamsOriginal = (FrameLayout.LayoutParams)view.getLayoutParams();
        this.mOriginalLeftMargin = layoutParamsOriginal.leftMargin;
        this.mOriginalTopMargin = layoutParamsOriginal.topMargin;
        this.mTransXToRestore = view.getTranslationX();
        this.mTransYToRestore = view.getTranslationY();
        view.setOnTouchListener(new View.OnTouchListener((SwipePlaceHolderView.FrameView)((Object)view)){
            private float dx;
            private float dy;
            private int activePointerId = -1;
            private boolean resetDone = false;
            private PointF pointerCurrentPoint = new PointF();
            private PointF pointerStartingPoint = new PointF();
            final /* synthetic */ SwipePlaceHolderView.FrameView val$view;
            {
                this.val$view = frameView;
            }

            public boolean onTouch(View v, MotionEvent event) {
                if (((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getIsTouchSwipeLocked()) {
                    if (((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getIsViewToRestoreOnTouchLock()) {
                        ((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).setIsViewToRestoreOnTouchLock(false);
                        SwipeDirectionalViewBinder.this.animateSwipeRestore(v, SwipeDirectionalViewBinder.this.mOriginalTopMargin, SwipeDirectionalViewBinder.this.mOriginalLeftMargin, SwipeDirectionalViewBinder.this.getSwipeType());
                    }
                    return true;
                }
                if (((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getIsViewLocked()) {
                    if (((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getIsViewToRestoredOnLock()) {
                        ((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).setIsViewToRestoredOnLock(false);
                        SwipeDirectionalViewBinder.this.animateSwipeRestore(v, SwipeDirectionalViewBinder.this.mOriginalTopMargin, SwipeDirectionalViewBinder.this.mOriginalLeftMargin, SwipeDirectionalViewBinder.this.getSwipeType());
                    }
                    return true;
                }
                if (!SwipeDirectionalViewBinder.this.mHasInterceptedEvent) {
                    this.pointerStartingPoint.set(event.getRawX(), event.getRawY());
                    this.pointerCurrentPoint.set(event.getRawX(), event.getRawY());
                    this.activePointerId = event.getPointerId(0);
                    this.resetDone = false;
                    FrameLayout.LayoutParams layoutParamsOriginal = (FrameLayout.LayoutParams)v.getLayoutParams();
                    this.dx = this.pointerCurrentPoint.x - (float)layoutParamsOriginal.leftMargin;
                    this.dy = this.pointerCurrentPoint.y - (float)layoutParamsOriginal.topMargin;
                    SwipeDirectionalViewBinder.this.mHasInterceptedEvent = true;
                }
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        break;
                    }
                    case 6: {
                        if (event.getPointerId(event.getActionIndex()) != this.activePointerId || this.resetDone) break;
                    }
                    case 1: {
                        if (this.resetDone) break;
                        float distSlideX = this.pointerCurrentPoint.x - this.dx;
                        float distSlideY = this.pointerCurrentPoint.y - this.dy;
                        distSlideX = distSlideX < 0.0f ? -distSlideX : distSlideX;
                        float f = distSlideY = distSlideY < 0.0f ? -distSlideY : distSlideY;
                        if (distSlideX < (float)displayMetrics.widthPixels / ((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getWidthSwipeDistFactor() && distSlideY < (float)displayMetrics.heightPixels / ((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getHeightSwipeDistFactor()) {
                            SwipeDirectionalViewBinder.this.animateSwipeRestore(v, SwipeDirectionalViewBinder.this.mOriginalTopMargin, SwipeDirectionalViewBinder.this.mOriginalLeftMargin, SwipeDirectionalViewBinder.this.getSwipeType());
                        } else {
                            if (!((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getIsPutBackActive()) {
                                SwipeDirectionalViewBinder.this.blockTouch();
                            }
                            float transX = displayMetrics.widthPixels;
                            float transY = displayMetrics.heightPixels;
                            float delX = this.pointerCurrentPoint.x - this.pointerStartingPoint.x;
                            float delY = this.pointerCurrentPoint.y - this.pointerStartingPoint.y;
                            if (this.pointerCurrentPoint.x >= this.pointerStartingPoint.x && this.pointerCurrentPoint.y >= this.pointerStartingPoint.y) {
                                if (delX > (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeVerticalThreshold() && delY <= (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                                    transY = v.getTranslationY();
                                    SwipeDirectionalViewBinder.this.bindSwipeInDirectional(SwipeDirection.RIGHT);
                                } else if (delX <= (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeVerticalThreshold() && delY > (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                                    transX = v.getTranslationX();
                                    SwipeDirectionalViewBinder.this.bindSwipeInDirectional(SwipeDirection.BOTTOM);
                                } else {
                                    SwipeDirectionalViewBinder.this.bindSwipeInDirectional(SwipeDirection.RIGHT_BOTTOM);
                                }
                            } else if (this.pointerCurrentPoint.x > this.pointerStartingPoint.x && this.pointerCurrentPoint.y < this.pointerStartingPoint.y) {
                                transY = -v.getHeight();
                                delY *= -1.0f;
                                if (delX > (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeVerticalThreshold() && delY <= (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                                    transY = v.getTranslationY();
                                    SwipeDirectionalViewBinder.this.bindSwipeInDirectional(SwipeDirection.RIGHT);
                                } else if (delX <= (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeVerticalThreshold() && delY > (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                                    transX = v.getTranslationX();
                                    SwipeDirectionalViewBinder.this.bindSwipeOutDirectional(SwipeDirection.TOP);
                                } else {
                                    SwipeDirectionalViewBinder.this.bindSwipeOutDirectional(SwipeDirection.RIGHT_TOP);
                                }
                            } else if (this.pointerCurrentPoint.x < this.pointerStartingPoint.x && this.pointerCurrentPoint.y >= this.pointerStartingPoint.y) {
                                transX = -v.getWidth();
                                if ((delX *= -1.0f) > (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeVerticalThreshold() && delY <= (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                                    transY = v.getTranslationY();
                                    SwipeDirectionalViewBinder.this.bindSwipeOutDirectional(SwipeDirection.LEFT);
                                } else if (delX <= (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeVerticalThreshold() && delY > (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                                    transX = v.getTranslationX();
                                    SwipeDirectionalViewBinder.this.bindSwipeInDirectional(SwipeDirection.BOTTOM);
                                } else {
                                    SwipeDirectionalViewBinder.this.bindSwipeOutDirectional(SwipeDirection.LEFT_BOTTOM);
                                }
                            } else if (this.pointerCurrentPoint.x <= this.pointerStartingPoint.x && this.pointerCurrentPoint.y < this.pointerStartingPoint.y) {
                                transY = -v.getHeight();
                                transX = -v.getWidth();
                                delX *= -1.0f;
                                delY *= -1.0f;
                                if (delX > (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeVerticalThreshold() && delY <= (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                                    transY = v.getTranslationY();
                                    SwipeDirectionalViewBinder.this.bindSwipeOutDirectional(SwipeDirection.LEFT);
                                } else if (delX <= (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeVerticalThreshold() && delY > (float)((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                                    transX = v.getTranslationX();
                                    SwipeDirectionalViewBinder.this.bindSwipeOutDirectional(SwipeDirection.TOP);
                                } else {
                                    SwipeDirectionalViewBinder.this.bindSwipeOutDirectional(SwipeDirection.LEFT_TOP);
                                }
                            }
                            this.val$view.animate().translationX(transX).translationY(transY).setInterpolator((TimeInterpolator)new AccelerateInterpolator(((SwipeDecor)SwipeDirectionalViewBinder.this.getSwipeDecor()).getSwipeAnimFactor())).setDuration((long)((double)((SwipeDecor)SwipeDirectionalViewBinder.this.getSwipeDecor()).getSwipeAnimTime() * 1.25)).setListener(SwipeDirectionalViewBinder.this.getViewRemoveAnimatorListener()).start();
                        }
                        new CountDownTimer(((SwipeDecor)SwipeDirectionalViewBinder.this.getSwipeDecor()).getSwipeAnimTime(), ((SwipeDecor)SwipeDirectionalViewBinder.this.getSwipeDecor()).getSwipeAnimTime()){

                            public void onTick(long millisUntilFinished) {
                            }

                            public void onFinish() {
                                SwipeDirectionalViewBinder.this.mHasInterceptedEvent = false;
                            }
                        }.start();
                        this.resetDone = true;
                        break;
                    }
                    case 2: {
                        if (this.resetDone || event.findPointerIndex(this.activePointerId) == -1) break;
                        this.pointerCurrentPoint.set(event.getRawX(), event.getRawY());
                        FrameLayout.LayoutParams layoutParamsTemp = (FrameLayout.LayoutParams)v.getLayoutParams();
                        layoutParamsTemp.topMargin = (int)(this.pointerCurrentPoint.y - this.dy);
                        layoutParamsTemp.leftMargin = (int)(this.pointerCurrentPoint.x - this.dx);
                        v.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTemp);
                        int distanceMovedTop = layoutParamsTemp.topMargin - SwipeDirectionalViewBinder.this.mOriginalTopMargin;
                        int distanceMovedLeft = layoutParamsTemp.leftMargin - SwipeDirectionalViewBinder.this.mOriginalLeftMargin;
                        SwipeDirectionalViewBinder.this.getCallback().onAnimateView(distanceMovedLeft, distanceMovedTop, (float)displayMetrics.widthPixels / ((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getWidthSwipeDistFactor(), (float)displayMetrics.heightPixels / ((SwipeDirectionalView.SwipeDirectionalOption)SwipeDirectionalViewBinder.this.getSwipeOption()).getHeightSwipeDistFactor(), SwipeDirectionalViewBinder.this);
                        SwipeDirectionalViewBinder.this.broadcastMoveDirection(this.pointerCurrentPoint.x, this.pointerCurrentPoint.y, this.pointerStartingPoint.x, this.pointerStartingPoint.y);
                    }
                }
                return true;
            }
        });
    }

    private void broadcastMoveDirection(float xCurrent, float yCurrent, float xStart, float yStart) {
        this.bindSwipeTouch(xStart, yStart, xCurrent, yCurrent);
        float delX = xCurrent - xStart;
        float delY = yCurrent - yStart;
        if (xCurrent >= xStart && yCurrent >= yStart) {
            if (delX > (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeVerticalThreshold() && delY <= (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                this.bindSwipingDirection(SwipeDirection.RIGHT);
            } else if (delX <= (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeVerticalThreshold() && delY > (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                this.bindSwipingDirection(SwipeDirection.BOTTOM);
            } else {
                this.bindSwipingDirection(SwipeDirection.RIGHT_BOTTOM);
            }
        } else if (xCurrent > xStart && yCurrent < yStart) {
            delY *= -1.0f;
            if (delX > (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeVerticalThreshold() && delY <= (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                this.bindSwipingDirection(SwipeDirection.RIGHT);
            } else if (delX <= (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeVerticalThreshold() && delY > (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                this.bindSwipingDirection(SwipeDirection.TOP);
            } else {
                this.bindSwipingDirection(SwipeDirection.RIGHT_TOP);
            }
        } else if (xCurrent < xStart && yCurrent >= yStart) {
            if ((delX *= -1.0f) > (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeVerticalThreshold() && delY <= (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                this.bindSwipingDirection(SwipeDirection.LEFT);
            } else if (delX <= (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeVerticalThreshold() && delY > (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                this.bindSwipingDirection(SwipeDirection.BOTTOM);
            } else {
                this.bindSwipingDirection(SwipeDirection.LEFT_BOTTOM);
            }
        } else if (xCurrent <= xStart && yCurrent < yStart) {
            delX *= -1.0f;
            delY *= -1.0f;
            if (delX > (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeVerticalThreshold() && delY <= (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                this.bindSwipingDirection(SwipeDirection.LEFT);
            } else if (delX <= (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeVerticalThreshold() && delY > (float)((SwipeDirectionalView.SwipeDirectionalOption)this.getSwipeOption()).getSwipeHorizontalThreshold()) {
                this.bindSwipingDirection(SwipeDirection.TOP);
            } else {
                this.bindSwipingDirection(SwipeDirection.LEFT_TOP);
            }
        }
    }

    protected abstract void bindSwipingDirection(SwipeDirection var1);

    protected abstract void bindSwipeInDirectional(SwipeDirection var1);

    protected abstract void bindSwipeOutDirectional(SwipeDirection var1);

    protected abstract void bindSwipeTouch(float var1, float var2, float var3, float var4);
}

