/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import com.mindorks.placeholderview.Binding;
import com.mindorks.placeholderview.LoadMoreCallbackBinder;
import com.mindorks.placeholderview.PlaceHolderView;

public class InfinitePlaceHolderView
extends PlaceHolderView {
    private boolean mIsLoadingMore = false;
    private boolean mNoMoreToLoad = false;
    private Object mLoadMoreResolver;
    private LoadMoreCallbackBinder mLoadMoreCallbackBinder;
    private RecyclerView.OnScrollListener mOnScrollListener;

    public InfinitePlaceHolderView(Context context) {
        super(context);
    }

    public InfinitePlaceHolderView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public InfinitePlaceHolderView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    private void setLoadMoreListener() {
        this.mOnScrollListener = new RecyclerView.OnScrollListener(){

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
                if (layoutManager instanceof LinearLayoutManager) {
                    LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
                    int totalItemCount = linearLayoutManager.getItemCount();
                    int lastVisibleItem = linearLayoutManager.findLastVisibleItemPosition();
                    if (!InfinitePlaceHolderView.this.mIsLoadingMore && !InfinitePlaceHolderView.this.mNoMoreToLoad && totalItemCount > 0 && totalItemCount == lastVisibleItem + 1) {
                        InfinitePlaceHolderView.this.mIsLoadingMore = true;
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                InfinitePlaceHolderView.this.addView(InfinitePlaceHolderView.this.mLoadMoreResolver);
                                InfinitePlaceHolderView.this.mLoadMoreCallbackBinder.bindLoadMore(InfinitePlaceHolderView.this.mLoadMoreResolver);
                            }
                        });
                    }
                }
            }
        };
        this.addOnScrollListener(this.mOnScrollListener);
    }

    public <T> void setLoadMoreResolver(T loadMoreResolver) {
        this.mLoadMoreResolver = loadMoreResolver;
        this.mLoadMoreCallbackBinder = Binding.bindLoadMoreCallback(loadMoreResolver);
        this.mNoMoreToLoad = false;
        this.setLoadMoreListener();
    }

    public void noMoreToLoad() {
        this.mNoMoreToLoad = true;
        this.removeOnScrollListener(this.mOnScrollListener);
    }

    public void loadingDone() {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                InfinitePlaceHolderView.this.removeView(InfinitePlaceHolderView.this.mLoadMoreResolver);
                InfinitePlaceHolderView.this.mIsLoadingMore = false;
            }
        });
    }

    public int getViewCount() {
        return super.getViewResolverCount() - 1;
    }
}

