/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.view.View;
import com.mindorks.placeholderview.ViewBinder;
import java.util.ArrayList;
import java.util.List;

public abstract class ExpandableViewBinder<T, V extends View>
extends ViewBinder<T, V> {
    private boolean mParent = false;
    private boolean mExpanded = false;
    private boolean mSingleTop = false;
    private List<ExpandableViewBinder<T, V>> mChildList;
    private ExpansionCallback<T, V> mCallback;
    private int mChildPosition;
    private int mParentPosition;
    private ExpandableViewBinder<T, V> mParentViewBinder;

    protected ExpandableViewBinder(T resolver, int layoutId, boolean nullable, boolean parent, boolean singleTop) {
        super(resolver, layoutId, nullable);
        this.mParent = parent;
        this.mSingleTop = singleTop;
        this.mChildList = new ArrayList<ExpandableViewBinder<T, V>>();
    }

    @Override
    protected void bindView(V itemView, int position) {
        super.bindView(itemView, position);
        if (this.mParent) {
            this.bindToggle(this.getResolver(), itemView);
        }
    }

    @Override
    @Deprecated
    protected void unbind() {
    }

    @Override
    @Deprecated
    protected void bindAnimation(int deviceWidth, int deviceHeight, V view) {
    }

    protected void setCallback(ExpansionCallback callback) {
        this.mCallback = callback;
    }

    protected List<ExpandableViewBinder<T, V>> getChildList() {
        return this.mChildList;
    }

    protected void collapse() {
        if (this.mParent && this.mCallback != null && this.mExpanded) {
            this.mCallback.onCollapse(this);
            this.bindCollapse(this.getResolver());
        }
        this.mExpanded = false;
    }

    protected void expand() {
        if (this.mParent && this.mCallback != null && !this.mExpanded) {
            this.mCallback.onExpand(this);
            this.bindExpand(this.getResolver());
        }
        this.mExpanded = true;
    }

    protected boolean isParent() {
        return this.mParent;
    }

    protected boolean isExpanded() {
        return this.mExpanded;
    }

    protected boolean isSingleTop() {
        return this.mSingleTop;
    }

    protected int getChildPosition() {
        return this.mChildPosition;
    }

    public void setChildPosition(int position) {
        this.mChildPosition = position;
    }

    protected int getParentPosition() {
        return this.mParentPosition;
    }

    public void setParentPosition(int position) {
        this.mParentPosition = position;
    }

    protected ExpandableViewBinder<T, V> getParentViewBinder() {
        return this.mParentViewBinder;
    }

    protected void setParentViewBinder(ExpandableViewBinder<T, V> mParentViewBinder) {
        this.mParentViewBinder = mParentViewBinder;
    }

    protected abstract void bindParentPosition(int var1);

    protected abstract void bindChildPosition(int var1);

    protected abstract void bindToggle(T var1, V var2);

    protected abstract void bindCollapse(T var1);

    protected abstract void bindExpand(T var1);

    protected static interface ExpansionCallback<T, V extends View> {
        public void onExpand(ExpandableViewBinder<T, V> var1);

        public void onCollapse(ExpandableViewBinder<T, V> var1);
    }
}

