/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.view.View;
import com.mindorks.placeholderview.Animation;
import com.mindorks.placeholderview.annotations.Animate;

public class AnimationResolver<T, V extends View> {
    protected void bindAnimation(int deviceWidth, int deviceHeight, T resolver, V view) {
        Animate animate = resolver.getClass().getAnnotation(Animate.class);
        if (animate != null) {
            switch (animate.value()) {
                case 1: {
                    Animation.itemAnimFromXDesc(view, deviceWidth, view.getTranslationX(), animate.factor(), animate.duration());
                    break;
                }
                case 2: {
                    Animation.itemAnimFromXAsc(view, deviceWidth, view.getTranslationX(), animate.factor(), animate.duration());
                    break;
                }
                case 3: {
                    Animation.itemAnimFromXDesc(view, -deviceWidth, view.getTranslationX(), animate.factor(), animate.duration());
                    break;
                }
                case 4: {
                    Animation.itemAnimFromXAsc(view, -deviceWidth, view.getTranslationX(), animate.factor(), animate.duration());
                    break;
                }
                case 5: {
                    Animation.itemAnimFromYDesc(view, -view.getHeight(), view.getTranslationY(), animate.factor(), animate.duration());
                    break;
                }
                case 6: {
                    Animation.itemAnimFromYAsc(view, -view.getHeight(), view.getTranslationY(), animate.factor(), animate.duration());
                    break;
                }
                case 7: {
                    Animation.itemAnimFromYDesc(view, deviceHeight, view.getTranslationY(), animate.factor(), animate.duration());
                    break;
                }
                case 8: {
                    Animation.itemAnimFromXAsc(view, deviceHeight, view.getTranslationY(), animate.factor(), animate.duration());
                    break;
                }
                case 9: {
                    Animation.itemAnimScaleDesc(view, 0.5f, 1.0f, animate.factor(), animate.duration());
                    break;
                }
                case 10: {
                    Animation.itemAnimScaleAsc(view, 0.5f, 1.0f, animate.factor(), animate.duration());
                    break;
                }
                case 11: {
                    Animation.itemAnimScaleDesc(view, 1.25f, 1.0f, animate.factor(), animate.duration());
                    break;
                }
                case 12: {
                    Animation.itemAnimScaleAsc(view, 1.25f, 1.0f, animate.factor(), animate.duration());
                    break;
                }
                case 13: {
                    Animation.itemAnimFadeDesc(view, 0.0f, 1.0f, animate.factor(), animate.duration());
                    break;
                }
                case 14: {
                    Animation.itemAnimFadeAsc(view, 0.0f, 1.0f, animate.factor(), animate.duration());
                    break;
                }
                case 15: {
                    Animation.itemAnimFromXDesc(view, view.getTranslationX() + (float)view.getWidth() / 2.0f, view.getTranslationX(), animate.factor(), animate.duration());
                    break;
                }
                case 16: {
                    Animation.itemAnimFromXAsc(view, view.getTranslationX() + (float)view.getWidth() / 2.0f, view.getTranslationX(), animate.factor(), animate.duration());
                    break;
                }
                case 17: {
                    Animation.itemAnimFromXDesc(view, view.getTranslationX() - (float)view.getWidth() / 2.0f, view.getTranslationX(), animate.factor(), animate.duration());
                    break;
                }
                case 18: {
                    Animation.itemAnimFromXAsc(view, view.getTranslationX() - (float)view.getWidth() / 2.0f, view.getTranslationX(), animate.factor(), animate.duration());
                    break;
                }
                case 19: {
                    Animation.itemAnimFromYDesc(view, view.getTranslationY() - (float)view.getHeight() / 2.0f, view.getTranslationX(), animate.factor(), animate.duration());
                    break;
                }
                case 20: {
                    Animation.itemAnimFromYAsc(view, view.getTranslationY() - (float)view.getHeight() / 2.0f, view.getTranslationX(), animate.factor(), animate.duration());
                    break;
                }
                case 21: {
                    Animation.itemAnimFromYDesc(view, view.getTranslationY() + (float)view.getHeight() / 2.0f, view.getTranslationX(), animate.factor(), animate.duration());
                    break;
                }
                case 22: {
                    Animation.itemAnimFromYAsc(view, view.getTranslationX() + (float)view.getHeight() / 2.0f, view.getTranslationX(), animate.factor(), animate.duration());
                }
            }
        }
    }
}

