/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.PointF;
import android.os.CountDownTimer;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.FrameLayout;
import com.mindorks.placeholderview.SwipeDecor;
import com.mindorks.placeholderview.SwipePlaceHolderView;
import com.mindorks.placeholderview.ViewBinder;

public abstract class SwipeViewBinder<T, V extends SwipePlaceHolderView.FrameView, P extends SwipePlaceHolderView.SwipeOption, Q extends SwipeDecor>
extends ViewBinder<T, V> {
    private static int mFinalLeftMargin;
    private static int mFinalTopMargin;
    private V mLayoutView;
    private SwipeCallback<SwipeViewBinder<T, V, P, Q>> mCallback;
    private Animator.AnimatorListener mViewRemoveAnimatorListener;
    private Animator.AnimatorListener mViewRestoreAnimatorListener;
    private Animator.AnimatorListener mViewPutBackAnimatorListener;
    private int mSwipeType = 1;
    private View mSwipeInMsgView;
    private View mSwipeOutMsgView;
    private P mSwipeOption;
    private Q mSwipeDecor;
    private boolean mHasInterceptedEvent = false;
    private int mOriginalLeftMargin;
    private int mOriginalTopMargin;
    private float mTransXToRestore;
    private float mTransYToRestore;

    protected SwipeViewBinder(T resolver, int layoutId, boolean nullable) {
        super(resolver, layoutId, nullable);
    }

    protected void bindView(V promptsView, int position, int swipeType, Q decor, P swipeOption, SwipeCallback<SwipeViewBinder<T, V, P, Q>> callback) {
        this.mLayoutView = promptsView;
        this.mSwipeType = swipeType;
        this.mSwipeOption = swipeOption;
        this.mSwipeDecor = decor;
        this.mCallback = callback;
        this.bindSwipeView(promptsView);
        this.bindViews(this.getResolver(), promptsView);
        this.bindViewPosition(this.getResolver(), position);
        this.resolveView(this.getResolver());
    }

    protected void setOnTouch() {
        this.bindClick(this.getResolver(), this.getLayoutView());
        this.bindLongClick(this.getResolver(), this.getLayoutView());
        this.bindSwipeHead(this.getResolver());
        switch (this.mSwipeType) {
            case 1: {
                this.setDefaultTouchListener(this.mLayoutView);
                break;
            }
            case 2: {
                this.setHorizontalTouchListener(this.mLayoutView);
                break;
            }
            case 3: {
                this.setVerticalTouchListener(this.mLayoutView);
            }
        }
    }

    protected void setAnimatorListener() {
        this.mViewRemoveAnimatorListener = new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (SwipeViewBinder.this.mSwipeOption.getIsPutBackActive()) {
                    SwipeViewBinder.this.mLayoutView.animate().translationX(SwipeViewBinder.this.mTransXToRestore).translationY(SwipeViewBinder.this.mTransYToRestore).setInterpolator((TimeInterpolator)new AccelerateInterpolator(SwipeViewBinder.this.mSwipeDecor.getSwipeAnimFactor())).setDuration((long)SwipeViewBinder.this.mSwipeDecor.getSwipeAnimTime()).setListener(SwipeViewBinder.this.mViewPutBackAnimatorListener).start();
                } else if (SwipeViewBinder.this.mCallback != null) {
                    SwipeViewBinder.this.mCallback.onRemoveView(SwipeViewBinder.this);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        };
        this.mViewRestoreAnimatorListener = new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                if (SwipeViewBinder.this.mCallback != null) {
                    SwipeViewBinder.this.mCallback.onResetView(SwipeViewBinder.this);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        };
        this.mViewPutBackAnimatorListener = new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                SwipeViewBinder.this.animateSwipeRestore((View)SwipeViewBinder.this.mLayoutView, SwipeViewBinder.this.mOriginalTopMargin, SwipeViewBinder.this.mOriginalLeftMargin, SwipeViewBinder.this.mSwipeType);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        };
    }

    protected void setDefaultTouchListener(V view) {
        this.setAnimatorListener();
        final DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        FrameLayout.LayoutParams layoutParamsOriginal = (FrameLayout.LayoutParams)view.getLayoutParams();
        this.mOriginalLeftMargin = layoutParamsOriginal.leftMargin;
        this.mOriginalTopMargin = layoutParamsOriginal.topMargin;
        this.mTransXToRestore = view.getTranslationX();
        this.mTransYToRestore = view.getTranslationY();
        view.setOnTouchListener(new View.OnTouchListener((SwipePlaceHolderView.FrameView)((Object)view)){
            private float dx;
            private float dy;
            private int activePointerId = -1;
            private boolean resetDone = false;
            private PointF pointerCurrentPoint = new PointF();
            private PointF pointerStartingPoint = new PointF();
            final /* synthetic */ SwipePlaceHolderView.FrameView val$view;
            {
                this.val$view = frameView;
            }

            public boolean onTouch(View v, MotionEvent event) {
                if (SwipeViewBinder.this.mSwipeOption.getIsTouchSwipeLocked()) {
                    if (SwipeViewBinder.this.mSwipeOption.getIsViewToRestoreOnTouchLock()) {
                        SwipeViewBinder.this.mSwipeOption.setIsViewToRestoreOnTouchLock(false);
                        SwipeViewBinder.this.animateSwipeRestore(v, SwipeViewBinder.this.mOriginalTopMargin, SwipeViewBinder.this.mOriginalLeftMargin, SwipeViewBinder.this.mSwipeType);
                    }
                    return true;
                }
                if (SwipeViewBinder.this.mSwipeOption.getIsViewLocked()) {
                    if (SwipeViewBinder.this.mSwipeOption.getIsViewToRestoredOnLock()) {
                        SwipeViewBinder.this.mSwipeOption.setIsViewToRestoredOnLock(false);
                        SwipeViewBinder.this.animateSwipeRestore(v, SwipeViewBinder.this.mOriginalTopMargin, SwipeViewBinder.this.mOriginalLeftMargin, SwipeViewBinder.this.mSwipeType);
                    }
                    return true;
                }
                if (!SwipeViewBinder.this.mHasInterceptedEvent) {
                    this.pointerStartingPoint.set(event.getRawX(), event.getRawY());
                    this.pointerCurrentPoint.set(event.getRawX(), event.getRawY());
                    this.activePointerId = event.getPointerId(0);
                    this.resetDone = false;
                    FrameLayout.LayoutParams layoutParamsOriginal = (FrameLayout.LayoutParams)v.getLayoutParams();
                    this.dx = this.pointerCurrentPoint.x - (float)layoutParamsOriginal.leftMargin;
                    this.dy = this.pointerCurrentPoint.y - (float)layoutParamsOriginal.topMargin;
                    SwipeViewBinder.this.mHasInterceptedEvent = true;
                }
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        break;
                    }
                    case 6: {
                        if (event.getPointerId(event.getActionIndex()) != this.activePointerId || this.resetDone) break;
                    }
                    case 1: {
                        if (this.resetDone) break;
                        float distSlideX = this.pointerCurrentPoint.x - this.dx;
                        float distSlideY = this.pointerCurrentPoint.y - this.dy;
                        distSlideX = distSlideX < 0.0f ? -distSlideX : distSlideX;
                        float f = distSlideY = distSlideY < 0.0f ? -distSlideY : distSlideY;
                        if (distSlideX < (float)displayMetrics.widthPixels / SwipeViewBinder.this.mSwipeOption.getWidthSwipeDistFactor() && distSlideY < (float)displayMetrics.heightPixels / SwipeViewBinder.this.mSwipeOption.getHeightSwipeDistFactor()) {
                            SwipeViewBinder.this.animateSwipeRestore(v, SwipeViewBinder.this.mOriginalTopMargin, SwipeViewBinder.this.mOriginalLeftMargin, SwipeViewBinder.this.mSwipeType);
                        } else {
                            if (!SwipeViewBinder.this.mSwipeOption.getIsPutBackActive()) {
                                SwipeViewBinder.this.blockTouch();
                            }
                            float transX = displayMetrics.widthPixels;
                            float transY = displayMetrics.heightPixels;
                            if (this.pointerCurrentPoint.x >= this.pointerStartingPoint.x && this.pointerCurrentPoint.y >= this.pointerStartingPoint.y) {
                                SwipeViewBinder.this.bindSwipeIn(SwipeViewBinder.this.getResolver());
                            } else if (this.pointerCurrentPoint.x > this.pointerStartingPoint.x && this.pointerCurrentPoint.y < this.pointerStartingPoint.y) {
                                transY = -v.getHeight();
                                SwipeViewBinder.this.bindSwipeIn(SwipeViewBinder.this.getResolver());
                            } else if (this.pointerCurrentPoint.x < this.pointerStartingPoint.x && this.pointerCurrentPoint.y >= this.pointerStartingPoint.y) {
                                transX = -v.getWidth();
                                SwipeViewBinder.this.bindSwipeOut(SwipeViewBinder.this.getResolver());
                            } else if (this.pointerCurrentPoint.x <= this.pointerStartingPoint.x && this.pointerCurrentPoint.y < this.pointerStartingPoint.y) {
                                transY = -v.getHeight();
                                transX = -v.getWidth();
                                SwipeViewBinder.this.bindSwipeOut(SwipeViewBinder.this.getResolver());
                            }
                            this.val$view.animate().translationX(transX).translationY(transY).setInterpolator((TimeInterpolator)new AccelerateInterpolator(SwipeViewBinder.this.mSwipeDecor.getSwipeAnimFactor())).setDuration((long)((double)SwipeViewBinder.this.mSwipeDecor.getSwipeAnimTime() * 1.25)).setListener(SwipeViewBinder.this.mViewRemoveAnimatorListener).start();
                        }
                        new CountDownTimer(SwipeViewBinder.this.mSwipeDecor.getSwipeAnimTime(), SwipeViewBinder.this.mSwipeDecor.getSwipeAnimTime()){

                            public void onTick(long millisUntilFinished) {
                            }

                            public void onFinish() {
                                SwipeViewBinder.this.mHasInterceptedEvent = false;
                            }
                        }.start();
                        this.resetDone = true;
                        break;
                    }
                    case 2: {
                        if (this.resetDone || event.findPointerIndex(this.activePointerId) == -1) break;
                        this.pointerCurrentPoint.set(event.getRawX(), event.getRawY());
                        FrameLayout.LayoutParams layoutParamsTemp = (FrameLayout.LayoutParams)v.getLayoutParams();
                        layoutParamsTemp.topMargin = (int)(this.pointerCurrentPoint.y - this.dy);
                        layoutParamsTemp.leftMargin = (int)(this.pointerCurrentPoint.x - this.dx);
                        v.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTemp);
                        int distanceMovedTop = layoutParamsTemp.topMargin - SwipeViewBinder.this.mOriginalTopMargin;
                        int distanceMovedLeft = layoutParamsTemp.leftMargin - SwipeViewBinder.this.mOriginalLeftMargin;
                        SwipeViewBinder.this.mCallback.onAnimateView(distanceMovedLeft, distanceMovedTop, (float)displayMetrics.widthPixels / SwipeViewBinder.this.mSwipeOption.getWidthSwipeDistFactor(), (float)displayMetrics.heightPixels / SwipeViewBinder.this.mSwipeOption.getHeightSwipeDistFactor(), SwipeViewBinder.this);
                    }
                }
                return true;
            }
        });
    }

    protected void setHorizontalTouchListener(V view) {
        this.setAnimatorListener();
        final DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        FrameLayout.LayoutParams layoutParamsOriginal = (FrameLayout.LayoutParams)view.getLayoutParams();
        this.mOriginalLeftMargin = layoutParamsOriginal.leftMargin;
        this.mOriginalTopMargin = layoutParamsOriginal.topMargin;
        this.mTransXToRestore = view.getTranslationX();
        this.mTransYToRestore = view.getTranslationY();
        view.setOnTouchListener(new View.OnTouchListener((SwipePlaceHolderView.FrameView)((Object)view)){
            private float xStart;
            private float x;
            private float dx;
            private int activePointerId = -1;
            private boolean resetDone = false;
            final /* synthetic */ SwipePlaceHolderView.FrameView val$view;
            {
                this.val$view = frameView;
            }

            public boolean onTouch(View v, MotionEvent event) {
                if (SwipeViewBinder.this.mSwipeOption.getIsTouchSwipeLocked()) {
                    if (SwipeViewBinder.this.mSwipeOption.getIsViewToRestoreOnTouchLock()) {
                        SwipeViewBinder.this.mSwipeOption.setIsViewToRestoreOnTouchLock(false);
                        SwipeViewBinder.this.animateSwipeRestore(v, SwipeViewBinder.this.mOriginalTopMargin, SwipeViewBinder.this.mOriginalLeftMargin, SwipeViewBinder.this.mSwipeType);
                    }
                    return true;
                }
                if (SwipeViewBinder.this.mSwipeOption.getIsViewLocked()) {
                    if (SwipeViewBinder.this.mSwipeOption.getIsViewToRestoredOnLock()) {
                        SwipeViewBinder.this.mSwipeOption.setIsViewToRestoredOnLock(false);
                        SwipeViewBinder.this.animateSwipeRestore(v, SwipeViewBinder.this.mOriginalTopMargin, SwipeViewBinder.this.mOriginalLeftMargin, SwipeViewBinder.this.mSwipeType);
                    }
                    return true;
                }
                if (!SwipeViewBinder.this.mHasInterceptedEvent) {
                    this.xStart = event.getRawX();
                    this.x = event.getRawX();
                    this.activePointerId = event.getPointerId(0);
                    this.resetDone = false;
                    FrameLayout.LayoutParams layoutParamsCurrent = (FrameLayout.LayoutParams)v.getLayoutParams();
                    this.dx = this.x - (float)layoutParamsCurrent.leftMargin;
                    SwipeViewBinder.this.mHasInterceptedEvent = true;
                }
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        break;
                    }
                    case 6: {
                        if (event.getPointerId(event.getActionIndex()) != this.activePointerId || this.resetDone) break;
                    }
                    case 1: {
                        if (this.resetDone) break;
                        float distSlideX = this.x - this.dx;
                        float f = distSlideX = distSlideX < 0.0f ? -distSlideX : distSlideX;
                        if (distSlideX < (float)displayMetrics.widthPixels / SwipeViewBinder.this.mSwipeOption.getWidthSwipeDistFactor()) {
                            SwipeViewBinder.this.animateSwipeRestore(v, SwipeViewBinder.this.mOriginalTopMargin, SwipeViewBinder.this.mOriginalLeftMargin, SwipeViewBinder.this.mSwipeType);
                        } else {
                            if (!SwipeViewBinder.this.mSwipeOption.getIsPutBackActive()) {
                                SwipeViewBinder.this.blockTouch();
                            }
                            float transX = displayMetrics.widthPixels;
                            if (this.x < this.xStart) {
                                transX = -v.getWidth();
                                SwipeViewBinder.this.bindSwipeOut(SwipeViewBinder.this.getResolver());
                            } else {
                                SwipeViewBinder.this.bindSwipeIn(SwipeViewBinder.this.getResolver());
                            }
                            this.val$view.animate().translationX(transX).setInterpolator((TimeInterpolator)new AccelerateInterpolator(SwipeViewBinder.this.mSwipeDecor.getSwipeAnimFactor())).setDuration((long)((double)SwipeViewBinder.this.mSwipeDecor.getSwipeAnimTime() * 1.25)).setListener(SwipeViewBinder.this.mViewRemoveAnimatorListener).start();
                        }
                        new CountDownTimer(SwipeViewBinder.this.mSwipeDecor.getSwipeAnimTime(), SwipeViewBinder.this.mSwipeDecor.getSwipeAnimTime()){

                            public void onTick(long millisUntilFinished) {
                            }

                            public void onFinish() {
                                SwipeViewBinder.this.mHasInterceptedEvent = false;
                            }
                        }.start();
                        this.resetDone = true;
                        break;
                    }
                    case 2: {
                        if (this.resetDone || event.findPointerIndex(this.activePointerId) == -1) break;
                        this.x = event.getRawX();
                        FrameLayout.LayoutParams layoutParamsTemp = (FrameLayout.LayoutParams)v.getLayoutParams();
                        layoutParamsTemp.leftMargin = (int)(this.x - this.dx);
                        v.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTemp);
                        int distanceMoved = layoutParamsTemp.leftMargin - SwipeViewBinder.this.mOriginalLeftMargin;
                        SwipeViewBinder.this.mCallback.onAnimateView(distanceMoved, 0.0f, (float)displayMetrics.widthPixels / SwipeViewBinder.this.mSwipeOption.getWidthSwipeDistFactor(), (float)displayMetrics.heightPixels / SwipeViewBinder.this.mSwipeOption.getHeightSwipeDistFactor(), SwipeViewBinder.this);
                    }
                }
                return true;
            }
        });
    }

    protected void setVerticalTouchListener(V view) {
        this.setAnimatorListener();
        final DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        FrameLayout.LayoutParams layoutParamsOriginal = (FrameLayout.LayoutParams)view.getLayoutParams();
        this.mOriginalLeftMargin = layoutParamsOriginal.leftMargin;
        this.mOriginalTopMargin = layoutParamsOriginal.topMargin;
        this.mTransXToRestore = view.getTranslationX();
        this.mTransYToRestore = view.getTranslationY();
        view.setOnTouchListener(new View.OnTouchListener((SwipePlaceHolderView.FrameView)((Object)view)){
            private float yStart;
            private float y;
            private float dy;
            private int activePointerId = -1;
            private boolean resetDone = false;
            final /* synthetic */ SwipePlaceHolderView.FrameView val$view;
            {
                this.val$view = frameView;
            }

            public boolean onTouch(View v, MotionEvent event) {
                if (SwipeViewBinder.this.mSwipeOption.getIsTouchSwipeLocked()) {
                    if (SwipeViewBinder.this.mSwipeOption.getIsViewToRestoreOnTouchLock()) {
                        SwipeViewBinder.this.mSwipeOption.setIsViewToRestoreOnTouchLock(false);
                        SwipeViewBinder.this.animateSwipeRestore(v, SwipeViewBinder.this.mOriginalTopMargin, SwipeViewBinder.this.mOriginalLeftMargin, SwipeViewBinder.this.mSwipeType);
                    }
                    return true;
                }
                if (SwipeViewBinder.this.mSwipeOption.getIsViewLocked()) {
                    if (SwipeViewBinder.this.mSwipeOption.getIsViewToRestoredOnLock()) {
                        SwipeViewBinder.this.mSwipeOption.setIsViewToRestoredOnLock(false);
                        SwipeViewBinder.this.animateSwipeRestore(v, SwipeViewBinder.this.mOriginalTopMargin, SwipeViewBinder.this.mOriginalLeftMargin, SwipeViewBinder.this.mSwipeType);
                    }
                    return true;
                }
                if (!SwipeViewBinder.this.mHasInterceptedEvent) {
                    this.yStart = event.getRawY();
                    this.y = event.getRawY();
                    this.activePointerId = event.getPointerId(0);
                    this.resetDone = false;
                    FrameLayout.LayoutParams layoutParamsOriginal = (FrameLayout.LayoutParams)v.getLayoutParams();
                    this.dy = this.y - (float)layoutParamsOriginal.topMargin;
                    SwipeViewBinder.this.mHasInterceptedEvent = true;
                }
                switch (event.getAction() & 0xFF) {
                    case 0: {
                        break;
                    }
                    case 6: {
                        if (event.getPointerId(event.getActionIndex()) != this.activePointerId || this.resetDone) break;
                    }
                    case 1: {
                        if (this.resetDone) break;
                        float distSlideY = this.y - this.dy;
                        float f = distSlideY = distSlideY < 0.0f ? -distSlideY : distSlideY;
                        if (distSlideY < (float)displayMetrics.heightPixels / SwipeViewBinder.this.mSwipeOption.getHeightSwipeDistFactor()) {
                            SwipeViewBinder.this.animateSwipeRestore(v, SwipeViewBinder.this.mOriginalTopMargin, SwipeViewBinder.this.mOriginalLeftMargin, SwipeViewBinder.this.mSwipeType);
                        } else {
                            if (!SwipeViewBinder.this.mSwipeOption.getIsPutBackActive()) {
                                SwipeViewBinder.this.blockTouch();
                            }
                            float transY = displayMetrics.heightPixels;
                            if (this.y < this.yStart) {
                                transY = -v.getHeight();
                                SwipeViewBinder.this.bindSwipeOut(SwipeViewBinder.this.getResolver());
                            } else {
                                SwipeViewBinder.this.bindSwipeIn(SwipeViewBinder.this.getResolver());
                            }
                            this.val$view.animate().translationY(transY).setInterpolator((TimeInterpolator)new AccelerateInterpolator(SwipeViewBinder.this.mSwipeDecor.getSwipeAnimFactor())).setDuration((long)((double)SwipeViewBinder.this.mSwipeDecor.getSwipeAnimTime() * 1.25)).setListener(SwipeViewBinder.this.mViewRemoveAnimatorListener).start();
                        }
                        new CountDownTimer(SwipeViewBinder.this.mSwipeDecor.getSwipeAnimTime(), SwipeViewBinder.this.mSwipeDecor.getSwipeAnimTime()){

                            public void onTick(long millisUntilFinished) {
                            }

                            public void onFinish() {
                                SwipeViewBinder.this.mHasInterceptedEvent = false;
                            }
                        }.start();
                        this.resetDone = true;
                        break;
                    }
                    case 2: {
                        if (this.resetDone || event.findPointerIndex(this.activePointerId) == -1) break;
                        this.y = event.getRawY();
                        FrameLayout.LayoutParams layoutParamsTemp = (FrameLayout.LayoutParams)v.getLayoutParams();
                        layoutParamsTemp.topMargin = (int)(this.y - this.dy);
                        v.setLayoutParams((ViewGroup.LayoutParams)layoutParamsTemp);
                        int distanceMoved = layoutParamsTemp.topMargin - SwipeViewBinder.this.mOriginalTopMargin;
                        SwipeViewBinder.this.mCallback.onAnimateView(0.0f, distanceMoved, (float)displayMetrics.widthPixels / SwipeViewBinder.this.mSwipeOption.getWidthSwipeDistFactor(), (float)displayMetrics.heightPixels / SwipeViewBinder.this.mSwipeOption.getHeightSwipeDistFactor(), SwipeViewBinder.this);
                    }
                }
                return true;
            }
        });
    }

    protected void blockTouch() {
        this.mLayoutView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent rawEvent) {
                return true;
            }
        });
    }

    protected void animateSwipeRestore(final View v, int originalTopMargin, int originalLeftMargin, int swipeType) {
        final FrameLayout.LayoutParams layoutParamsFinal = (FrameLayout.LayoutParams)v.getLayoutParams();
        ValueAnimator animatorX = null;
        ValueAnimator animatorY = null;
        int animTime = ((SwipeDecor)this.mSwipeDecor).getSwipeAnimTime();
        DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator(((SwipeDecor)this.mSwipeDecor).getSwipeAnimFactor());
        ViewPropertyAnimator animatorR = v.animate().rotation(0.0f).setInterpolator((TimeInterpolator)decelerateInterpolator).setDuration((long)animTime).setListener(this.mViewRestoreAnimatorListener);
        if (swipeType == 1 || swipeType == 2) {
            animatorX = ValueAnimator.ofInt((int[])new int[]{layoutParamsFinal.leftMargin, originalLeftMargin});
            animatorX.setInterpolator((TimeInterpolator)decelerateInterpolator);
            animatorX.setDuration((long)animTime);
            animatorX.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    layoutParamsFinal.leftMargin = (Integer)valueAnimator.getAnimatedValue();
                    v.setLayoutParams((ViewGroup.LayoutParams)layoutParamsFinal);
                }
            });
        }
        if (swipeType == 1 || swipeType == 3) {
            animatorY = ValueAnimator.ofInt((int[])new int[]{layoutParamsFinal.topMargin, originalTopMargin});
            animatorY.setInterpolator((TimeInterpolator)decelerateInterpolator);
            animatorY.setDuration((long)animTime);
            animatorY.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    layoutParamsFinal.topMargin = (Integer)valueAnimator.getAnimatedValue();
                    v.setLayoutParams((ViewGroup.LayoutParams)layoutParamsFinal);
                }
            });
        }
        if (animatorX != null) {
            animatorX.start();
        }
        if (animatorY != null) {
            animatorY.start();
        }
        animatorR.start();
    }

    protected void doSwipe(boolean isSwipeIn) {
        if (this.mLayoutView != null && this.mViewRemoveAnimatorListener != null && !((SwipePlaceHolderView.SwipeOption)this.mSwipeOption).getIsViewLocked()) {
            if (!((SwipePlaceHolderView.SwipeOption)this.mSwipeOption).getIsPutBackActive()) {
                this.blockTouch();
            }
            if (isSwipeIn) {
                if (this.getSwipeInMsgView() != null) {
                    this.getSwipeInMsgView().setVisibility(0);
                }
            } else if (this.getSwipeOutMsgView() != null) {
                this.getSwipeOutMsgView().setVisibility(0);
            }
            DisplayMetrics displayMetrics = this.mLayoutView.getResources().getDisplayMetrics();
            ViewPropertyAnimator animator = this.mLayoutView.animate();
            float transX = displayMetrics.widthPixels;
            float transY = displayMetrics.heightPixels;
            switch (this.mSwipeType) {
                case 1: {
                    if (isSwipeIn) {
                        this.bindSwipeIn(this.getResolver());
                        animator.rotation((float)(-((SwipeDecor)this.mSwipeDecor).getSwipeRotationAngle()));
                    } else {
                        this.bindSwipeOut(this.getResolver());
                        transX = -this.mLayoutView.getWidth();
                        animator.rotation((float)((SwipeDecor)this.mSwipeDecor).getSwipeRotationAngle());
                    }
                    animator.translationX(transX).translationY(transY);
                    break;
                }
                case 2: {
                    if (isSwipeIn) {
                        this.bindSwipeIn(this.getResolver());
                    } else {
                        this.bindSwipeOut(this.getResolver());
                        transX = -this.mLayoutView.getWidth();
                    }
                    animator.translationX(transX);
                    break;
                }
                case 3: {
                    if (isSwipeIn) {
                        this.bindSwipeIn(this.getResolver());
                    } else {
                        this.bindSwipeOut(this.getResolver());
                        transY = -this.mLayoutView.getHeight();
                    }
                    animator.translationY(transY);
                }
            }
            animator.setDuration((long)((double)((SwipeDecor)this.mSwipeDecor).getSwipeAnimTime() * 1.25)).setInterpolator((TimeInterpolator)new AccelerateInterpolator(((SwipeDecor)this.mSwipeDecor).getSwipeAnimFactor())).setListener(this.mViewRemoveAnimatorListener).start();
        }
    }

    protected View getSwipeInMsgView() {
        return this.mSwipeInMsgView;
    }

    protected void setSwipeInMsgView(View swipeInMsgView) {
        this.mSwipeInMsgView = swipeInMsgView;
    }

    protected View getSwipeOutMsgView() {
        return this.mSwipeOutMsgView;
    }

    protected void setSwipeOutMsgView(View swipeOutMsgView) {
        this.mSwipeOutMsgView = swipeOutMsgView;
    }

    protected V getLayoutView() {
        return this.mLayoutView;
    }

    protected SwipeCallback getCallback() {
        return this.mCallback;
    }

    protected int getSwipeType() {
        return this.mSwipeType;
    }

    protected P getSwipeOption() {
        return this.mSwipeOption;
    }

    protected Q getSwipeDecor() {
        return this.mSwipeDecor;
    }

    protected Animator.AnimatorListener getViewRemoveAnimatorListener() {
        return this.mViewRemoveAnimatorListener;
    }

    protected Animator.AnimatorListener getViewRestoreAnimatorListener() {
        return this.mViewRestoreAnimatorListener;
    }

    protected Animator.AnimatorListener getViewPutBackAnimatorListener() {
        return this.mViewPutBackAnimatorListener;
    }

    public int getFinalLeftMargin() {
        return mFinalLeftMargin;
    }

    public void setFinalLeftMargin(int finalLeftMargin) {
        mFinalLeftMargin = finalLeftMargin;
    }

    public int getFinalTopMargin() {
        return mFinalTopMargin;
    }

    public void setFinalTopMargin(int finalTopMargin) {
        mFinalTopMargin = finalTopMargin;
    }

    protected void doUndoAnimation() {
        if (((SwipePlaceHolderView.SwipeOption)this.mSwipeOption).isUndoEnabled()) {
            final FrameLayout.LayoutParams layoutParamsFinal = (FrameLayout.LayoutParams)this.getLayoutView().getLayoutParams();
            layoutParamsFinal.leftMargin = this.getFinalLeftMargin();
            layoutParamsFinal.topMargin = this.getFinalTopMargin();
            ValueAnimator animatorX = null;
            ValueAnimator animatorY = null;
            int animTime = ((SwipeDecor)this.mSwipeDecor).getSwipeAnimTime();
            DecelerateInterpolator decelerateInterpolator = new DecelerateInterpolator(((SwipeDecor)this.mSwipeDecor).getSwipeAnimFactor());
            ViewPropertyAnimator animatorR = this.getLayoutView().animate().rotation(0.0f).setInterpolator((TimeInterpolator)decelerateInterpolator).setDuration((long)animTime);
            if (this.mSwipeType == 1 || this.mSwipeType == 2) {
                animatorX = ValueAnimator.ofInt((int[])new int[]{layoutParamsFinal.leftMargin, this.mOriginalLeftMargin});
                animatorX.setInterpolator((TimeInterpolator)decelerateInterpolator);
                animatorX.setDuration((long)animTime);
                animatorX.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        layoutParamsFinal.leftMargin = (Integer)valueAnimator.getAnimatedValue();
                        SwipeViewBinder.this.getLayoutView().setLayoutParams((ViewGroup.LayoutParams)layoutParamsFinal);
                    }
                });
            }
            if (this.mSwipeType == 1 || this.mSwipeType == 3) {
                animatorY = ValueAnimator.ofInt((int[])new int[]{layoutParamsFinal.topMargin, this.mOriginalTopMargin});
                animatorY.setInterpolator((TimeInterpolator)decelerateInterpolator);
                animatorY.setDuration((long)animTime);
                animatorY.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator valueAnimator) {
                        layoutParamsFinal.topMargin = (Integer)valueAnimator.getAnimatedValue();
                        SwipeViewBinder.this.getLayoutView().setLayoutParams((ViewGroup.LayoutParams)layoutParamsFinal);
                    }
                });
            }
            if (animatorX != null) {
                animatorX.start();
            }
            if (animatorY != null) {
                animatorY.start();
            }
            animatorR.start();
        }
    }

    protected abstract void bindSwipeView(V var1);

    protected abstract void bindSwipeIn(T var1);

    protected abstract void bindSwipeOut(T var1);

    protected abstract void bindSwipeInState();

    protected abstract void bindSwipeOutState();

    protected abstract void bindSwipeCancelState();

    protected abstract void bindSwipeHead(T var1);

    protected static interface SwipeCallback<T extends SwipeViewBinder<?, ? extends FrameLayout, ? extends SwipePlaceHolderView.SwipeOption, ? extends SwipeDecor>> {
        public void onRemoveView(T var1);

        public void onResetView(T var1);

        public void onAnimateView(float var1, float var2, float var3, float var4, T var5);
    }
}

