/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.View;
import com.mindorks.placeholderview.ExpandableViewAdapter;
import com.mindorks.placeholderview.ExpandableViewBinder;
import com.mindorks.placeholderview.PlaceHolderView;
import com.mindorks.placeholderview.PlaceHolderViewBuilder;
import com.mindorks.placeholderview.ViewAdapter;
import com.mindorks.placeholderview.ViewBinder;
import java.util.ArrayList;

public class ExpandablePlaceHolderView
extends PlaceHolderView {
    public ExpandablePlaceHolderView(Context context) {
        super(context);
        this.setupView(context, new ExpandableViewAdapter(context), new PlaceHolderViewBuilder(context, this));
    }

    public ExpandablePlaceHolderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupView(context, new ExpandableViewAdapter(context), new PlaceHolderViewBuilder(context, this));
    }

    public ExpandablePlaceHolderView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setupView(context, new ExpandableViewAdapter(context), new PlaceHolderViewBuilder(context, this));
    }

    @Override
    protected void setupView(Context context, ViewAdapter viewAdapter, PlaceHolderViewBuilder builder) {
        super.setupView(context, viewAdapter, builder);
    }

    public <T> PlaceHolderView addChildView(T parentResolver, T childResolver) throws Resources.NotFoundException {
        ((ExpandableViewAdapter)this.getViewAdapter()).addChildView(parentResolver, childResolver);
        return this;
    }

    public <T> PlaceHolderView addChildView(int parentPosition, T childResolver) throws Resources.NotFoundException {
        ((ExpandableViewAdapter)this.getViewAdapter()).addChildView(parentPosition, childResolver);
        return this;
    }

    @Override
    @Deprecated
    public <T> PlaceHolderView addView(int position, T viewResolver) throws IndexOutOfBoundsException {
        return super.addView(position, viewResolver);
    }

    @Override
    @Deprecated
    public <T> PlaceHolderView addViewBefore(T resolverOld, T resolverNew) throws Resources.NotFoundException {
        return super.addViewBefore(resolverOld, resolverNew);
    }

    @Override
    @Deprecated
    public <T> PlaceHolderView addViewAfter(T resolverOld, T resolverNew) throws Resources.NotFoundException {
        return super.addViewAfter(resolverOld, resolverNew);
    }

    public <T> void expand(T resolver) throws Resources.NotFoundException {
        this.toggle(resolver, true);
    }

    public void expand(int position) throws Resources.NotFoundException {
        this.toggle(position, true);
    }

    public <T> void collapse(T resolver) throws Resources.NotFoundException {
        this.toggle(resolver, false);
    }

    public void collapse(int position) throws Resources.NotFoundException {
        this.toggle(position, false);
    }

    public void collapseAll() {
        ArrayList<ExpandableViewBinder> parentBinderList = new ArrayList<ExpandableViewBinder>();
        for (ViewBinder<Object, View> viewBinder : this.getViewAdapter().getViewBinderList()) {
            ExpandableViewBinder binder = (ExpandableViewBinder)viewBinder;
            if (!binder.isParent()) continue;
            parentBinderList.add(binder);
        }
        for (ExpandableViewBinder binder : parentBinderList) {
            binder.collapse();
        }
    }

    protected <T> void toggle(T resolver, boolean isToExpand) throws Resources.NotFoundException {
        ExpandableViewBinder<T, View> binder = ((ExpandableViewAdapter)this.getViewAdapter()).getBinderForResolver(resolver);
        if (resolver == null) {
            throw new Resources.NotFoundException("Parent view don't exists in the ExpandablePlaceHolderView");
        }
        if (isToExpand) {
            binder.expand();
        } else {
            binder.collapse();
        }
    }

    protected void toggle(int position, boolean isToExpand) throws Resources.NotFoundException {
        ExpandableViewBinder binder = ((ExpandableViewAdapter)this.getViewAdapter()).getParentBinderAtPosition(position);
        if (binder == null) {
            throw new Resources.NotFoundException("Parent view don't exists in the ExpandablePlaceHolderView");
        }
        if (isToExpand) {
            binder.expand();
        } else {
            binder.collapse();
        }
    }
}

