/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import com.mindorks.placeholderview.ExpandableViewBinder;
import com.mindorks.placeholderview.ViewAdapter;
import com.mindorks.placeholderview.core.ViewBinder;
import java.util.ArrayList;

public class ExpandableViewAdapter<T>
extends ViewAdapter<T>
implements ExpandableViewBinder.ExpansionCallback<T> {
    private ExpandableViewBinder<T, View> mParentBinder;

    public ExpandableViewAdapter(Context context) {
        super(context);
    }

    @Override
    protected void addView(T viewResolver) throws IndexOutOfBoundsException {
        ExpandableViewBinder<T, View> expandableViewBinder = new ExpandableViewBinder<T, View>(viewResolver);
        if (expandableViewBinder.bindViewType()) {
            expandableViewBinder.setCallback(this);
            this.mParentBinder = expandableViewBinder;
            this.getViewBinderList().add(this.mParentBinder);
            this.mParentBinder.bindParentPosition(this.getParentPosition(this.mParentBinder));
            this.notifyItemInserted(this.getViewBinderList().size() - 1);
        } else {
            if (this.mParentBinder == null) {
                this.mParentBinder = this.getLastParentBinder();
            }
            if (this.mParentBinder != null) {
                this.mParentBinder.getChildList().add(expandableViewBinder);
                expandableViewBinder.setParentViewBinder(this.mParentBinder);
                expandableViewBinder.bindParentPosition(this.getParentPosition(this.mParentBinder));
                expandableViewBinder.bindChildPosition(this.getChildPosition(this.mParentBinder, expandableViewBinder));
            }
        }
    }

    protected void addChildView(T parentResolver, T childResolver) throws Resources.NotFoundException {
        ExpandableViewBinder<T, View> parentBinder = this.getBinderForResolver(parentResolver);
        if (parentBinder != null && parentBinder.isParent()) {
            ExpandableViewBinder<T, View> childViewBinder = new ExpandableViewBinder<T, View>(childResolver);
            parentBinder.getChildList().add(childViewBinder);
            if (parentBinder.isExpanded()) {
                int position = this.getViewBinderList().indexOf(parentBinder) + parentBinder.getChildList().size();
                this.getViewBinderList().add(position, childViewBinder);
                childViewBinder.setParentViewBinder(parentBinder);
                childViewBinder.bindParentPosition(this.getParentPosition(parentBinder));
                childViewBinder.bindChildPosition(this.getChildPosition(parentBinder, childViewBinder));
                this.notifyItemInserted(position);
            }
        }
    }

    protected void addChildView(int parentPosition, T childResolver) throws Resources.NotFoundException {
        for (ViewBinder viewBinder : this.getViewBinderList()) {
            ExpandableViewBinder parentBinder = (ExpandableViewBinder)viewBinder;
            if (!parentBinder.isParent() || parentBinder.getParentPosition() != parentPosition) continue;
            ExpandableViewBinder childViewBinder = new ExpandableViewBinder(childResolver);
            parentBinder.getChildList().add(childViewBinder);
            if (!parentBinder.isExpanded()) break;
            int position = this.getViewBinderList().indexOf((Object)parentBinder) + parentBinder.getChildList().size();
            this.getViewBinderList().add(position, childViewBinder);
            childViewBinder.setParentViewBinder(parentBinder);
            childViewBinder.bindParentPosition(this.getParentPosition(parentBinder));
            childViewBinder.bindChildPosition(this.getChildPosition(parentBinder, childViewBinder));
            this.notifyItemInserted(position);
            break;
        }
    }

    @Override
    protected void addView(int position, T viewResolver) throws IndexOutOfBoundsException {
    }

    @Override
    protected void addView(T resolverOld, T resolverNew, boolean after) throws Resources.NotFoundException {
    }

    @Override
    protected void removeView(T viewResolver) throws IndexOutOfBoundsException {
        ExpandableViewBinder<T, View> expandableViewBinder = this.getBinderForResolver(viewResolver);
        if (expandableViewBinder != null) {
            if (expandableViewBinder.isParent()) {
                this.onCollapse(expandableViewBinder);
            } else {
                expandableViewBinder.getParentViewBinder().getChildList().remove(expandableViewBinder);
            }
        }
        super.removeView(viewResolver);
    }

    @Override
    protected void removeView(int position) throws IndexOutOfBoundsException {
        ExpandableViewBinder expandableViewBinder = (ExpandableViewBinder)this.getViewBinderList().get(position);
        if (expandableViewBinder != null) {
            if (expandableViewBinder.isParent()) {
                this.onCollapse(expandableViewBinder);
            } else {
                expandableViewBinder.getParentViewBinder().getChildList().remove((Object)expandableViewBinder);
            }
        }
        super.removeView(position);
    }

    @Override
    public void onExpand(ExpandableViewBinder<T, View> parentBinder) {
        int position = this.getViewBinderList().indexOf(parentBinder) + 1;
        for (ExpandableViewBinder<T, View> viewBinder : parentBinder.getChildList()) {
            this.getViewBinderList().add(position, viewBinder);
            this.notifyItemInserted(position);
            ++position;
        }
        if (parentBinder.isSingleTop()) {
            this.collapseOthers(parentBinder);
        }
    }

    @Override
    public void onCollapse(ExpandableViewBinder<T, View> parentBinder) {
        for (ExpandableViewBinder<T, View> viewBinder : parentBinder.getChildList()) {
            super.removeView(viewBinder.getResolver());
        }
    }

    private void collapseOthers(ExpandableViewBinder<T, View> parentBinder) {
        ArrayList<ExpandableViewBinder> expandableViewBinderList = new ArrayList<ExpandableViewBinder>();
        for (ViewBinder viewBinder : this.getViewBinderList()) {
            ExpandableViewBinder expandableViewBinder = (ExpandableViewBinder)viewBinder;
            if (expandableViewBinder == parentBinder) continue;
            expandableViewBinderList.add(expandableViewBinder);
        }
        for (ExpandableViewBinder expandableViewBinder : expandableViewBinderList) {
            expandableViewBinder.collapse();
        }
    }

    private int getParentPosition(ExpandableViewBinder<T, View> parentViewBinder) {
        int position = -1;
        for (ViewBinder viewBinder : this.getViewBinderList()) {
            ExpandableViewBinder expandableViewBinder = (ExpandableViewBinder)viewBinder;
            if (!expandableViewBinder.isParent()) continue;
            if (parentViewBinder == expandableViewBinder) {
                return ++position;
            }
            ++position;
        }
        return position;
    }

    private int getChildPosition(ExpandableViewBinder<T, View> parentViewBinder, ExpandableViewBinder<T, View> childViewBinder) {
        return parentViewBinder.getChildList().indexOf(childViewBinder);
    }

    private ExpandableViewBinder<T, View> getLastParentBinder() {
        for (int i = this.getViewBinderList().size() - 1; i >= 0; --i) {
            ExpandableViewBinder expandableViewBinder = (ExpandableViewBinder)this.getViewBinderList().get(i);
            if (!expandableViewBinder.isParent()) continue;
            return expandableViewBinder;
        }
        return null;
    }

    protected ExpandableViewBinder<T, View> getBinderForResolver(T viewResolver) {
        for (ViewBinder viewBinder : this.getViewBinderList()) {
            ExpandableViewBinder expandableViewBinder = (ExpandableViewBinder)viewBinder;
            if (expandableViewBinder.getResolver() != viewResolver) continue;
            return expandableViewBinder;
        }
        return null;
    }

    protected ExpandableViewBinder<T, View> getParentBinderAtPosition(int position) {
        ExpandableViewBinder parentBinder = null;
        for (ViewBinder viewBinder : this.getViewBinderList()) {
            ExpandableViewBinder expandableViewBinder = (ExpandableViewBinder)viewBinder;
            if (position < 0 || !expandableViewBinder.isParent() || expandableViewBinder.getParentPosition() != position) continue;
            parentBinder = expandableViewBinder;
            break;
        }
        return parentBinder;
    }
}

