/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.view.View;
import com.mindorks.placeholderview.core.ViewBinder;
import com.mindorks.placeholderview.core.annotations.expand.ChildPosition;
import com.mindorks.placeholderview.core.annotations.expand.Collapse;
import com.mindorks.placeholderview.core.annotations.expand.Expand;
import com.mindorks.placeholderview.core.annotations.expand.Parent;
import com.mindorks.placeholderview.core.annotations.expand.ParentPosition;
import com.mindorks.placeholderview.core.annotations.expand.SingleTop;
import com.mindorks.placeholderview.core.annotations.expand.Toggle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ExpandableViewBinder<T, V extends View>
extends ViewBinder<T, V> {
    private boolean isParent = false;
    private boolean isExpanded = false;
    private boolean isSingleTop = false;
    private List<ExpandableViewBinder<T, V>> mChildList;
    private ExpansionCallback mCallback;
    private int mChildPosition;
    private int mParentPosition;
    private ExpandableViewBinder<T, V> mParentViewBinder;

    public ExpandableViewBinder(T resolver) {
        super(resolver);
        this.bindCollapseProperty(resolver);
        this.mChildList = new ArrayList<ExpandableViewBinder<T, V>>();
    }

    protected boolean bindViewType() {
        Object resolver = this.getResolver();
        Parent parent = resolver.getClass().getAnnotation(Parent.class);
        if (parent != null) {
            this.isParent = parent.value();
        }
        return this.isParent;
    }

    protected void bindCollapseProperty(T resolver) {
        SingleTop singleTop = resolver.getClass().getAnnotation(SingleTop.class);
        if (singleTop != null) {
            this.isSingleTop = singleTop.value();
        }
    }

    protected void bindParentPosition(int position) {
        this.mParentPosition = position;
        Object resolver = this.getResolver();
        for (Field field : resolver.getClass().getDeclaredFields()) {
            ParentPosition annotation = field.getAnnotation(ParentPosition.class);
            if (annotation == null) continue;
            try {
                field.setAccessible(true);
                field.set(resolver, position);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    protected void bindChildPosition(int position) {
        this.mChildPosition = position;
        Object resolver = this.getResolver();
        for (Field field : resolver.getClass().getDeclaredFields()) {
            ChildPosition annotation = field.getAnnotation(ChildPosition.class);
            if (annotation == null) continue;
            try {
                field.setAccessible(true);
                field.set(resolver, position);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public void bindView(V promptsView, int position) {
        super.bindView(promptsView, position);
        if (this.isParent) {
            this.bindToggle(this.getResolver(), promptsView);
        }
    }

    private void bindToggle(T resolver, V promptsView) {
        boolean toggleSet = false;
        for (Field field : resolver.getClass().getDeclaredFields()) {
            Toggle toggle = field.getAnnotation(Toggle.class);
            if (toggle == null) continue;
            View view = promptsView.findViewById(toggle.value());
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        if (ExpandableViewBinder.this.isExpanded) {
                            ExpandableViewBinder.this.collapse();
                        } else {
                            ExpandableViewBinder.this.expand();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            toggleSet = true;
        }
        if (!toggleSet) {
            promptsView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        if (ExpandableViewBinder.this.isExpanded) {
                            ExpandableViewBinder.this.collapse();
                        } else {
                            ExpandableViewBinder.this.expand();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private void bindCollapse(T resolver) {
        for (Method method : resolver.getClass().getDeclaredMethods()) {
            Collapse annotation = method.getAnnotation(Collapse.class);
            if (annotation == null) continue;
            try {
                method.setAccessible(true);
                method.invoke(resolver, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void bindExpand(T resolver) {
        for (Method method : resolver.getClass().getDeclaredMethods()) {
            Expand annotation = method.getAnnotation(Expand.class);
            if (annotation == null) continue;
            try {
                method.setAccessible(true);
                method.invoke(resolver, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public void unbind() {
    }

    @Deprecated
    public void bindAnimation(int deviceWidth, int deviceHeight, V view) {
    }

    protected void setCallback(ExpansionCallback callback) {
        this.mCallback = callback;
    }

    protected List<ExpandableViewBinder<T, V>> getChildList() {
        return this.mChildList;
    }

    protected void collapse() {
        if (this.isParent && this.mCallback != null && this.isExpanded) {
            this.mCallback.onCollapse(this);
            this.bindCollapse(this.getResolver());
        }
        this.isExpanded = false;
    }

    protected void expand() {
        if (this.isParent && this.mCallback != null && !this.isExpanded) {
            this.mCallback.onExpand(this);
            this.bindExpand(this.getResolver());
        }
        this.isExpanded = true;
    }

    protected boolean isParent() {
        return this.isParent;
    }

    protected boolean isExpanded() {
        return this.isExpanded;
    }

    protected boolean isSingleTop() {
        return this.isSingleTop;
    }

    protected int getChildPosition() {
        return this.mChildPosition;
    }

    protected int getParentPosition() {
        return this.mParentPosition;
    }

    protected ExpandableViewBinder<T, V> getParentViewBinder() {
        return this.mParentViewBinder;
    }

    protected void setParentViewBinder(ExpandableViewBinder<T, V> mParentViewBinder) {
        this.mParentViewBinder = mParentViewBinder;
    }

    protected static interface ExpansionCallback<T> {
        public void onExpand(ExpandableViewBinder<T, View> var1);

        public void onCollapse(ExpandableViewBinder<T, View> var1);
    }
}

