/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview.widget;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.widget.EditText;

public class RecyclableEditText
extends EditText {
    private OnTextChangeListener mOnTextChangeListener;

    public RecyclableEditText(Context context) {
        super(context);
    }

    public RecyclableEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RecyclableEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        super.onTextChanged(text, start, lengthBefore, lengthAfter);
        if (this.mOnTextChangeListener != null) {
            this.mOnTextChangeListener.onTextChanged(text, start, lengthBefore, lengthAfter);
        }
    }

    public void setTextChangedListener(@NonNull OnTextChangeListener listener) {
        this.mOnTextChangeListener = listener;
    }

    public void removeTextChangedListener() {
        this.mOnTextChangeListener = null;
    }

    public static interface OnTextChangeListener {
        public void onTextChanged(CharSequence var1, int var2, int var3, int var4);
    }
}

