/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.content.Context;
import android.content.res.Resources;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.mindorks.placeholderview.Utils;
import com.mindorks.placeholderview.ViewBinder;
import com.mindorks.placeholderview.ViewHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class ViewAdapter<T>
extends RecyclerView.Adapter<ViewHolder<T, ViewBinder<T, View>>> {
    private List<ViewBinder<T, View>> mViewBinderList;
    private Context mContext;

    public ViewAdapter(Context context) {
        this.mContext = context;
        this.mViewBinderList = new ArrayList<ViewBinder<T, View>>();
    }

    public ViewHolder<T, ViewBinder<T, View>> onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(viewType, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(ViewHolder<T, ViewBinder<T, View>> holder, int position) {
        holder.bind(this.mViewBinderList.get(position), position);
    }

    public void onViewAttachedToWindow(ViewHolder<T, ViewBinder<T, View>> holder) {
        super.onViewAttachedToWindow(holder);
        if (holder.getLayoutPosition() > -1 && holder.getLayoutPosition() < this.mViewBinderList.size()) {
            this.mViewBinderList.get(holder.getLayoutPosition()).bindAnimation(Utils.getDeviceWidth((Context)this.mContext), Utils.getDeviceHeight((Context)this.mContext), holder.itemView);
        }
    }

    public int getItemViewType(int position) {
        return this.mViewBinderList.get(position).getLayoutId();
    }

    public int getItemCount() {
        return this.mViewBinderList.size();
    }

    protected void removeView(int position) throws IndexOutOfBoundsException {
        this.mViewBinderList.get(position).unbind();
        this.mViewBinderList.remove(position);
        this.notifyItemRemoved(position);
    }

    protected void addView(T viewResolver) throws IndexOutOfBoundsException {
        this.mViewBinderList.add(new ViewBinder(viewResolver));
        this.notifyItemInserted(this.mViewBinderList.size() - 1);
    }

    protected void removeView(T viewResolver) throws IndexOutOfBoundsException {
        int position = -1;
        for (ViewBinder<T, View> viewBinder : this.mViewBinderList) {
            if (viewBinder.getResolver() != viewResolver) continue;
            position = this.mViewBinderList.indexOf(viewBinder);
            break;
        }
        if (position != -1) {
            this.mViewBinderList.get(position).unbind();
            this.mViewBinderList.remove(position);
            this.notifyItemRemoved(position);
        }
    }

    protected void addView(int position, T viewResolver) throws IndexOutOfBoundsException {
        this.mViewBinderList.add(position, new ViewBinder(viewResolver));
        this.notifyItemInserted(position);
    }

    protected void addView(T resolverOld, T resolverNew, boolean after) throws Resources.NotFoundException {
        int position = -1;
        for (ViewBinder<T, View> viewBinder : this.mViewBinderList) {
            if (viewBinder.getResolver() != resolverOld) continue;
            position = this.mViewBinderList.indexOf(viewBinder);
            break;
        }
        if (position != -1) {
            if (after) {
                ++position;
            }
        } else {
            throw new Resources.NotFoundException("Old view don't Exists in the list");
        }
        this.mViewBinderList.add(position, new ViewBinder(resolverNew));
        this.notifyItemInserted(position);
    }

    protected List<ViewBinder<T, View>> getViewBinderList() {
        return this.mViewBinderList;
    }

    protected Context getContext() {
        return this.mContext;
    }

    protected int getViewBinderListSize() {
        return this.mViewBinderList.size();
    }

    protected T getViewResolverAtPosition(int position) throws IndexOutOfBoundsException {
        return (T)this.mViewBinderList.get(position).getResolver();
    }

    protected int getViewResolverPosition(T resolver) {
        for (int i = 0; i < this.mViewBinderList.size(); ++i) {
            if (this.mViewBinderList.get(i).getResolver() != resolver) continue;
            return i;
        }
        return -1;
    }

    protected List<T> getAllViewResolvers() {
        ArrayList<Object> resolverList = new ArrayList<Object>();
        for (ViewBinder<T, View> viewBinder : this.mViewBinderList) {
            resolverList.add(viewBinder.getResolver());
        }
        return resolverList;
    }

    protected void removeAllViewBinders() {
        for (ViewBinder<T, View> viewBinder : this.mViewBinderList) {
            viewBinder.unbind();
        }
        this.mViewBinderList.clear();
        this.notifyDataSetChanged();
    }

    protected void sort(List<T> sortedViewResolverList) {
        final HashMap<T, Integer> indexMap = new HashMap<T, Integer>();
        for (int i = 0; i < sortedViewResolverList.size(); ++i) {
            indexMap.put(sortedViewResolverList.get(i), i);
        }
        Collections.sort(this.mViewBinderList, new Comparator<ViewBinder<T, View>>(){

            @Override
            public int compare(ViewBinder<T, View> binder1, ViewBinder<T, View> binder2) {
                int index2;
                int index1 = (Integer)indexMap.get(binder1.getResolver());
                if (index1 > (index2 = ((Integer)indexMap.get(binder2.getResolver())).intValue())) {
                    return 1;
                }
                if (index1 < index2) {
                    return -1;
                }
                return 0;
            }
        });
        this.notifyDataSetChanged();
    }

    public void onViewRecycled(ViewHolder<T, ViewBinder<T, View>> holder) {
        super.onViewRecycled(holder);
        holder.recycle();
    }
}

