/*
 * Decompiled with CFR 0.152.
 */
package com.mindorks.placeholderview;

import android.content.Context;
import android.content.res.Resources;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import com.mindorks.placeholderview.PlaceHolderViewBuilder;
import com.mindorks.placeholderview.ViewAdapter;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PlaceHolderView
extends RecyclerView {
    public static final int DEFAULT_ITEM_VIEW_CACHE_SIZE = 10;
    public static final boolean DEFAULT_HAS_FIXED_SIZE = false;
    private ViewAdapter<Object> mViewAdapter;
    private PlaceHolderViewBuilder mBuilder;

    public PlaceHolderView(Context context) {
        super(context);
        this.setupView(context, new ViewAdapter(context), new PlaceHolderViewBuilder(context, this));
    }

    public PlaceHolderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setupView(context, new ViewAdapter(context), new PlaceHolderViewBuilder(context, this));
    }

    public PlaceHolderView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setupView(context, new ViewAdapter(context), new PlaceHolderViewBuilder(context, this));
    }

    protected void setupView(Context context, ViewAdapter viewAdapter, PlaceHolderViewBuilder builder) {
        this.mViewAdapter = viewAdapter;
        this.mBuilder = builder;
        super.setAdapter(this.mViewAdapter);
    }

    @Deprecated
    public void setAdapter(RecyclerView.Adapter adapter) {
        super.setAdapter(adapter);
    }

    private PlaceHolderViewBuilder builder() {
        return this.mBuilder;
    }

    public void refresh() {
        this.mViewAdapter.notifyDataSetChanged();
    }

    public <T> PlaceHolderView addView(T viewResolver) throws IndexOutOfBoundsException {
        this.mViewAdapter.addView(viewResolver);
        return this;
    }

    public <T> PlaceHolderView removeView(T viewResolver) throws IndexOutOfBoundsException {
        this.mViewAdapter.removeView(viewResolver);
        return this;
    }

    public <T> PlaceHolderView addView(int position, T viewResolver) throws IndexOutOfBoundsException {
        this.mViewAdapter.addView(position, viewResolver);
        return this;
    }

    public PlaceHolderView removeView(int position) throws IndexOutOfBoundsException {
        this.mViewAdapter.removeView(position);
        return this;
    }

    public <T> PlaceHolderView addViewBefore(T resolverOld, T resolverNew) throws Resources.NotFoundException {
        this.mViewAdapter.addView(resolverOld, resolverNew, false);
        return this;
    }

    public <T> PlaceHolderView addViewAfter(T resolverOld, T resolverNew) throws Resources.NotFoundException {
        this.mViewAdapter.addView(resolverOld, resolverNew, true);
        return this;
    }

    public int getViewResolverCount() {
        return this.mViewAdapter.getViewBinderListSize();
    }

    public Object getViewResolverAtPosition(int position) throws IndexOutOfBoundsException {
        return this.mViewAdapter.getViewResolverAtPosition(position);
    }

    public List<Object> getAllViewResolvers() {
        return this.mViewAdapter.getAllViewResolvers();
    }

    public PlaceHolderViewBuilder getBuilder() {
        return this.mBuilder;
    }

    public void removeAllViews() {
        super.removeAllViews();
        if (this.mViewAdapter != null) {
            this.mViewAdapter.removeAllViewBinders();
        }
    }

    public ViewAdapter<Object> getViewAdapter() {
        return this.mViewAdapter;
    }

    public <T> int getViewResolverPosition(T resolver) {
        return this.mViewAdapter.getViewResolverPosition(resolver);
    }

    public <T> void refreshView(T resolver) {
        int position = this.getViewResolverPosition(resolver);
        if (position != -1) {
            this.mViewAdapter.notifyItemChanged(position);
        }
    }

    public void refreshView(int position) {
        if (position >= 0) {
            this.mViewAdapter.notifyItemChanged(position);
        }
    }

    public void sort(Comparator<Object> comparator) {
        List<Object> viewResolverList = this.getAllViewResolvers();
        Collections.sort(viewResolverList, comparator);
        this.mViewAdapter.sort(viewResolverList);
    }
}

