/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialize.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.view.ViewCompat;
import com.mikepenz.materialize.R;

@SuppressLint(value={"InlinedApi"})
public class UIUtils {
    public static int getThemeColor(Context ctx, @AttrRes int attr2) {
        TypedValue tv = new TypedValue();
        if (ctx.getTheme().resolveAttribute(attr2, tv, true)) {
            return tv.resourceId != 0 ? ContextCompat.getColor((Context)ctx, (int)tv.resourceId) : tv.data;
        }
        return 0;
    }

    public static int getThemeColorFromAttrOrRes(Context ctx, @AttrRes int attr2, @ColorRes int res) {
        int color2 = UIUtils.getThemeColor(ctx, attr2);
        if (color2 == 0) {
            color2 = ResourcesCompat.getColor((Resources)ctx.getResources(), (int)res, (Resources.Theme)ctx.getTheme());
        }
        return color2;
    }

    @Deprecated
    @SuppressLint(value={"NewApi"})
    public static void setBackground(View v, Drawable d) {
        ViewCompat.setBackground((View)v, (Drawable)d);
    }

    public static void setBackground(View v, @DrawableRes int drawableRes) {
        ViewCompat.setBackground((View)v, (Drawable)ContextCompat.getDrawable((Context)v.getContext(), (int)drawableRes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getThemeAttributeDimensionSize(Context context, @AttrRes int attr2) {
        TypedArray a = null;
        try {
            a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
            int n = a.getDimensionPixelSize(0, 0);
            return n;
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    public static int getNavigationBarHeight(Context context) {
        Resources resources = context.getResources();
        int id2 = resources.getIdentifier(context.getResources().getConfiguration().orientation == 1 ? "navigation_bar_height" : "navigation_bar_height_landscape", "dimen", "android");
        if (id2 > 0) {
            return resources.getDimensionPixelSize(id2);
        }
        return 0;
    }

    public static int getActionBarHeight(Context context) {
        int actionBarHeight = UIUtils.getThemeAttributeDimensionSize(context, R.attr.actionBarSize);
        if (actionBarHeight == 0) {
            actionBarHeight = context.getResources().getDimensionPixelSize(R.dimen.abc_action_bar_default_height_material);
        }
        return actionBarHeight;
    }

    public static int getStatusBarHeight(Context context) {
        return UIUtils.getStatusBarHeight(context, false);
    }

    public static int getStatusBarHeight(Context context, boolean force) {
        int dimenResult;
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        if ((dimenResult = context.getResources().getDimensionPixelSize(R.dimen.tool_bar_top_padding)) == 0 && !force) {
            return 0;
        }
        return result == 0 ? dimenResult : result;
    }

    public static float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }

    public static void setTranslucentStatusFlag(Activity activity, boolean on) {
        if (Build.VERSION.SDK_INT >= 19) {
            UIUtils.setFlag(activity, 0x4000000, on);
        }
    }

    public static void setTranslucentNavigationFlag(Activity activity, boolean on) {
        if (Build.VERSION.SDK_INT >= 19) {
            UIUtils.setFlag(activity, 0x8000000, on);
        }
    }

    public static void setFlag(Activity activity, int bits, boolean on) {
        Window win = activity.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        winParams.flags = on ? (winParams.flags |= bits) : (winParams.flags &= ~bits);
        win.setAttributes(winParams);
    }

    public static StateListDrawable getIconStateList(Drawable icon, Drawable selectedIcon) {
        StateListDrawable iconStateListDrawable = new StateListDrawable();
        iconStateListDrawable.addState(new int[]{0x10100A1}, selectedIcon);
        iconStateListDrawable.addState(new int[0], icon);
        return iconStateListDrawable;
    }

    public static StateListDrawable getSelectableBackground(Context ctx, int selected_color, boolean animate) {
        StateListDrawable states = new StateListDrawable();
        ColorDrawable clrActive = new ColorDrawable(selected_color);
        states.addState(new int[]{0x10100A1}, (Drawable)clrActive);
        states.addState(new int[0], UIUtils.getSelectableBackground(ctx));
        if (animate) {
            int duration = ctx.getResources().getInteger(0x10E0000);
            states.setEnterFadeDuration(duration);
            states.setExitFadeDuration(duration);
        }
        return states;
    }

    public static StateListDrawable getSelectablePressedBackground(Context ctx, int selected_color, int pressed_alpha, boolean animate) {
        StateListDrawable states = UIUtils.getSelectableBackground(ctx, selected_color, animate);
        ColorDrawable clrPressed = new ColorDrawable(UIUtils.adjustAlpha(selected_color, pressed_alpha));
        states.addState(new int[]{16842919}, (Drawable)clrPressed);
        return states;
    }

    public static int adjustAlpha(int color2, int alpha) {
        return alpha << 24 | color2 & 0xFFFFFF;
    }

    public static int getSelectableBackgroundRes(Context ctx) {
        TypedValue outValue = new TypedValue();
        ctx.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
        return outValue.resourceId;
    }

    public static Drawable getSelectableBackground(Context ctx) {
        int selectableBackgroundRes = UIUtils.getSelectableBackgroundRes(ctx);
        return ContextCompat.getDrawable((Context)ctx, (int)selectableBackgroundRes);
    }

    public static int getScreenWidth(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return metrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return metrics.heightPixels;
    }
}

