/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialize.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import com.mikepenz.materialize.R;

@SuppressLint(value={"InlinedApi"})
public class UIUtils {
    public static int getThemeColor(Context ctx, int attr2) {
        TypedValue tv = new TypedValue();
        if (ctx.getTheme().resolveAttribute(attr2, tv, true)) {
            return tv.data;
        }
        return 0;
    }

    public static int getThemeColorFromAttrOrRes(Context ctx, int attr2, int res) {
        int color2 = UIUtils.getThemeColor(ctx, attr2);
        if (color2 == 0) {
            color2 = ctx.getResources().getColor(res);
        }
        return color2;
    }

    @SuppressLint(value={"NewApi"})
    public static void setBackground(View v, Drawable d) {
        if (Build.VERSION.SDK_INT < 16) {
            v.setBackgroundDrawable(d);
        } else {
            v.setBackground(d);
        }
    }

    public static void setBackground(View v, int drawableRes) {
        UIUtils.setBackground(v, UIUtils.getCompatDrawable(v.getContext(), drawableRes));
    }

    public static Drawable getCompatDrawable(Context c, int drawableRes) {
        Drawable d = null;
        try {
            d = Build.VERSION.SDK_INT < 21 ? c.getResources().getDrawable(drawableRes) : c.getResources().getDrawable(drawableRes, c.getTheme());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getThemeAttributeDimensionSize(Context context, int attr2) {
        TypedArray a = null;
        try {
            a = context.getTheme().obtainStyledAttributes(new int[]{attr2});
            int n = a.getDimensionPixelSize(0, 0);
            return n;
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
    }

    public static int getNavigationBarHeight(Context context) {
        Resources resources = context.getResources();
        int id2 = resources.getIdentifier(context.getResources().getConfiguration().orientation == 1 ? "navigation_bar_height" : "navigation_bar_height_landscape", "dimen", "android");
        if (id2 > 0) {
            return resources.getDimensionPixelSize(id2);
        }
        return 0;
    }

    public static int getActionBarHeight(Context context) {
        int actionBarHeight = UIUtils.getThemeAttributeDimensionSize(context, R.attr.actionBarSize);
        if (actionBarHeight == 0) {
            actionBarHeight = context.getResources().getDimensionPixelSize(R.dimen.abc_action_bar_default_height_material);
        }
        return actionBarHeight;
    }

    public static int getStatusBarHeight(Context context) {
        return UIUtils.getStatusBarHeight(context, false);
    }

    public static int getStatusBarHeight(Context context, boolean force) {
        int dimenResult;
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        if ((dimenResult = context.getResources().getDimensionPixelSize(R.dimen.tool_bar_top_padding)) == 0 && !force) {
            return 0;
        }
        return result == 0 ? dimenResult : result;
    }

    public static float convertDpToPixel(float dp, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return px;
    }

    public static float convertPixelsToDp(float px, Context context) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        float dp = px / ((float)metrics.densityDpi / 160.0f);
        return dp;
    }

    public static void setTranslucentStatusFlag(Activity activity, boolean on) {
        if (Build.VERSION.SDK_INT >= 19) {
            UIUtils.setFlag(activity, 0x4000000, on);
        }
    }

    public static void setTranslucentNavigationFlag(Activity activity, boolean on) {
        if (Build.VERSION.SDK_INT >= 19) {
            UIUtils.setFlag(activity, 0x8000000, on);
        }
    }

    public static void setFlag(Activity activity, int bits, boolean on) {
        Window win = activity.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        winParams.flags = on ? (winParams.flags |= bits) : (winParams.flags &= ~bits);
        win.setAttributes(winParams);
    }

    public static StateListDrawable getIconStateList(Drawable icon, Drawable selectedIcon) {
        StateListDrawable iconStateListDrawable = new StateListDrawable();
        iconStateListDrawable.addState(new int[]{0x10100A1}, selectedIcon);
        iconStateListDrawable.addState(new int[0], icon);
        return iconStateListDrawable;
    }
}

