/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleableRes;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.ColorUtils;
import com.mikepenz.materialdrawer.R;
import com.mikepenz.materialdrawer.util.UtilsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u001a$\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0003\u0010\r\u001a\u00020\f\u001a\f\u0010\u000e\u001a\u00020\f*\u00020\nH\u0000\u001a\f\u0010\u000f\u001a\u00020\f*\u00020\nH\u0007\u001a\f\u0010\u0010\u001a\u00020\b*\u00020\nH\u0000\u001a\f\u0010\u0011\u001a\u00020\b*\u00020\nH\u0000\u001a\f\u0010\u0012\u001a\u00020\b*\u00020\nH\u0000\u001a\f\u0010\u0013\u001a\u00020\b*\u00020\nH\u0000\u001a\f\u0010\u0014\u001a\u00020\f*\u00020\nH\u0000\u001a\f\u0010\u0015\u001a\u00020\b*\u00020\nH\u0000\u001a\f\u0010\u0016\u001a\u00020\b*\u00020\nH\u0000\u001a\u000e\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u00020\nH\u0000\u001a\u001e\u0010\u0017\u001a\u0004\u0018\u00010\u0019*\u00020\n2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u001a\f\u0010\u001d\u001a\u00020\f*\u00020\nH\u0000\u001a\f\u0010\u001e\u001a\u00020\f*\u00020\nH\u0001\u001a\u0016\u0010\u001f\u001a\u00020\f*\u00020\n2\b\b\u0003\u0010 \u001a\u00020\fH\u0001\u001a\u0016\u0010!\u001a\u00020\"*\u00020\n2\b\b\u0001\u0010#\u001a\u00020\fH\u0001\u001a\u0016\u0010$\u001a\u00020\f*\u00020\n2\b\b\u0001\u0010%\u001a\u00020\fH\u0000\u001a \u0010&\u001a\u00020\f*\u00020\n2\b\b\u0001\u0010%\u001a\u00020\f2\b\b\u0003\u0010 \u001a\u00020\fH\u0001\u001a \u0010'\u001a\u00020\f*\u00020\n2\b\b\u0001\u0010%\u001a\u00020\f2\b\b\u0001\u0010(\u001a\u00020\fH\u0001\u001a:\u0010)\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020\n2!\u0010+\u001a\u001d\u0012\u0013\u0012\u00110-\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(0\u0012\u0004\u0012\u0002H*0,H\u0000\u00a2\u0006\u0002\u00101\u001aX\u00102\u001a\u0002H*\"\u0004\b\u0000\u0010**\u00020\n2\b\b\u0002\u00103\u001a\u00020\u00012\b\b\u0002\u00104\u001a\u00020\f2\b\b\u0002\u00105\u001a\u00020\f2!\u0010+\u001a\u001d\u0012\u0013\u0012\u00110-\u00a2\u0006\f\b.\u0012\b\b/\u0012\u0004\b\b(0\u0012\u0004\u0012\u0002H*0,H\u0000\u00a2\u0006\u0002\u00106\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u00067"}, d2={"CHECKED_STATE_SET", "", "DISABLED_STATE_SET", "EMPTY_STATE_SET", "SELECTED_STATE_SET", "getSELECTED_STATE_SET", "()[I", "createDrawerItemColorStateList", "Landroid/content/res/ColorStateList;", "ctx", "Landroid/content/Context;", "styleableRes", "", "selectedStyleable", "getActionBarHeight", "getDividerColor", "getHeaderSelectionSubTextColor", "getHeaderSelectionTextColor", "getPrimaryDrawerIconColor", "getPrimaryDrawerTextColor", "getScreenWidth", "getSecondaryDrawerIconColor", "getSecondaryDrawerTextColor", "getSelectableBackground", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/StateListDrawable;", "selected_color", "animate", "", "getSelectableBackgroundRes", "getSelectedColor", "getSupportColor", "def", "getSupportFloat", "", "dimen", "getThemeAttributeDimensionSize", "attr", "getThemeColor", "getThemeColorFromAttrOrRes", "res", "resolveStyledHeaderValue", "T", "resolver", "Lkotlin/Function1;", "Landroid/content/res/TypedArray;", "Lkotlin/ParameterName;", "name", "typedArray", "(Landroid/content/Context;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "resolveStyledValue", "attrs", "defStyleAttr", "defStyleRes", "(Landroid/content/Context;[IIILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "materialdrawer"})
public final class UtilsKt {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    @NotNull
    private static final int[] SELECTED_STATE_SET = new int[]{0x10100A1};
    private static final int[] DISABLED_STATE_SET = new int[]{-16842910};
    private static final int[] EMPTY_STATE_SET = new int[0];

    @NotNull
    public static final int[] getSELECTED_STATE_SET() {
        return SELECTED_STATE_SET;
    }

    @NotNull
    public static final ColorStateList getPrimaryDrawerTextColor(@NotNull Context $this$getPrimaryDrawerTextColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getPrimaryDrawerTextColor, (String)"$this$getPrimaryDrawerTextColor");
        ColorStateList colorStateList = UtilsKt.createDrawerItemColorStateList$default($this$getPrimaryDrawerTextColor, R.styleable.MaterialDrawerSliderView_materialDrawerPrimaryText, 0, 4, null);
        Intrinsics.checkNotNull((Object)colorStateList);
        return colorStateList;
    }

    @NotNull
    public static final ColorStateList getPrimaryDrawerIconColor(@NotNull Context $this$getPrimaryDrawerIconColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getPrimaryDrawerIconColor, (String)"$this$getPrimaryDrawerIconColor");
        ColorStateList colorStateList = UtilsKt.createDrawerItemColorStateList$default($this$getPrimaryDrawerIconColor, R.styleable.MaterialDrawerSliderView_materialDrawerPrimaryIcon, 0, 4, null);
        Intrinsics.checkNotNull((Object)colorStateList);
        return colorStateList;
    }

    @NotNull
    public static final ColorStateList getSecondaryDrawerTextColor(@NotNull Context $this$getSecondaryDrawerTextColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getSecondaryDrawerTextColor, (String)"$this$getSecondaryDrawerTextColor");
        ColorStateList colorStateList = UtilsKt.createDrawerItemColorStateList$default($this$getSecondaryDrawerTextColor, R.styleable.MaterialDrawerSliderView_materialDrawerSecondaryText, 0, 4, null);
        Intrinsics.checkNotNull((Object)colorStateList);
        return colorStateList;
    }

    @NotNull
    public static final ColorStateList getSecondaryDrawerIconColor(@NotNull Context $this$getSecondaryDrawerIconColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getSecondaryDrawerIconColor, (String)"$this$getSecondaryDrawerIconColor");
        ColorStateList colorStateList = UtilsKt.createDrawerItemColorStateList$default($this$getSecondaryDrawerIconColor, R.styleable.MaterialDrawerSliderView_materialDrawerSecondaryIcon, 0, 4, null);
        Intrinsics.checkNotNull((Object)colorStateList);
        return colorStateList;
    }

    @Nullable
    public static final ColorStateList createDrawerItemColorStateList(@NotNull Context ctx, @StyleableRes int styleableRes, @StyleableRes int selectedStyleable) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        TypedArray typedArray = ctx.obtainStyledAttributes(null, R.styleable.MaterialDrawerSliderView, R.attr.materialDrawerStyle, R.style.Widget_MaterialDrawerStyle);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"ctx.obtainStyledAttribut\u2026dget_MaterialDrawerStyle)");
        TypedArray a = typedArray;
        ColorStateList colorStateList = a.getColorStateList(styleableRes);
        if (colorStateList == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)colorStateList, (String)"a.getColorStateList(styleableRes) ?: return null");
        ColorStateList baseColor = colorStateList;
        int selectedColor = a.getColor(selectedStyleable, UtilsKt.getThemeColor$default(ctx, R.attr.colorPrimary, 0, 2, null));
        a.recycle();
        int defaultColor = baseColor.getDefaultColor();
        return new ColorStateList((int[][])new int[][]{DISABLED_STATE_SET, CHECKED_STATE_SET, SELECTED_STATE_SET, EMPTY_STATE_SET}, new int[]{baseColor.getColorForState(DISABLED_STATE_SET, defaultColor), selectedColor, selectedColor, defaultColor});
    }

    public static /* synthetic */ ColorStateList createDrawerItemColorStateList$default(Context context, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = R.styleable.MaterialDrawerSliderView_materialDrawerSelectedBackgroundColor;
        }
        return UtilsKt.createDrawerItemColorStateList(context, n, n2);
    }

    @ColorInt
    public static final int getDividerColor(@NotNull Context $this$getDividerColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getDividerColor, (String)"$this$getDividerColor");
        return ((Number)UtilsKt.resolveStyledValue$default($this$getDividerColor, null, 0, 0, (Function1)new Function1<TypedArray, Integer>($this$getDividerColor){
            final /* synthetic */ Context $this_getDividerColor;

            public final int invoke(@NotNull TypedArray it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getColor(R.styleable.MaterialDrawerSliderView_materialDrawerDividerColor, UtilsKt.getThemeColor(this.$this_getDividerColor, R.attr.materialDrawerDividerColor, UtilsKt.getSupportColor(this.$this_getDividerColor, R.color.material_drawer_divider)));
            }
            {
                this.$this_getDividerColor = context;
                super(1);
            }
        }, 7, null)).intValue();
    }

    @ColorInt
    public static final int getSelectedColor(@NotNull Context $this$getSelectedColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectedColor, (String)"$this$getSelectedColor");
        int color2 = ((Number)UtilsKt.resolveStyledValue$default($this$getSelectedColor, null, 0, 0, (Function1)new Function1<TypedArray, Integer>($this$getSelectedColor){
            final /* synthetic */ Context $this_getSelectedColor;

            public final int invoke(@NotNull TypedArray it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getColor(R.styleable.MaterialDrawerSliderView_materialDrawerSelectedBackgroundColor, UtilsKt.getThemeColor(this.$this_getSelectedColor, R.attr.materialDrawerSelectedBackgroundColor, UtilsKt.getSupportColor(this.$this_getSelectedColor, R.color.material_drawer_selected)));
            }
            {
                this.$this_getSelectedColor = context;
                super(1);
            }
        }, 7, null)).intValue();
        return ColorUtils.setAlphaComponent((int)color2, (int)((int)((float)255 * UtilsKt.getSupportFloat($this$getSelectedColor, R.dimen.material_drawer_selected_background_alpha))));
    }

    @NotNull
    public static final ColorStateList getHeaderSelectionTextColor(@NotNull Context $this$getHeaderSelectionTextColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getHeaderSelectionTextColor, (String)"$this$getHeaderSelectionTextColor");
        Object t = UtilsKt.resolveStyledHeaderValue($this$getHeaderSelectionTextColor, getHeaderSelectionTextColor.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(t, (String)"resolveStyledHeaderValue\u2026derSelectionText)!!\n    }");
        return (ColorStateList)t;
    }

    @NotNull
    public static final ColorStateList getHeaderSelectionSubTextColor(@NotNull Context $this$getHeaderSelectionSubTextColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getHeaderSelectionSubTextColor, (String)"$this$getHeaderSelectionSubTextColor");
        Object t = UtilsKt.resolveStyledHeaderValue($this$getHeaderSelectionSubTextColor, getHeaderSelectionSubTextColor.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(t, (String)"resolveStyledHeaderValue\u2026SelectionSubtext)!!\n    }");
        return (ColorStateList)t;
    }

    public static final <T> T resolveStyledHeaderValue(@NotNull Context $this$resolveStyledHeaderValue, @NotNull Function1<? super TypedArray, ? extends T> resolver) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveStyledHeaderValue, (String)"$this$resolveStyledHeaderValue");
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.AccountHeaderView, (String)"R.styleable.AccountHeaderView");
        return UtilsKt.resolveStyledValue($this$resolveStyledHeaderValue, R.styleable.AccountHeaderView, R.attr.materialDrawerHeaderStyle, R.style.Widget_MaterialDrawerHeaderStyle, resolver);
    }

    public static final <T> T resolveStyledValue(@NotNull Context $this$resolveStyledValue, @NotNull int[] attrs, int defStyleAttr, int defStyleRes, @NotNull Function1<? super TypedArray, ? extends T> resolver) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveStyledValue, (String)"$this$resolveStyledValue");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        TypedArray typedArray = $this$resolveStyledValue.obtainStyledAttributes(null, attrs, defStyleAttr, defStyleRes);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(n\u2026efStyleAttr, defStyleRes)");
        TypedArray a = typedArray;
        Object value = resolver.invoke((Object)a);
        a.recycle();
        return (T)value;
    }

    public static /* synthetic */ Object resolveStyledValue$default(Context context, int[] nArray, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 1) != 0) {
            Intrinsics.checkNotNullExpressionValue((Object)R.styleable.MaterialDrawerSliderView, (String)"R.styleable.MaterialDrawerSliderView");
            nArray = R.styleable.MaterialDrawerSliderView;
        }
        if ((n3 & 2) != 0) {
            n = R.attr.materialDrawerStyle;
        }
        if ((n3 & 4) != 0) {
            n2 = R.style.Widget_MaterialDrawerStyle;
        }
        return UtilsKt.resolveStyledValue(context, nArray, n, n2, function1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int getSupportColor(@NotNull Context $this$getSupportColor, @ColorRes int def) {
        Intrinsics.checkNotNullParameter((Object)$this$getSupportColor, (String)"$this$getSupportColor");
        return ContextCompat.getColor((Context)$this$getSupportColor, (int)def);
    }

    public static /* synthetic */ int getSupportColor$default(Context context, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return UtilsKt.getSupportColor(context, n);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final float getSupportFloat(@NotNull Context $this$getSupportFloat, @DimenRes int dimen2) {
        Intrinsics.checkNotNullParameter((Object)$this$getSupportFloat, (String)"$this$getSupportFloat");
        return ResourcesCompat.getFloat((Resources)$this$getSupportFloat.getResources(), (int)dimen2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int getThemeColor(@NotNull Context $this$getThemeColor, @AttrRes int attr2, @ColorInt int def) {
        Intrinsics.checkNotNullParameter((Object)$this$getThemeColor, (String)"$this$getThemeColor");
        TypedValue tv = new TypedValue();
        return $this$getThemeColor.getTheme().resolveAttribute(attr2, tv, true) ? (tv.resourceId != 0 ? ResourcesCompat.getColor((Resources)$this$getThemeColor.getResources(), (int)tv.resourceId, (Resources.Theme)$this$getThemeColor.getTheme()) : tv.data) : def;
    }

    public static /* synthetic */ int getThemeColor$default(Context context, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return UtilsKt.getThemeColor(context, n, n2);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int getThemeColorFromAttrOrRes(@NotNull Context $this$getThemeColorFromAttrOrRes, @AttrRes int attr2, @ColorRes int res) {
        Intrinsics.checkNotNullParameter((Object)$this$getThemeColorFromAttrOrRes, (String)"$this$getThemeColorFromAttrOrRes");
        int color2 = UtilsKt.getThemeColor$default($this$getThemeColorFromAttrOrRes, attr2, 0, 2, null);
        if (color2 == 0) {
            color2 = ResourcesCompat.getColor((Resources)$this$getThemeColorFromAttrOrRes.getResources(), (int)res, (Resources.Theme)$this$getThemeColorFromAttrOrRes.getTheme());
        }
        return color2;
    }

    public static final int getSelectableBackgroundRes(@NotNull Context $this$getSelectableBackgroundRes) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectableBackgroundRes, (String)"$this$getSelectableBackgroundRes");
        TypedValue outValue = new TypedValue();
        $this$getSelectableBackgroundRes.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
        return outValue.resourceId;
    }

    @Nullable
    public static final Drawable getSelectableBackground(@NotNull Context $this$getSelectableBackground) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectableBackground, (String)"$this$getSelectableBackground");
        int selectableBackgroundRes = UtilsKt.getSelectableBackgroundRes($this$getSelectableBackground);
        return ContextCompat.getDrawable((Context)$this$getSelectableBackground, (int)selectableBackgroundRes);
    }

    @Nullable
    public static final StateListDrawable getSelectableBackground(@NotNull Context $this$getSelectableBackground, int selected_color, boolean animate) {
        Intrinsics.checkNotNullParameter((Object)$this$getSelectableBackground, (String)"$this$getSelectableBackground");
        StateListDrawable states = new StateListDrawable();
        ColorDrawable clrActive = new ColorDrawable(selected_color);
        states.addState(new int[]{0x10100A1}, (Drawable)clrActive);
        states.addState(new int[0], UtilsKt.getSelectableBackground($this$getSelectableBackground));
        if (animate) {
            int duration = $this$getSelectableBackground.getResources().getInteger(0x10E0000);
            states.setEnterFadeDuration(duration);
            states.setExitFadeDuration(duration);
        }
        return states;
    }

    public static final int getScreenWidth(@NotNull Context $this$getScreenWidth) {
        Intrinsics.checkNotNullParameter((Object)$this$getScreenWidth, (String)"$this$getScreenWidth");
        Resources resources = $this$getScreenWidth.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return metrics.widthPixels;
    }

    public static final int getActionBarHeight(@NotNull Context $this$getActionBarHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$getActionBarHeight, (String)"$this$getActionBarHeight");
        int actionBarHeight = UtilsKt.getThemeAttributeDimensionSize($this$getActionBarHeight, R.attr.actionBarSize);
        if (actionBarHeight == 0) {
            actionBarHeight = $this$getActionBarHeight.getResources().getDimensionPixelSize(R.dimen.abc_action_bar_default_height_material);
        }
        return actionBarHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getThemeAttributeDimensionSize(@NotNull Context $this$getThemeAttributeDimensionSize, @AttrRes int attr2) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getThemeAttributeDimensionSize, (String)"$this$getThemeAttributeDimensionSize");
        TypedArray a = null;
        try {
            a = $this$getThemeAttributeDimensionSize.getTheme().obtainStyledAttributes(new int[]{attr2});
            n = a.getDimensionPixelSize(0, 0);
        }
        finally {
            TypedArray typedArray = a;
            if (typedArray != null) {
                typedArray.recycle();
            }
        }
        return n;
    }
}

